/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.CatalanRule;

public class ComplexAdjectiveConcordanceRule
extends CatalanRule {
    private static final Pattern NOM = Pattern.compile("N.*");
    private static final Pattern NOM_DET = Pattern.compile("N.*|D[NDA0I].*");
    private static final Pattern _GN_ = Pattern.compile("_GN_.*");
    private static final Pattern _GN_MS = Pattern.compile("_GN_MS");
    private static final Pattern _GN_FS = Pattern.compile("_GN_FS");
    private static final Pattern _GN_MP = Pattern.compile("_GN_MP");
    private static final Pattern _GN_FP = Pattern.compile("_GN_FP");
    private static final Pattern _GN_CS = Pattern.compile("_GN_[MF]S");
    private static final Pattern _GN_CP = Pattern.compile("_GN_[MF]P");
    private static final Pattern NOM_MS = Pattern.compile("N.[M][S].*");
    private static final Pattern NOM_FS = Pattern.compile("N.[F][S].*");
    private static final Pattern NOM_MP = Pattern.compile("N.[M][P].*");
    private static final Pattern NOM_FP = Pattern.compile("N.[F][P].*");
    private static final Pattern DET_CS = Pattern.compile("D[NDA0I]0CS0");
    private static final Pattern DET_MS = Pattern.compile("D[NDA0I]0MS0");
    private static final Pattern DET_FS = Pattern.compile("D[NDA0I]0FS0");
    private static final Pattern DET_MP = Pattern.compile("D[NDA0I]0MP0");
    private static final Pattern DET_FP = Pattern.compile("D[NDA0I]0FP0");
    private static final Pattern GN_MS = Pattern.compile("N.[MC][SN].*|D[NDA0I]0MS0");
    private static final Pattern GN_FS = Pattern.compile("N.[FC][SN].*|D[NDA0I]0FS0");
    private static final Pattern GN_MP = Pattern.compile("N.[MC][PN].*|D[NDA0I]0MP0");
    private static final Pattern GN_FP = Pattern.compile("N.[FC][PN].*|D[NDA0I]0FP0");
    private static final Pattern GN_CP = Pattern.compile("N.[FMC][PN].*|D[NDA0I]0[FM]P0");
    private static final Pattern GN_CS = Pattern.compile("N.[FMC][SN].*|D[NDA0I]0[FM]S0");
    private static final Pattern ADJECTIU = Pattern.compile("AQ.*|V.P.*|PX.*|.*LOC_ADJ.*");
    private static final Pattern ADJECTIU_MS = Pattern.compile("A..[MC][SN].*|V.P..SM.?|PX.MS.*");
    private static final Pattern ADJECTIU_FS = Pattern.compile("A..[FC][SN].*|V.P..SF.?|PX.FS.*");
    private static final Pattern ADJECTIU_MP = Pattern.compile("A..[MC][PN].*|V.P..PM.?|PX.MP.*");
    private static final Pattern ADJECTIU_FP = Pattern.compile("A..[FC][PN].*|V.P..PF.?|PX.FP.*");
    private static final Pattern ADJECTIU_CP = Pattern.compile("A..C[PN].*");
    private static final Pattern ADJECTIU_CS = Pattern.compile("A..C[SN].*");
    private static final Pattern ADJECTIU_S = Pattern.compile("A...[SN].*|V.P..S..?|PX..S.*");
    private static final Pattern ADJECTIU_P = Pattern.compile("A...[PN].*|V.P..P..?|PX..P.*");
    private static final Pattern ADVERBI = Pattern.compile("R.|.*LOC_ADV.*");
    private static final Pattern LOC_ADV = Pattern.compile(".*LOC_ADV.*");
    private static final Pattern ADVERBIS_ACCEPTATS = Pattern.compile("RG_anteposat");
    private static final Pattern CONCORDA = Pattern.compile("_GN_.*|ignore_concordance");
    private static final Pattern UPPERCASE = Pattern.compile("\\p{Lu}[\\p{Ll}\u00b7]*");
    private static final Pattern COORDINACIO = Pattern.compile(",|i|o");
    private static final Pattern COORDINACIO_IONI = Pattern.compile("i|o|ni");
    private static final Pattern KEEP_COUNT = Pattern.compile("A.*|N.*|D[NAID].*|SPS.*|.*LOC_ADV.*|V.P.*|_PUNCT.*|.*LOC_ADJ.*|PX.*|complement");
    private static final Pattern KEEP_COUNT2 = Pattern.compile(",|i|o|ni|\\d+%?|%");
    private static final Pattern STOP_COUNT = Pattern.compile(";");
    private static final Pattern PREPOSICIONS = Pattern.compile("SPS.*");
    private static final Pattern PREPOSICIO_CANVI_NIVELL = Pattern.compile("de|d'|en|sobre|a|entre|per|pe|amb");
    private static final Pattern VERB = Pattern.compile("V.[^P].*|_GV_");
    private static final Pattern EXCEPCIONS_PARTICIPI = Pattern.compile("at\u00e8s|at\u00e9s|atesa|atesos|ateses|donat|donats|donada|donades");
    private static final Pattern EXCEPCIONS_PREVIA = Pattern.compile("termes?|paraul(a|es)|mots?|vocables?|expressi(\u00f3|ons)|noms?|tipus|denominaci(\u00f3|ons)");

    public ComplexAdjectiveConcordanceRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category("Z) Concordances en grups nominals"));
        }
    }

    public String getId() {
        return "CONCORDANCES_ADJECTIU_POSPOSAT";
    }

    public String getDescription() {
        return "Comprova si un adjectiu concorda amb els noms previs.";
    }

    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            Matcher pCoordina;
            int j;
            if (!this.matchPostagRegexp(tokens[i], ADJECTIU) || this.matchPostagRegexp(tokens[i], CONCORDA)) continue;
            String token = tokens[i].getToken();
            String prevToken = tokens[i - 1].getToken();
            String prevPrevToken = "";
            if (i > 2) {
                prevPrevToken = tokens[i - 2].getToken();
            }
            String nextToken = "";
            if (i < tokens.length - 1) {
                nextToken = tokens[i + 1].getToken();
            }
            boolean adjectiveAgrees = false;
            boolean theRuleMaches = false;
            boolean isException = false;
            boolean isPlural = true;
            boolean isPrevNoun = false;
            Pattern substPattern = null;
            Pattern gnPattern = null;
            Pattern adjPattern = null;
            Matcher isUpperCase = UPPERCASE.matcher(token);
            int maxLevels = 4;
            int[] cNt = new int[maxLevels];
            int[] cNMS = new int[maxLevels];
            int[] cNFS = new int[maxLevels];
            int[] cNMP = new int[maxLevels];
            int[] cNFP = new int[maxLevels];
            int[] cDMS = new int[maxLevels];
            int[] cDFS = new int[maxLevels];
            int[] cDMP = new int[maxLevels];
            int[] cDFP = new int[maxLevels];
            int[] cN = new int[maxLevels];
            int[] cD = new int[maxLevels];
            for (j = 0; j < maxLevels; ++j) {
                cNt[j] = 0;
                cNMS[j] = 0;
                cNFS[j] = 0;
                cNMP[j] = 0;
                cNFP[j] = 0;
                cDMS[j] = 0;
                cDFS[j] = 0;
                cDMP[j] = 0;
                cDFP[j] = 0;
                cN[j] = 0;
                cD[j] = 0;
            }
            int level = 0;
            j = 1;
            boolean keepCounting = true;
            while (keepCounting && i - j > 0 && level < maxLevels) {
                if (!isPrevNoun) {
                    if (this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], _GN_MS)) {
                        int n = level;
                        cNMS[n] = cNMS[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], _GN_FS)) {
                        int n = level;
                        cNFS[n] = cNFS[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], _GN_MP)) {
                        int n = level;
                        cNMP[n] = cNMP[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], _GN_FP)) {
                        int n = level;
                        cNFP[n] = cNFP[n] + 1;
                    }
                    if (!this.matchPostagRegexp(tokens[i - j], _GN_)) {
                        if (this.matchPostagRegexp(tokens[i - j], NOM_MS)) {
                            int n = level;
                            cNMS[n] = cNMS[n] + 1;
                        } else if (this.matchPostagRegexp(tokens[i - j], NOM_FS)) {
                            int n = level;
                            cNFS[n] = cNFS[n] + 1;
                        } else if (this.matchPostagRegexp(tokens[i - j], NOM_MP)) {
                            int n = level;
                            cNMP[n] = cNMP[n] + 1;
                        } else if (this.matchPostagRegexp(tokens[i - j], NOM_FP)) {
                            int n = level;
                            cNFP[n] = cNFP[n] + 1;
                        }
                    }
                }
                if (this.matchPostagRegexp(tokens[i - j], NOM)) {
                    int n = level;
                    cNt[n] = cNt[n] + 1;
                    isPrevNoun = true;
                } else {
                    isPrevNoun = false;
                }
                if (this.matchPostagRegexp(tokens[i - j], DET_CS)) {
                    if (this.matchPostagRegexp(tokens[i - j + 1], NOM_MS)) {
                        int n = level;
                        cDMS[n] = cDMS[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j + 1], NOM_FS)) {
                        int n = level;
                        cDFS[n] = cDFS[n] + 1;
                    }
                }
                if (!this.matchPostagRegexp(tokens[i - j], ADVERBI)) {
                    if (this.matchPostagRegexp(tokens[i - j], DET_MS)) {
                        int n = level;
                        cDMS[n] = cDMS[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], DET_FS)) {
                        int n = level;
                        cDFS[n] = cDFS[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], DET_MP)) {
                        int n = level;
                        cDMP[n] = cDMP[n] + 1;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], DET_FP)) {
                        int n = level;
                        cDFP[n] = cDFP[n] + 1;
                    }
                }
                if (i - j > 0 && this.matchRegexp(tokens[i - j].getToken(), PREPOSICIO_CANVI_NIVELL) && !this.matchRegexp(tokens[i - j - 1].getToken(), COORDINACIO_IONI) && !this.matchPostagRegexp(tokens[i - j + 1], ADVERBI)) {
                    ++level;
                }
                if (level > 0 && this.matchRegexp(tokens[i - j].getToken(), COORDINACIO_IONI)) {
                    for (int k = 1; k < 4 && i - j - k > 0 && (this.matchPostagRegexp(tokens[i - j - k], KEEP_COUNT) || this.matchRegexp(tokens[i - j - k].getToken(), KEEP_COUNT2) || this.matchPostagRegexp(tokens[i - j - k], ADVERBIS_ACCEPTATS)) && !this.matchRegexp(tokens[i - j - k].getToken(), STOP_COUNT); ++k) {
                        if (!this.matchPostagRegexp(tokens[i - j - k], PREPOSICIONS)) continue;
                        j += k;
                        break;
                    }
                }
                keepCounting = (this.matchPostagRegexp(tokens[i - ++j], KEEP_COUNT) || this.matchRegexp(tokens[i - j].getToken(), KEEP_COUNT2) || this.matchPostagRegexp(tokens[i - j], ADVERBIS_ACCEPTATS)) && !this.matchRegexp(tokens[i - j].getToken(), STOP_COUNT);
            }
            if (++level > maxLevels) {
                level = maxLevels;
            }
            int cNtotal = 0;
            int cDtotal = 0;
            for (j = 0; j < level; ++j) {
                cN[j] = cNMS[j] + cNFS[j] + cNMP[j] + cNFP[j];
                cD[j] = cDMS[j] + cDFS[j] + cDMP[j] + cDFP[j];
                cNtotal += cN[j];
                cDtotal += cD[j];
                if (this.matchPostagRegexp(tokens[i], ADJECTIU_MP) && (cN[j] > 1 || cD[j] > 1) && cNMS[j] + cNMP[j] + cDMS[j] + cDMP[j] > 0 && cNFS[j] + cNFP[j] <= cNt[j]) {
                    isException = true;
                    break;
                }
                if (!isException && this.matchPostagRegexp(tokens[i], ADJECTIU_FP) && (cN[j] > 1 || cD[j] > 1) && (cNMS[j] + cNMP[j] + cDMS[j] + cDMP[j] == 0 || cNt[j] > 0 && cNFS[j] + cNFP[j] >= cNt[j])) {
                    isException = true;
                    break;
                }
                if (cN[j] + cD[j] <= 0) continue;
                isPlural = isPlural && cD[j] > 1;
            }
            if (cNtotal == 0 && cDtotal == 0) {
                isException = true;
            }
            if (!isException && i < tokens.length - 2 && (pCoordina = COORDINACIO.matcher(nextToken)).matches() && ((this.matchPostagRegexp(tokens[i - 1], NOM_MP) || this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MP)) && this.matchPostagRegexp(tokens[i], ADJECTIU_MS) && this.matchPostagRegexp(tokens[i + 2], ADJECTIU_MS) || (this.matchPostagRegexp(tokens[i - 1], NOM_MP) || this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MP)) && this.matchPostagRegexp(tokens[i], ADJECTIU_MP) && this.matchPostagRegexp(tokens[i + 2], ADJECTIU_MP) || (this.matchPostagRegexp(tokens[i - 1], NOM_FP) || this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FP)) && this.matchPostagRegexp(tokens[i], ADJECTIU_FS) && this.matchPostagRegexp(tokens[i + 2], ADJECTIU_FS) || (this.matchPostagRegexp(tokens[i - 1], NOM_FP) || this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FP)) && this.matchPostagRegexp(tokens[i], ADJECTIU_FP) && this.matchPostagRegexp(tokens[i + 2], ADJECTIU_FP))) {
                isException = true;
            }
            if (!isException && this.matchRegexp(prevToken, EXCEPCIONS_PREVIA)) {
                isException = true;
            }
            if (!isException && ((token.equals("tret") || token.equals("llevat")) && nextToken.equals("de") || token.equals("primer") || token.equals("junts") || isUpperCase.matches())) {
                isException = true;
            }
            if (!isException && this.matchRegexp(token, EXCEPCIONS_PARTICIPI)) {
                isException = true;
            }
            if (!isException && (prevPrevToken.equals("un") && prevToken.equals("cop") || prevToken.equals("colp") || prevPrevToken.equals("una") && prevToken.equals("volta") || prevToken.equals("vegada"))) {
                isException = true;
            }
            if (!isException && i < tokens.length - 1 && (token.equals("segur") || token.equals("major") || token.equals("menor")) && nextToken.equals("que")) {
                isException = true;
            }
            if (!isException && token.equals("mateix") && this.matchPostagRegexp(tokens[i - 1], ADVERBI)) {
                isException = true;
            }
            if (!isException) {
                if (this.matchPostagRegexp(tokens[i], ADJECTIU_CS)) {
                    substPattern = GN_CS;
                    adjPattern = ADJECTIU_S;
                    gnPattern = _GN_CS;
                } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_CP)) {
                    substPattern = GN_CP;
                    adjPattern = ADJECTIU_P;
                    gnPattern = _GN_CP;
                } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_MS)) {
                    substPattern = GN_MS;
                    adjPattern = ADJECTIU_MS;
                    gnPattern = _GN_MS;
                } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_FS)) {
                    substPattern = GN_FS;
                    adjPattern = ADJECTIU_FS;
                    gnPattern = _GN_FS;
                } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_MP)) {
                    substPattern = GN_MP;
                    adjPattern = ADJECTIU_MP;
                    gnPattern = _GN_MP;
                } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_FP)) {
                    substPattern = GN_FP;
                    adjPattern = ADJECTIU_FP;
                    gnPattern = _GN_FP;
                }
                if (substPattern != null) {
                    j = 1;
                    keepCounting = true;
                    while (i - j > 0 && !isException && keepCounting) {
                        if (gnPattern != null && this.matchPostagRegexp(tokens[i - j], NOM_DET) && this.matchPostagRegexp(tokens[i - j], gnPattern)) {
                            isException = true;
                        } else if (!this.matchPostagRegexp(tokens[i - j], _GN_) && this.matchPostagRegexp(tokens[i - j], substPattern)) {
                            isException = true;
                        }
                        keepCounting = !this.matchPostagRegexp(tokens[i - j], NOM_DET);
                        ++j;
                    }
                    if (!isException && (this.matchPostagRegexp(tokens[i - 1], NOM) && !this.matchPostagRegexp(tokens[i - 1], substPattern) || i > 2 && (this.matchPostagRegexp(tokens[i - 1], ADJECTIU) && !this.matchPostagRegexp(tokens[i - 1], adjPattern) || this.matchPostagRegexp(tokens[i - 1], ADVERBIS_ACCEPTATS) || this.matchPostagRegexp(tokens[i - 1], LOC_ADV)) && !this.matchPostagRegexp(tokens[i - 2], VERB) && !this.matchPostagRegexp(tokens[i - 3], VERB))) {
                        j = 1;
                        keepCounting = true;
                        while (i - j > 0 && !adjectiveAgrees && keepCounting) {
                            if (gnPattern != null && this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], gnPattern)) {
                                adjectiveAgrees = true;
                            } else if (!this.matchPostagRegexp(tokens[i - j], _GN_) && this.matchPostagRegexp(tokens[i - j], substPattern)) {
                                adjectiveAgrees = true;
                            }
                            keepCounting = (this.matchPostagRegexp(tokens[i - ++j], KEEP_COUNT) || this.matchRegexp(tokens[i - j].getToken(), KEEP_COUNT2) || this.matchPostagRegexp(tokens[i - j], ADVERBIS_ACCEPTATS)) && !this.matchRegexp(tokens[i - j].getToken(), STOP_COUNT);
                        }
                        boolean bl = theRuleMaches = !adjectiveAgrees;
                        if (isPlural && this.matchPostagRegexp(tokens[i], ADJECTIU_S)) {
                            theRuleMaches = true;
                        }
                    }
                }
            }
            if (!theRuleMaches) continue;
            String msg = "Reviseu la concordan\u00e7a de la paraula \u00ab" + token + "\u00bb.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), msg, "Reviseu la concordan\u00e7a.");
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        int readingsLen = aToken.getReadingsLength();
        for (int i = 0; i < readingsLen; ++i) {
            Matcher m;
            String posTag = aToken.getAnalyzedToken(i).getPOSTag();
            if (posTag == null || !(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private boolean matchRegexp(String s, Pattern pattern) {
        Matcher m = pattern.matcher(s);
        return m.matches();
    }

    public void reset() {
    }
}

