/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.GenericUnpairedBracketsRule;

public class CatalanUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final String[] CA_START_SYMBOLS = new String[]{"[", "(", "{", "\u201c", "\u00ab"};
    private static final String[] CA_END_SYMBOLS = new String[]{"]", ")", "}", "\u201d", "\u00bb"};
    private static final Pattern VALID_BEFORE_CLOSING_PARENTHESIS = Pattern.compile("\\d+|[a-zA-Z]", 64);

    public CatalanUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.startSymbols = CA_START_SYMBOLS;
        this.endSymbols = CA_END_SYMBOLS;
        this.uniqueMapInit();
    }

    public String getId() {
        return "CA_UNPAIRED_BRACKETS";
    }

    protected boolean isNoException(String tokenStr, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace) {
        boolean superException;
        if (i < 1) {
            return true;
        }
        boolean bl = superException = !super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace);
        if (superException) {
            return false;
        }
        if (i == 1 && tokenStr.equals("\u00bb")) {
            return false;
        }
        if (i > 1 && tokenStr.equals(")")) {
            Matcher mValidBeforeClosingParenthesis;
            boolean isThereOpeningParenthesis = false;
            int k = 1;
            while (i - k > 0 && !tokens[i - k].getToken().equals(")")) {
                if (tokens[i - k].getToken().equals("(")) {
                    isThereOpeningParenthesis = true;
                    break;
                }
                ++k;
            }
            if (!isThereOpeningParenthesis && (mValidBeforeClosingParenthesis = VALID_BEFORE_CLOSING_PARENTHESIS.matcher(tokens[i - 1].getToken())).matches()) {
                return false;
            }
        }
        return true;
    }
}

