/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.br;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfMonth(String dayStr) {
        Object day = dayStr.toLowerCase();
        if (((String)day).charAt(0) == 't') {
            day = "d" + ((String)day).substring(1);
        }
        if (((String)day).charAt(0) == 'p') {
            day = "b" + ((String)day).substring(1);
        }
        if (((String)day).endsWith("vet")) {
            day = ((String)day).substring(0, ((String)day).length() - 3);
        }
        if (((String)day).equals("c\u2019henta\u00f1") || ((String)day).equals("unan")) {
            return 1;
        }
        if (((String)day).equals("daou") || ((String)day).equals("eil")) {
            return 2;
        }
        if (((String)day).equals("dri") || ((String)day).equals("drede") || ((String)day).equals("deir")) {
            return 3;
        }
        if (((String)day).equals("bevar")) {
            return 4;
        }
        if (((String)day).equals("bemp") || ((String)day).equals("bem")) {
            return 5;
        }
        if (((String)day).equals("c\u2019hwerc\u2019h")) {
            return 6;
        }
        if (((String)day).equals("seizh")) {
            return 7;
        }
        if (((String)day).equals("eizh")) {
            return 8;
        }
        if (((String)day).equals("nav") || ((String)day).equals("na")) {
            return 9;
        }
        if (((String)day).equals("dek")) {
            return 10;
        }
        if (((String)day).equals("unnek")) {
            return 11;
        }
        if (((String)day).equals("daouzek")) {
            return 12;
        }
        if (((String)day).equals("drizek")) {
            return 13;
        }
        if (((String)day).equals("bevarzek")) {
            return 14;
        }
        if (((String)day).equals("bemzek")) {
            return 15;
        }
        if (((String)day).equals("c\u2019hwezek")) {
            return 16;
        }
        if (((String)day).equals("seitek")) {
            return 17;
        }
        if (((String)day).equals("driwec\u2019h")) {
            return 18;
        }
        if (((String)day).equals("naontek")) {
            return 19;
        }
        if (((String)day).equals("ugent")) {
            return 20;
        }
        if (((String)day).equals("dregont")) {
            return 30;
        }
        return 0;
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.endsWith("sul")) {
            return 1;
        }
        if (day.endsWith("lun")) {
            return 2;
        }
        if (day.endsWith("meurzh")) {
            return 3;
        }
        if (day.endsWith("merc\u2019her")) {
            return 4;
        }
        if (day.equals("yaou")) {
            return 5;
        }
        if (day.equals("diriaou")) {
            return 5;
        }
        if (day.endsWith("gwener")) {
            return 6;
        }
        if (day.endsWith("sadorn")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "Sul";
        }
        if (englishDay.equals("Monday")) {
            return "Lun";
        }
        if (englishDay.equals("Tuesday")) {
            return "Meurzh";
        }
        if (englishDay.equals("Wednesday")) {
            return "Merc\u2019her";
        }
        if (englishDay.equals("Thursday")) {
            return "Yaou";
        }
        if (englishDay.equals("Friday")) {
            return "Gwener";
        }
        if (englishDay.equals("Saturday")) {
            return "Sadorn";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.equals("genver")) {
            return 1;
        }
        if (mon.equals("c\u2019hwevrer")) {
            return 2;
        }
        if (mon.equals("meurzh")) {
            return 3;
        }
        if (mon.equals("ebrel")) {
            return 4;
        }
        if (mon.equals("mae")) {
            return 5;
        }
        if (mon.equals("mezheven") || mon.equals("even")) {
            return 6;
        }
        if (mon.equals("gouere") || mon.equals("gouhere")) {
            return 7;
        }
        if (mon.equals("eost")) {
            return 8;
        }
        if (mon.equals("gwengolo")) {
            return 9;
        }
        if (mon.equals("here")) {
            return 10;
        }
        if (mon.equals("du")) {
            return 11;
        }
        if (mon.equals("kerzu")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

