/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar.filters;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SimpleReplaceDataLoader;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.ar.ArabicTagger;

public class ArabicVerbToMafoulMutlaqFilter
extends RuleFilter {
    private final ArabicTagger tagger = new ArabicTagger();
    private static final String FILE_NAME = "/ar/arabic_verb_masdar.txt";
    private Map<String, List<String>> verb2masdarList;
    private final ArabicSynthesizer synthesizer = new ArabicSynthesizer((Language)new Arabic());
    private final Map<String, String> verb2masdar = new HashMap<String, String>(){
        {
            this.put("\u0639\u064e\u0645\u0650\u0644\u064e", "\u0639\u0645\u0644");
            this.put("\u0623\u064e\u0639\u0652\u0645\u064e\u0644\u064e", "\u0625\u0639\u0645\u0627\u0644");
            this.put("\u0639\u064e\u0645\u0651\u064e\u0644\u064e", "\u062a\u0639\u0645\u064a\u0644");
            this.put("\u0623\u064e\u0643\u064e\u0644\u064e", "\u0623\u0643\u0644");
            this.put("\u0633\u064e\u0623\u064e\u0644\u064e", "\u0633\u0624\u0627\u0644");
            this.put("\u0623\u064e\u062c\u064e\u0627\u0628\u064e", "\u0625\u062c\u0627\u0628\u0629");
        }
    };

    public ArabicVerbToMafoulMutlaqFilter() {
        this.verb2masdarList = ArabicVerbToMafoulMutlaqFilter.loadFromPath(FILE_NAME);
    }

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        String verb = arguments.get("verb");
        List<String> verbLemmas = this.tagger.getLemmas(patternTokens[0], "verb");
        String adj = arguments.get("adj");
        ArrayList<String> inflectedMasdarList = new ArrayList<String>();
        ArrayList<String> inflectedAdjList = new ArrayList<String>();
        String inflectedAdjMasculine = ArabicSynthesizer.inflectAdjectiveTanwinNasb(adj, false);
        String inflectedAdjfeminin = ArabicSynthesizer.inflectAdjectiveTanwinNasb(adj, true);
        for (String lemma : verbLemmas) {
            List<String> msdrLemmaList = this.verb2masdarList.get(lemma);
            if (msdrLemmaList == null) continue;
            for (String msdr : msdrLemmaList) {
                if (msdr == null) continue;
                String inflectedMasdar = ArabicSynthesizer.inflectMafoulMutlq(msdr);
                inflectedMasdarList.add(inflectedMasdar);
                String inflectedAdj = msdr.endsWith(Character.toString('\u0629')) ? inflectedAdjfeminin : inflectedAdjMasculine;
                inflectedAdjList.add(inflectedAdj);
            }
        }
        RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        int i = 0;
        ArrayList<CallSite> suggestionPhrases = new ArrayList<CallSite>();
        for (String msdr : inflectedMasdarList) {
            String sugPhrase = verb + " " + msdr + " " + (String)inflectedAdjList.get(i);
            if (!suggestionPhrases.contains(sugPhrase)) {
                newMatch.addSuggestedReplacement(sugPhrase);
                suggestionPhrases.add((CallSite)((Object)sugPhrase));
            }
            ++i;
        }
        return newMatch;
    }

    protected static Map<String, List<String>> loadFromPath(String path) {
        return new SimpleReplaceDataLoader().loadWords(path);
    }
}

