/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.tagging.ar.ArabicTagManager;
import org.languagetool.tagging.ar.ArabicTagger;

public class ArabicSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/ar/arabic_synth.dict";
    private static final String TAGS_FILE_NAME = "/ar/arabic_tags.txt";
    private final ArabicTagManager tagmanager = new ArabicTagManager();
    private final ArabicTagger tagger = new ArabicTagger();
    public static final ArabicSynthesizer INSTANCE = new ArabicSynthesizer();

    public ArabicSynthesizer(Language lang) {
        this();
    }

    private ArabicSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME, "ar");
    }

    public String[] synthesize(AnalyzedToken token, String posTag) {
        IStemmer synthesizer = this.createStemmer();
        List wordData = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            String stem = this.correctStem(wd.getStem().toString(), posTag);
            wordForms.add(stem);
        }
        return wordForms.toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag != null && posTagRegExp) {
            String myPosTag = posTag;
            this.initPossibleTags();
            myPosTag = this.correctTag(myPosTag);
            Pattern p = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches() || token.getLemma() == null) continue;
                List resultOne = this.lookup(token.getLemma(), tag);
                for (String wd : resultOne) {
                    String stem = this.correctStem(wd, posTag);
                    results.add(stem);
                }
            }
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    public String correctTag(String postag) {
        String mypostag = postag;
        if (postag == null) {
            return null;
        }
        mypostag = this.tagmanager.setConjunction(mypostag, "-");
        mypostag = this.tagmanager.setDefinite(mypostag, "-");
        mypostag = this.tagmanager.unifyPronounTag(mypostag);
        return mypostag;
    }

    public String getPosTagCorrection(String posTag) {
        return this.correctTag(posTag);
    }

    public String correctStem(String stem, String postag) {
        String prefix;
        Object correctStem = stem;
        if (postag == null) {
            return stem;
        }
        if (this.tagmanager.isAttached(postag)) {
            correctStem = StringUtils.removeEnd((String)correctStem, (String)"\u0647");
        }
        if (this.tagmanager.isDefinite(postag)) {
            prefix = this.tagmanager.getDefinitePrefix(postag);
            correctStem = prefix + (String)correctStem;
        }
        if (this.tagmanager.hasJar(postag)) {
            prefix = this.tagmanager.getJarPrefix(postag);
            correctStem = prefix + (String)correctStem;
        }
        if (this.tagmanager.hasConjunction(postag)) {
            prefix = this.tagmanager.getConjunctionPrefix(postag);
            correctStem = prefix + (String)correctStem;
        }
        return correctStem;
    }

    public String setEnclitic(AnalyzedToken token, String suffix) {
        List<String> wordlist = this.setEncliticMultiple(token, suffix);
        return wordlist.get(0);
    }

    public List<String> setEncliticMultiple(AnalyzedToken token, String suffix) {
        String postag = token.getPOSTag();
        String word = token.getToken();
        ArrayList<String> defaultWordlist = new ArrayList<String>();
        defaultWordlist.add("(" + word + ")");
        if (postag.isEmpty()) {
            return defaultWordlist;
        }
        ArrayList<String> wordlist = new ArrayList<String>();
        char flag = suffix.isEmpty() ? (char)'-' : 'H';
        String procletic = this.tagger.getProclitic(token);
        String newposTag = this.tagmanager.setFlag(postag, "PRONOUN", flag);
        newposTag = this.tagmanager.setProcleticFlags(newposTag);
        String lemma = token.getLemma();
        AnalyzedToken newToken = new AnalyzedToken(lemma, newposTag, lemma);
        String[] newwordList = this.synthesize(newToken, newposTag);
        Object stem = "";
        if (newwordList.length != 0) {
            Object newWord = "";
            for (int i = 0; i < newwordList.length; ++i) {
                stem = newwordList[i];
                if (this.tagmanager.hasPronoun(newposTag) && flag == 'H') {
                    if (((String)stem).endsWith("\u064a")) {
                        newWord = suffix.equals("\u064a") ? procletic + (String)stem : "";
                    } else if (((String)stem).endsWith("\u0647")) {
                        stem = StringUtils.removeEnd((String)stem, (String)"\u0647");
                        newWord = procletic + (String)stem + suffix;
                    } else {
                        newWord = procletic + (String)stem + suffix;
                    }
                } else {
                    newWord = procletic + (String)stem;
                }
                if (((String)newWord).isEmpty()) continue;
                wordlist.add((String)newWord);
            }
        } else {
            stem = "(" + word + ")";
            wordlist.add((String)stem);
        }
        if (wordlist.isEmpty()) {
            return defaultWordlist;
        }
        return wordlist;
    }

    public String setJarProcletic(AnalyzedToken token, String prefix) {
        String postag = token.getPOSTag();
        String word = token.getToken();
        if (postag.isEmpty()) {
            return word;
        }
        if (this.tagmanager.isDefinite(postag)) {
            prefix = ((String)prefix).equals("\u0644") ? (String)prefix + "\u0644" : (String)prefix + "\u0627\u0644";
        }
        return this.setProcletic(token, (String)prefix);
    }

    public String setProcletic(AnalyzedToken token, String prefix) {
        String postag = token.getPOSTag();
        String word = token.getToken();
        if (postag.isEmpty()) {
            return word;
        }
        String enclitic = this.tagger.getEnclitic(token);
        String newposTag = postag;
        newposTag = this.tagmanager.setProcleticFlags(newposTag);
        String lemma = token.getLemma();
        AnalyzedToken newToken = new AnalyzedToken(lemma, newposTag, lemma);
        String[] newwordList = this.synthesize(newToken, newposTag);
        Object stem = "";
        if (newwordList.length != 0) {
            stem = newwordList[0];
            if (this.tagmanager.hasPronoun(newposTag)) {
                stem = StringUtils.removeEnd((String)stem, (String)"\u0647");
            }
        } else {
            stem = "(" + word + ")";
        }
        return prefix + (String)stem + enclitic;
    }

    public List<String> inflectLemmaLike(String targetLemma, AnalyzedToken sourcetoken) {
        AnalyzedTokenReadings tokenReadList = this.tagger.tag(targetLemma);
        ArrayList<String> wordlist = new ArrayList<String>();
        if (!tokenReadList.hasLemma(targetLemma)) {
            wordlist.add("[" + targetLemma + "]");
            return wordlist;
        }
        String sourcePostag = sourcetoken.getPOSTag();
        String prefix = this.tagger.getProclitic(sourcetoken);
        String suffix = this.tagger.getEnclitic(sourcetoken);
        ArrayList<AnalyzedToken> tokenListFiltred = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken currentToken : tokenReadList.getReadings()) {
            if (!targetLemma.equals(currentToken.getLemma())) continue;
            tokenListFiltred.add(currentToken);
        }
        for (AnalyzedToken currentToken : tokenListFiltred) {
            String postagLemma = currentToken.getPOSTag();
            String mergedPostag = this.tagmanager.mergePosTag(sourcePostag, postagLemma);
            String word = prefix + targetLemma;
            AnalyzedToken token = new AnalyzedToken(word, mergedPostag, targetLemma);
            List<String> wordlist2 = this.setEncliticMultiple(token, suffix);
            wordlist.addAll(wordlist2);
        }
        ArrayList<String> resultWordlist = new ArrayList<String>(new HashSet<String>(wordlist));
        return resultWordlist;
    }

    public static String inflectMafoulMutlq(String word) {
        if (word == null) {
            return word;
        }
        Object newword = word;
        newword = word.endsWith(Character.toString('\u0629')) ? (String)newword + "\u064b" : (String)newword + "\u064b\u0627";
        return newword;
    }

    public static String inflectAdjectiveTanwinNasb(String word, boolean feminin) {
        if (word == null) {
            return word;
        }
        Object newword = word;
        newword = feminin ? (word.endsWith(Character.toString('\u0629')) ? (String)newword + "\u064b" : (String)newword + Character.toString('\u0629') + "\u064b") : (word.endsWith(Character.toString('\u0629')) ? word.replace(Character.toString('\u0629'), "") : (String)newword + Character.toString('\u064b') + "\u0627");
        return newword;
    }
}

