/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SimpleReplaceDataLoader;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.ar.ArabicTagger;

public class ArabicMasdarToVerbFilter
extends RuleFilter {
    private final ArabicTagger tagger = new ArabicTagger();
    private static final String FILE_NAME = "/ar/arabic_masdar_verb.txt";
    private Map<String, List<String>> masdar2verbList;
    private final ArabicSynthesizer synthesizer = new ArabicSynthesizer((Language)new Arabic());
    final List<String> authorizeLemma = new ArrayList(){
        {
            this.add("\u0642\u064e\u0627\u0645\u064e");
        }
    };
    private final Map<String, String> masdar2verb = new HashMap<String, String>(){
        {
            this.put("\u0639\u0645\u0644", "\u0639\u064e\u0645\u0650\u0644\u064e");
            this.put("\u0625\u0639\u0645\u0627\u0644", "\u0623\u064e\u0639\u0652\u0645\u064e\u0644\u064e");
            this.put("\u062a\u0639\u0645\u064a\u0644", "\u0639\u064e\u0645\u0651\u064e\u0644\u064e");
            this.put("\u0636\u0631\u0628", "\u0636\u064e\u0631\u064e\u0628\u064e");
            this.put("\u0623\u0643\u0644", "\u0623\u064e\u0643\u064e\u0644\u064e");
            this.put("\u0625\u062c\u0627\u0628\u0629", "\u0623\u064e\u062c\u064e\u0627\u0628\u064e");
        }
    };

    public ArabicMasdarToVerbFilter() {
        this.masdar2verbList = ArabicMasdarToVerbFilter.loadFromPath(FILE_NAME);
    }

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        String auxVerb = arguments.get("verb");
        String masdar = arguments.get("noun");
        List<String> auxVerbLemmasAll = this.tagger.getLemmas(patternTokens[0], "verb");
        List<String> auxVerbLemmas = this.filterLemmas(auxVerbLemmasAll);
        List<String> masdarLemmas = this.tagger.getLemmas(patternTokens[1], "masdar");
        ArrayList<String> verbList = new ArrayList<String>();
        for (AnalyzedToken auxVerbToken : patternTokens[0]) {
            if (!auxVerbLemmas.contains(auxVerbToken.getLemma())) continue;
            for (String lemma : masdarLemmas) {
                List<String> verbLemmaList = this.masdar2verbList.get(lemma);
                if (verbLemmaList == null) continue;
                for (String vrbLem : verbLemmaList) {
                    List<String> inflectedverbList = this.synthesizer.inflectLemmaLike(vrbLem, auxVerbToken);
                    verbList.addAll(inflectedverbList);
                }
            }
        }
        verbList = new ArrayList(new HashSet(verbList));
        RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        for (String verb : verbList) {
            newMatch.addSuggestedReplacement(verb);
        }
        return newMatch;
    }

    List<String> filterLemmas(List<String> lemmas) {
        ArrayList<String> filtred = new ArrayList<String>();
        for (String lem : this.authorizeLemma) {
            if (!lemmas.contains(lem)) continue;
            filtred.add(lem);
        }
        return filtred;
    }

    protected static Map<String, List<String>> loadFromPath(String path) {
        return new SimpleReplaceDataLoader().loadWords(path);
    }
}

