/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.ar.ArabicTagger;

public class ArabicInflectedOneWordReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_INFLECTED_ONE_WORD_REPLACE = "AR_INFLECTED_ONE_WORD";
    private static final String FILE_NAME = "/ar/inflected_one_word.txt";
    private static final Locale AR_LOCALE = new Locale("ar");
    private final ArabicTagger tagger = new ArabicTagger();
    private final ArabicSynthesizer synthesizer;
    private final List<Map<String, SuggestionWithMessage>> wrongWords;

    public ArabicInflectedOneWordReplaceRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        this.tagger.enableNewStylePronounTag();
        this.synthesizer = new ArabicSynthesizer(new Arabic());
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Inconsistency);
        this.addExamplePair(Example.wrong((String)"\u0623\u062c\u0631\u064a\u062a <marker>\u0623\u0628\u062d\u0627\u062b\u0627</marker> \u0641\u064a \u0627\u0644\u0645\u062e\u0628\u0631"), Example.fixed((String)"\u0623\u062c\u0631\u064a\u062a <marker>\u0628\u062d\u0648\u062b\u0627</marker> \u0641\u064a \u0627\u0644\u0645\u062e\u0628\u0631."));
        this.wrongWords = this.getWrongWords();
    }

    public String getId() {
        return AR_INFLECTED_ONE_WORD_REPLACE;
    }

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public String getDescription() {
        return "\u0642\u0627\u0639\u062f\u0629 \u062a\u0637\u0627\u0628\u0642 \u0627\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u062a\u064a \u064a\u062c\u0628 \u062a\u062c\u0646\u0628\u0647\u0627 \u0648\u062a\u0642\u062a\u0631\u062d \u062a\u0635\u0648\u064a\u0628\u0627 \u0644\u0647\u0627";
    }

    public String getShort() {
        return "\u062e\u0637\u0623\u060c \u064a\u0641\u0636\u0644 \u0623\u0646  \u064a\u0642\u0627\u0644:";
    }

    public String getMessage() {
        return " \u0644\u0627 \u062a\u0642\u0644 '$match' \u0628\u0644 \u0642\u0644: $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648 ";
    }

    public Locale getLocale() {
        return AR_LOCALE;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.wrongWords.size() == 0) {
            return this.toRuleMatchArray(ruleMatches);
        }
        for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
            for (AnalyzedToken wordTok : token.getReadings()) {
                boolean isCandidateWord = this.isCandidateWord(wordTok);
                if (!isCandidateWord) continue;
                List<Object> propositions = new ArrayList();
                String sugMsg = "";
                SuggestionWithMessage propositionsWithMessage = this.getSuggestedWords(wordTok);
                if (propositionsWithMessage != null) {
                    propositions = Arrays.asList(propositionsWithMessage.getSuggestion().split("\\|"));
                    sugMsg = propositionsWithMessage.getMessage();
                    sugMsg = sugMsg != null ? sugMsg : "";
                }
                StringBuilder replacement = new StringBuilder("");
                for (String string : propositions) {
                    List<String> inflectedWordList = this.inflectSuggestedWords(string, wordTok);
                    for (String w : inflectedWordList) {
                        replacement.append("<suggestion>" + w + "</suggestion>&nbsp;");
                    }
                }
                String msg = "' \u0627\u0644\u0643\u0644\u0645\u0629 \u062e\u0627\u0637\u0626\u0629 " + token.getToken() + " ' \u060c" + sugMsg + ". \u0627\u0633\u062a\u0639\u0645\u0644  " + replacement;
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), token.getStartPos(), token.getEndPos(), msg, "\u062e\u0637\u0623 \u0641\u064a \u0627\u0633\u062a\u0639\u0645\u0627\u0644 \u0643\u0644\u0645\u0629:" + sugMsg);
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isCandidateWord(AnalyzedToken mytoken) {
        return this.getSuggestedWords(mytoken) != null;
    }

    private SuggestionWithMessage getSuggestedWords(AnalyzedToken mytoken) {
        SuggestionWithMessage wordLemmaMatch;
        AnalyzedToken wordTok = mytoken;
        String wordLemma = wordTok.getLemma();
        String wordPostag = wordTok.getPOSTag();
        if (wordPostag != null && (wordLemmaMatch = this.wrongWords.get(this.wrongWords.size() - 1).get(wordLemma)) != null) {
            return wordLemmaMatch;
        }
        return null;
    }

    private List<String> inflectSuggestedWords(String targetLemma, AnalyzedToken sourcetoken) {
        return this.synthesizer.inflectLemmaLike(targetLemma, sourcetoken);
    }
}

