/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SimpleReplaceDataLoader;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.ar.ArabicTagger;
import org.languagetool.tools.ArabicWordMaps;

public class ArabicAdjectiveToExclamationFilter
extends RuleFilter {
    private final ArabicTagger tagger = new ArabicTagger();
    private static final String FILE_NAME = "/ar/arabic_adjective_exclamation.txt";
    private final Map<String, List<String>> adj2compList;
    private final Map<String, String> adj2comp = new HashMap<String, String>(){
        {
            this.put("\u0631\u0634\u064a\u062f", "\u0623\u0631\u0634\u062f");
            this.put("\u0637\u0648\u064a\u0644", "\u0623\u0637\u0648\u0644");
            this.put("\u0628\u062f\u064a\u0639", "\u0623\u0628\u062f\u0639");
        }
    };

    public ArabicAdjectiveToExclamationFilter() {
        this.adj2compList = ArabicAdjectiveToExclamationFilter.loadFromPath(FILE_NAME);
    }

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        int adjTokenIndex;
        String adj = arguments.get("adj");
        String noun = arguments.get("noun");
        try {
            adjTokenIndex = Integer.parseInt(arguments.get("adj_pos")) - 1;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing adj_pos from : " + arguments.get("adj_pos"), e);
        }
        List<String> adjLemmas = this.tagger.getLemmas(patternTokens[adjTokenIndex], "adj");
        ArrayList<String> compList = new ArrayList<String>();
        for (String adjLemma : adjLemmas) {
            List<String> comparativeList = this.adj2compList.get(adjLemma);
            if (comparativeList == null) continue;
            compList.addAll(comparativeList);
        }
        compList = new ArrayList(new HashSet(compList));
        RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        List<String> suggestionList = ArabicAdjectiveToExclamationFilter.prepareSuggestions(compList, noun);
        for (String sug : suggestionList) {
            newMatch.addSuggestedReplacement(sug);
        }
        return newMatch;
    }

    protected static List<String> prepareSuggestions(List<String> compList, String noun) {
        ArrayList<String> sugList = new ArrayList<String>();
        for (String comp : compList) {
            sugList.addAll(ArabicAdjectiveToExclamationFilter.prepareSuggestions(comp, noun));
        }
        return sugList;
    }

    protected static List<String> prepareSuggestions(String comp, String noun) {
        ArrayList<String> sugList = new ArrayList<String>();
        StringBuilder suggestion = new StringBuilder();
        suggestion.append(comp);
        if (noun != null && !noun.isEmpty()) {
            if (ArabicAdjectiveToExclamationFilter.isPronoun(noun)) {
                suggestion.append(ArabicWordMaps.getAttachedPronoun(noun));
            } else {
                if (!comp.endsWith(" \u0628")) {
                    suggestion.append(" ");
                }
                suggestion.append(noun);
            }
        }
        sugList.add(suggestion.toString());
        return sugList;
    }

    private static boolean isPronoun(String word) {
        if (word == null) {
            return false;
        }
        return word.equals("\u0647\u0648") || word.equals("\u0647\u064a") || word.equals("\u0647\u0645") || word.equals("\u0647\u0645\u0627") || word.equals("\u0623\u0646\u0627");
    }

    private static String getAttachedPronoun(String word) {
        if (word == null) {
            return "";
        }
        HashMap<String, String> isolatedToAttachedPronoun = new HashMap<String, String>();
        isolatedToAttachedPronoun.put("\u0647\u0648", "\u0647");
        isolatedToAttachedPronoun.put("\u0647\u064a", "\u0647\u0627");
        isolatedToAttachedPronoun.put("\u0647\u0645", "\u0647\u0645");
        isolatedToAttachedPronoun.put("\u0647\u0646", "\u0647\u0646");
        isolatedToAttachedPronoun.put("\u0646\u062d\u0646", "\u0646\u0627");
        return isolatedToAttachedPronoun.getOrDefault(word, "");
    }

    protected static Map<String, List<String>> loadFromPath(String path) {
        return new SimpleReplaceDataLoader().loadWords(path);
    }

    public static String getDataFilePath() {
        return FILE_NAME;
    }
}

