/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;

public class ArabicSimpleReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String RULE_ID = "AR_SIMPLE_REPLACE";
    private static final String RESOURCE_FILENAME = "ar/replaces.txt";

    public ArabicSimpleReplaceRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        super.setCategory(Categories.CONFUSED_WORDS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>\u0627\u0644\u0649</marker>"), Example.fixed((String)"<marker>\u0625\u0644\u0649</marker>"));
    }

    public List<String> getFileNames() {
        return Collections.singletonList(RESOURCE_FILENAME);
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "\u0642\u0627\u0639\u062f\u0629 \u062a\u0637\u0627\u0628\u0642 \u0627\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u062a\u064a \u064a\u062c\u0628 \u062a\u062c\u0646\u0628\u0647\u0627 \u0648\u062a\u0642\u062a\u0631\u062d \u062a\u0635\u0648\u064a\u0628\u0627 \u0644\u0647\u0627";
    }

    public String getShort() {
        return "\u062e\u0637\u0623\u060c \u064a\u0641\u0636\u0644 \u0623\u0646  \u064a\u0642\u0627\u0644:";
    }

    public boolean isDictionaryBasedSpellingRule() {
        return false;
    }

    public String getMessage() {
        return "\u0642\u0644 $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648  ";
    }

    public Locale getLocale() {
        return new Locale("ar");
    }
}

