/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.ar.ArabicTagManager;
import org.languagetool.tools.ArabicStringTools;

public class ArabicTagger
extends BaseTagger {
    private final ArabicTagManager tagmanager = new ArabicTagManager();
    private boolean newStylePronounTag = false;

    public ArabicTagger() {
        super("/ar/arabic.dict", new Locale("ar"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String striped = ArabicStringTools.removeTashkeel(word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(striped));
            this.addTokens(taggerTokens, l);
            if (!this.isStopWord(taggerTokens)) {
                this.addTokens(this.additionalTags(word, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        String striped = ArabicStringTools.removeTashkeel(word);
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        List<Integer> prefix_index_list = this.getPrefixIndexList(striped);
        List<Integer> suffix_index_list = this.getSuffixIndexList(striped);
        for (int i : prefix_index_list) {
            for (int j : suffix_index_list) {
                if (i == 0 && j == striped.length()) continue;
                List<String> stemsList = this.getStem(striped, i, j);
                List<String> tags = this.getTags(striped, i, j);
                for (String stem : stemsList) {
                    List taggerTokens = this.asAnalyzedTokenList(stem, stemmer.lookup((CharSequence)stem));
                    for (AnalyzedToken taggerToken : taggerTokens) {
                        String posTag = taggerToken.getPOSTag();
                        if ((posTag = this.tagmanager.modifyPosTag(posTag, tags)) == null) continue;
                        additionalTaggedTokens.add(new AnalyzedToken(word, posTag, taggerToken.getLemma()));
                    }
                }
            }
        }
        return additionalTaggedTokens;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }

    private List<Integer> getSuffixIndexList(String possibleWord) {
        ArrayList<Integer> suffix_indexes = new ArrayList<Integer>();
        suffix_indexes.add(possibleWord.length());
        int suffix_pos = possibleWord.length();
        if (possibleWord.endsWith("\u0643") || possibleWord.endsWith("\u0647\u0627") || possibleWord.endsWith("\u0647\u0645\u0627") || possibleWord.endsWith("\u0643\u0645\u0627") || possibleWord.endsWith("\u0647\u0645") || possibleWord.endsWith("\u0647\u0646") || possibleWord.endsWith("\u0643\u0645") || possibleWord.endsWith("\u0643\u0646") || possibleWord.endsWith("\u0646\u0627")) {
            suffix_pos = possibleWord.endsWith("\u0643") ? --suffix_pos : (possibleWord.endsWith("\u0647\u0645\u0627") || possibleWord.endsWith("\u0643\u0645\u0627") ? (suffix_pos -= 3) : (suffix_pos -= 2));
            suffix_indexes.add(suffix_pos);
        }
        return suffix_indexes;
    }

    private List<Integer> getPrefixIndexList(String possibleWord) {
        int prefix_pos;
        ArrayList<Integer> prefix_indexes = new ArrayList<Integer>();
        prefix_indexes.add(0);
        if (possibleWord.startsWith("\u0648\u0643\u0627\u0644") || possibleWord.startsWith("\u0648\u0628\u0627\u0644") || possibleWord.startsWith("\u0641\u0643\u0627\u0644") || possibleWord.startsWith("\u0641\u0628\u0627\u0644")) {
            prefix_pos = 4;
            prefix_indexes.add(prefix_pos);
        }
        if (possibleWord.startsWith("\u0648\u0644\u0644") || possibleWord.startsWith("\u0641\u0644\u0644") || possibleWord.startsWith("\u0641\u0627\u0644") || possibleWord.startsWith("\u0648\u0627\u0644") || possibleWord.startsWith("\u0628\u0627\u0644") || possibleWord.startsWith("\u0643\u0627\u0644")) {
            prefix_pos = 3;
            prefix_indexes.add(prefix_pos);
        }
        if (possibleWord.startsWith("\u0644\u0644") || possibleWord.startsWith("\u0648\u0643") || possibleWord.startsWith("\u0648\u0644") || possibleWord.startsWith("\u0648\u0628") || possibleWord.startsWith("\u0641\u0643") || possibleWord.startsWith("\u0641\u0644") || possibleWord.startsWith("\u0641\u0628") || possibleWord.startsWith("\u0627\u0644") || possibleWord.startsWith("\u0641\u0633\u0623") || possibleWord.startsWith("\u0641\u0633\u0646") || possibleWord.startsWith("\u0641\u0633\u064a") || possibleWord.startsWith("\u0641\u0633\u062a") || possibleWord.startsWith("\u0648\u0633\u0623") || possibleWord.startsWith("\u0648\u0633\u0646") || possibleWord.startsWith("\u0648\u0633\u064a") || possibleWord.startsWith("\u0648\u0633\u062a")) {
            prefix_pos = 2;
            prefix_indexes.add(prefix_pos);
        }
        if (possibleWord.startsWith("\u0643") || possibleWord.startsWith("\u0644") || possibleWord.startsWith("\u0628") || possibleWord.startsWith("\u0648") || possibleWord.startsWith("\u0641") || possibleWord.startsWith("\u0633\u0623") || possibleWord.startsWith("\u0633\u0646") || possibleWord.startsWith("\u0633\u064a") || possibleWord.startsWith("\u0633\u062a")) {
            prefix_pos = 1;
            prefix_indexes.add(prefix_pos);
        }
        return prefix_indexes;
    }

    private List<String> getTags(String word, int posStart, int posEnd) {
        ArrayList<String> tags = new ArrayList<String>();
        String prefix = this.getPrefix(word, posStart);
        String suffix = this.getSuffix(word, posEnd);
        if (prefix.startsWith("\u0648") || prefix.startsWith("\u0641")) {
            tags.add("CONJ;W");
            prefix = prefix.replaceAll("^[\u0648\u0641]", "");
        }
        if (prefix.startsWith("\u0643")) {
            tags.add("JAR;K");
        } else if (prefix.startsWith("\u0644")) {
            tags.add("JAR;L");
        } else if (prefix.startsWith("\u0628")) {
            tags.add("JAR;B");
        } else if (prefix.startsWith("\u0633")) {
            tags.add("ISTIQBAL;S");
        }
        if (prefix.endsWith("\u0627\u0644") || prefix.endsWith("\u0644\u0644")) {
            tags.add("PRONOUN;D");
        }
        if (!this.newStylePronounTag) {
            switch (suffix) {
                case "\u0646\u064a": 
                case "\u0646\u0627": 
                case "\u0643": 
                case "\u0643\u0645\u0627": 
                case "\u0643\u0645": 
                case "\u0643\u0646": 
                case "\u0647": 
                case "\u0647\u0627": 
                case "\u0647\u0645\u0627": 
                case "\u0647\u0645": 
                case "\u0647\u0646": {
                    tags.add("PRONOUN;H");
                }
            }
        } else {
            switch (suffix) {
                case "\u0646\u064a": {
                    tags.add("PRONOUN;b");
                    break;
                }
                case "\u0646\u0627": {
                    tags.add("PRONOUN;c");
                    break;
                }
                case "\u0643": {
                    tags.add("PRONOUN;d");
                    break;
                }
                case "\u0643\u0645\u0627": {
                    tags.add("PRONOUN;e");
                    break;
                }
                case "\u0643\u0645": {
                    tags.add("PRONOUN;f");
                    break;
                }
                case "\u0643\u0646": {
                    tags.add("PRONOUN;g");
                    break;
                }
                case "\u0647": {
                    tags.add("PRONOUN;H");
                    break;
                }
                case "\u0647\u0627": {
                    tags.add("PRONOUN;i");
                    break;
                }
                case "\u0647\u0645\u0627": {
                    tags.add("PRONOUN;j");
                    break;
                }
                case "\u0647\u0645": {
                    tags.add("PRONOUN;k");
                    break;
                }
                case "\u0647\u0646": {
                    tags.add("PRONOUN;n");
                }
            }
        }
        return tags;
    }

    private boolean isStopWord(List<AnalyzedToken> taggerTokens) {
        for (AnalyzedToken tok : taggerTokens) {
            if (tok == null || !this.tagmanager.isStopWord(tok.getPOSTag())) continue;
            return true;
        }
        return false;
    }

    private String getPrefix(String word, int pos) {
        return word.substring(0, pos);
    }

    private String getSuffix(String word, int pos) {
        return word.substring(pos);
    }

    private List<String> getStem(String word, int posStart, int posEnd) {
        String prefix;
        ArrayList<String> stemList = new ArrayList<String>();
        String stem = word.substring(posStart);
        if (posEnd != word.length()) {
            stem = stem.replaceAll("(\u0643|\u0647\u0627|\u0647\u0645\u0627|\u0647\u0645|\u0647\u0646|\u0643\u0645\u0627|\u0643\u0645|\u0643\u0646|\u0646\u0627|\u064a)$", "\u0647");
        }
        if ((prefix = this.getPrefix(word, posStart)).endsWith("\u0644\u0644")) {
            stemList.add("\u0644" + stem);
        }
        stemList.add(stem);
        return stemList;
    }

    public void enableNewStylePronounTag() {
        this.newStylePronounTag = true;
    }
}

