/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ar;

import java.util.List;

public class ArabicTagManager {
    private static final int NOUN_TAG_LENGTH = 12;
    private static final int NOUN_FLAG_POS_WORDTYPE = 0;
    private static final int NOUN_FLAG_POS_CATEGORY = 1;
    private static final int NOUN_FLAG_POS_GENDER = 4;
    private static final int NOUN_FLAG_POS_NUMBER = 5;
    private static final int NOUN_FLAG_POS_CASE = 6;
    private static final int NOUN_FLAG_POS_INFLECT_MARK = 7;
    private static final int NOUN_FLAG_POS_CONJ = 9;
    private static final int NOUN_FLAG_POS_JAR = 10;
    private static final int NOUN_FLAG_POS_PRONOUN = 11;
    private static final int VERB_TAG_LENGTH = 15;
    private static final int VERB_FLAG_POS_WORDTYPE = 0;
    private static final int VERB_FLAG_POS_CATEGORY = 1;
    private static final int VERB_FLAG_POS_TRANS = 2;
    private static final int VERB_FLAG_POS_GENDER = 4;
    private static final int VERB_FLAG_POS_NUMBER = 5;
    private static final int VERB_FLAG_POS_PERSON = 6;
    private static final int VERB_FLAG_POS_INFLECT_MARK = 7;
    private static final int VERB_FLAG_POS_TENSE = 8;
    private static final int VERB_FLAG_POS_VOICE = 9;
    private static final int VERB_FLAG_POS_CASE = 10;
    private static final int VERB_FLAG_POS_CONJ = 12;
    private static final int VERB_FLAG_POS_ISTIQBAL = 13;
    private static final int VERB_FLAG_POS_PRONOUN = 14;

    public String modifyPosTag(String postag, List<String> tags) {
        for (String tg : tags) {
            if ((postag = this.addTag(postag, tg)) != null) continue;
            return null;
        }
        return postag;
    }

    public String addTag(String postag, String flag) {
        StringBuilder tmp = new StringBuilder(postag);
        switch (flag) {
            case "W": {
                tmp.setCharAt(postag.length() - 3, 'W');
                break;
            }
            case "K": {
                if (postag.startsWith("N")) {
                    if (this.isMajrour(postag)) {
                        tmp.setCharAt(postag.length() - 2, 'K');
                        break;
                    }
                    return null;
                }
                return null;
            }
            case "B": {
                if (postag.startsWith("N")) {
                    if (this.isMajrour(postag)) {
                        tmp.setCharAt(postag.length() - 2, 'B');
                        break;
                    }
                    return null;
                }
                return null;
            }
            case "L": {
                if (this.isNoun(postag)) {
                    if (this.isMajrour(postag)) {
                        tmp.setCharAt(postag.length() - 2, 'L');
                        break;
                    }
                    return null;
                }
                tmp.setCharAt(postag.length() - 2, 'L');
                break;
            }
            case "D": {
                if (this.isUnAttachedNoun(postag)) {
                    tmp.setCharAt(postag.length() - 1, 'L');
                    break;
                }
                return null;
            }
            case "S": {
                if (this.isFutureTense(postag)) {
                    tmp.setCharAt(postag.length() - 2, 'S');
                    break;
                }
                return null;
            }
        }
        return tmp.toString();
    }

    public boolean isMajrour(String postag) {
        return postag.charAt(6) == 'I' || postag.charAt(6) == '-';
    }

    public String setJar(String postag, String jar) {
        StringBuilder tmp = new StringBuilder(postag);
        int myflag = 0;
        if (this.isMajrour(postag)) {
            if (jar.equals("\u0628") || jar.equals("B")) {
                myflag = 66;
            } else if (jar.equals("\u0644") || jar.equals("L")) {
                myflag = 76;
            } else if (jar.equals("\u0643") || jar.equals("K")) {
                myflag = 75;
            } else if (jar.equals("-") || jar.isEmpty()) {
                myflag = 45;
            }
            if (myflag != 0) {
                tmp.setCharAt(10, (char)myflag);
            }
        }
        return tmp.toString();
    }

    public String setDefinite(String postag, String flag) {
        StringBuilder tmp = new StringBuilder(postag);
        int myflag = 0;
        if (this.isNoun(postag) && this.isUnAttachedNoun(postag)) {
            if (flag.equals("\u0627\u0644") || flag.equals("L") || flag.equals("\u0644\u0644") || flag.equals("D")) {
                myflag = 76;
            } else if (flag.equals("-") || flag.isEmpty()) {
                myflag = 45;
            }
            if (myflag != 0) {
                tmp.setCharAt(11, (char)myflag);
            }
        }
        return tmp.toString();
    }

    public String setConjunction(String postag, String flag) {
        StringBuilder tmp = new StringBuilder(postag);
        int myflag = 0;
        if (flag.equals("\u0648") || flag.equals("W") || flag.equals("\u0641") || flag.equals("F")) {
            myflag = 87;
        } else if (flag.equals("-") || flag.isEmpty()) {
            myflag = 45;
        }
        if (myflag != 0) {
            if (this.isNoun(postag)) {
                tmp.setCharAt(9, (char)myflag);
            } else if (this.isVerb(postag)) {
                tmp.setCharAt(12, (char)myflag);
            }
        }
        return tmp.toString();
    }

    public String setPronoun(String postag, String flag) {
        StringBuilder tmp = new StringBuilder(postag);
        char myflag = '\u0000';
        if (flag.equals("\u0647") || flag.equals("H")) {
            myflag = 'H';
        }
        if (myflag != '\u0000') {
            if (this.isNoun(postag)) {
                tmp.setCharAt(11, myflag);
            } else if (this.isVerb(postag)) {
                tmp.setCharAt(14, myflag);
            }
        }
        return tmp.toString();
    }

    public boolean isFutureTense(String postag) {
        return postag.startsWith("V") && postag.contains("f");
    }

    public boolean isUnAttachedNoun(String postag) {
        return postag.startsWith("N") && !postag.endsWith("H") && !postag.endsWith("X");
    }

    public boolean isAttached(String postag) {
        return this.isNoun(postag) && postag.charAt(11) == 'H' || this.isVerb(postag) && postag.charAt(14) == 'H';
    }

    public boolean isStopWord(String postag) {
        return postag.startsWith("P");
    }

    public boolean isNoun(String postag) {
        return postag.startsWith("N");
    }

    public boolean isVerb(String postag) {
        return postag.startsWith("V");
    }

    public boolean isDefinite(String postag) {
        return this.isNoun(postag) && postag.charAt(11) == 'L';
    }

    public boolean hasJar(String postag) {
        return this.isNoun(postag) && postag.charAt(10) != '-';
    }

    public boolean hasConjunction(String postag) {
        return this.isNoun(postag) && postag.charAt(9) != '-' || this.isVerb(postag) && postag.charAt(12) != '-';
    }

    public String getDefinitePrefix(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        if (this.isNoun(postag) && postag.charAt(11) == 'L') {
            if (this.hasJar(postag) && this.getJarPrefix(postag).equals("\u0644")) {
                return "\u0644";
            }
            return "\u0627\u0644";
        }
        return "";
    }

    public String getJarPrefix(String postag) {
        if (postag.isEmpty()) {
            return "";
        }
        if (this.isNoun(postag)) {
            if (postag.charAt(10) == 'L') {
                return "\u0644";
            }
            if (postag.charAt(10) == 'K') {
                return "\u0643";
            }
            if (postag.charAt(10) == 'B') {
                return "\u0628";
            }
        }
        return "";
    }

    public String getConjunctionPrefix(String postag) {
        int pos;
        if (postag.isEmpty()) {
            return "";
        }
        if (this.isNoun(postag)) {
            pos = 9;
        } else if (this.isVerb(postag)) {
            pos = 12;
        } else {
            return "";
        }
        if (postag.charAt(pos) == 'F') {
            return "\u0641";
        }
        if (postag.charAt(pos) == 'W') {
            return "\u0648";
        }
        return "";
    }
}

