/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Arabic;
import org.languagetool.rules.spelling.hunspell.HunspellRule;

public final class ArabicHunspellSpellerRule
extends HunspellRule {
    public static final String RULE_ID = "HUNSPELL_RULE_AR";
    private static final String RESOURCE_FILENAME = "/ar/hunspell/ar.dic";

    public ArabicHunspellSpellerRule(ResourceBundle messages, UserConfig userConfig) {
        super(messages, (Language)new Arabic(), userConfig);
    }

    public ArabicHunspellSpellerRule(ResourceBundle messages) {
        this(messages, null);
    }

    public String getId() {
        return RULE_ID;
    }

    @NotNull
    protected String getDictFilenameInResources(String langCountry) {
        return RESOURCE_FILENAME;
    }

    protected String[] tokenizeText(String sentence) {
        Pattern pattern = Pattern.compile("[^\\p{L}\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0653\u0654\u0655\u0656\u0640]");
        return pattern.split(sentence);
    }

    protected boolean ignoreWord(String word) throws IOException {
        String striped = word.replaceAll("[\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0653\u0654\u0655\u0656\u0640]", "");
        return super.ignoreWord(striped);
    }

    public boolean isMisspelled(String word) {
        String striped = word.replaceAll("[\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0653\u0654\u0655\u0656\u0640]", "");
        return super.isMisspelled(striped);
    }
}

