/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;

public class ArabicHomophonesRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_HOMOPHONES_REPLACE = "AR_HOMOPHONES_REPLACE";
    private static final String RESOURCE_FILENAME = "ar/homophones.txt";
    private static final Locale AR_LOCALE = new Locale("ar");

    public ArabicHomophonesRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        super.setCategory(Categories.CONFUSED_WORDS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>\u0636\u0646</marker>"), Example.fixed((String)"<marker>\u0638\u0646</marker>"));
    }

    public List<String> getFileNames() {
        return Collections.singletonList(RESOURCE_FILENAME);
    }

    public final String getId() {
        return AR_HOMOPHONES_REPLACE;
    }

    public String getDescription() {
        return "\u0643\u0644\u0645\u0627\u062a \u0645\u062a\u0634\u0627\u0628\u0647\u0629 \u0644\u0641\u0638\u0627 \u0644\u0644\u062a\u0648\u0636\u064a\u062d\u060c \u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646\u0647\u0627 \u0645\u062b\u0644 \u062a\u0634\u0627\u0628\u0647 \u0627\u0644\u0638\u0627\u0621 \u0648\u0627\u0644\u0636\u0627\u062f.";
    }

    public String getShort() {
        return "\u0643\u0644\u0645\u0627\u062a \u0645\u062a\u0634\u0627\u0628\u0647\u0629 \u0644\u0641\u0638\u0627 \u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646\u0647\u0627";
    }

    public String getSuggestion() {
        return "\u0642\u0644 $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648  ";
    }

    public Locale getLocale() {
        return AR_LOCALE;
    }
}

