/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class ArabicDarjaRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_DARJA_REPLACE = "AR_DARJA_REPLACE";
    private static final String FILE_NAME = "/ar/darja.txt";

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public ArabicDarjaRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>\u0637\u0631\u0634\u064a</marker>"), Example.fixed((String)"<marker>\u0641\u0644\u0641\u0644 \u062d\u0644\u0648</marker>"));
    }

    public final String getId() {
        return AR_DARJA_REPLACE;
    }

    public String getDescription() {
        return "\u0643\u0644\u0645\u0627\u062a \u0628\u062f\u064a\u0644\u0629 \u0644\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0639\u0627\u0645\u064a\u0629 \u0623\u0648 \u0627\u0644\u0623\u062c\u0646\u0628\u064a\u0629";
    }

    public String getShort() {
        return "\u0643\u0644\u0645\u0627\u062a \u0628\u062f\u064a\u0644\u0629 \u0644\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0639\u0627\u0645\u064a\u0629 \u0623\u0648 \u0627\u0644\u0623\u062c\u0646\u0628\u064a\u0629";
    }

    public String getSuggestion() {
        return "\u0627\u0644\u0643\u0644\u0645\u0629 \u0639\u0627\u0645\u064a\u0629  \u0623\u0648 \u0623\u062c\u0646\u0628\u064a\u0629 \u064a\u0641\u0636\u0644 \u0623\u0646 \u064a\u0642\u0627\u0644 $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648  ";
    }

    public Locale getLocale() {
        return new Locale("ar");
    }
}

