/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;

public class ArabicTagger
extends BaseTagger {
    public ArabicTagger() {
        super("/ar/arabic.dict", new Locale("ar"));
    }

    public String getManualAdditionsFileName() {
        return "/ar/added.txt";
    }

    public String addTag(String postag, String flag) {
        StringBuilder tmp = new StringBuilder(postag);
        if (flag.equals("W")) {
            tmp.setCharAt(postag.length() - 3, 'W');
        } else if (flag.equals("K")) {
            tmp.setCharAt(postag.length() - 2, 'K');
        } else if (flag.equals("L")) {
            tmp.setCharAt(postag.length() - 2, 'L');
        }
        return tmp.toString();
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String striped = word.replaceAll("[\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0653\u0654\u0655\u0656\u0640]", "");
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(striped));
            this.addTokens(taggerTokens, l);
            if (l.isEmpty()) {
                this.addTokens(this.additionalTags(striped, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        ArrayList<String> tags = new ArrayList<String>();
        String possibleWord = word;
        if (possibleWord.startsWith("\u0648") || possibleWord.startsWith("\u0641")) {
            tags.add("W");
            possibleWord = possibleWord.replaceAll("^[\u0648\u0641]", "");
        }
        if (possibleWord.startsWith("\u0644\u0644")) {
            tags.add("L");
            possibleWord = possibleWord.replaceAll("^[\u0644\u0644]", "");
        } else if (possibleWord.startsWith("\u0643")) {
            tags.add("K");
            possibleWord = possibleWord.replaceAll("^[\u0643]", "");
        } else if (possibleWord.startsWith("\u0644")) {
            tags.add("L");
            possibleWord = possibleWord.replaceAll("^[\u0644]", "");
        }
        if (possibleWord.endsWith("\u0647") || possibleWord.endsWith("\u0647\u0627") || possibleWord.endsWith("\u0647\u0645\u0627") || possibleWord.endsWith("\u0643\u0645\u0627") || possibleWord.endsWith("\u0647\u0645") || possibleWord.endsWith("\u0647\u0646") || possibleWord.endsWith("\u0643\u0645") || possibleWord.endsWith("\u0643\u0646") || possibleWord.endsWith("\u0646\u0627")) {
            possibleWord = possibleWord.replaceAll("(\u0647|\u0647\u0627|\u0647\u0645\u0627|\u0647\u0645|\u0647\u0646|\u0643\u0645\u0627|\u0643\u0645|\u0643\u0646|\u0646\u0627|\u064a)$", "\u0643");
        }
        List taggerTokens = this.asAnalyzedTokenList(possibleWord, stemmer.lookup((CharSequence)possibleWord));
        for (AnalyzedToken taggerToken : taggerTokens) {
            String posTag = taggerToken.getPOSTag();
            for (String tag : tags) {
                posTag = this.addTag(posTag, tag);
            }
            additionalTaggedTokens.add(new AnalyzedToken(word, posTag, taggerToken.getLemma()));
        }
        return additionalTaggedTokens;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

