/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;

public class ArabicSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/ar/arabic_synth.dict";
    private static final String TAGS_FILE_NAME = "/ar/arabic_tags.txt";

    public ArabicSynthesizer(Language lang) {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME, lang);
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        IStemmer synthesizer = this.createStemmer();
        List wordData = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            wordForms.add(wd.getStem().toString());
        }
        return wordForms.toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag != null && posTagRegExp) {
            String myPosTag = posTag;
            String det = "";
            this.initPossibleTags();
            Pattern p = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results, det);
            }
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(String lemma, String posTag, List<String> results, String determiner) {
        ArabicSynthesizer arabicSynthesizer = this;
        synchronized (arabicSynthesizer) {
            List wordForms = this.getStemmer().lookup((CharSequence)(lemma + "|" + posTag));
            for (WordData wd : wordForms) {
                results.add(determiner + wd.getStem());
            }
        }
    }
}

