/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

public class ArabicWordRepeatRule
extends WordRepeatRule {
    public ArabicWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"\u0647\u0630\u0627 <marker>\u0641\u0642\u0637 \u0641\u0642\u0637</marker> \u0645\u062b\u0627\u0644."), Example.fixed((String)"\u0647\u0630\u0627 <marker>\u0641\u0642\u0637</marker> \u0645\u062b\u0627\u0644."));
    }

    public String getId() {
        return "ARABIC_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (this.wordRepetitionOf("\u062e\u0637\u0648\u0629", tokens, position)) {
            return true;
        }
        return this.wordRepetitionOf("\u0631\u0648\u064a\u062f\u0627", tokens, position);
    }

    private boolean wordRepetitionOf(String word, AnalyzedTokenReadings[] tokens, int position) {
        return position > 0 && tokens[position - 1].getToken().equals(word) && tokens[position].getToken().equals(word);
    }
}

