/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.lang.reflect.Method;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class StaticWeavingTest {
    @Test
    public void testStaticWeaving() {
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set entityTypes = reflections.getTypesAnnotatedWith(Entity.class);
        Set superTypes = reflections.getTypesAnnotatedWith(MappedSuperclass.class);
        Set embeddableTypes = reflections.getTypesAnnotatedWith(Embeddable.class);
        this.assertStaticWeaved(entityTypes, superTypes, embeddableTypes);
    }

    private void assertStaticWeaved(Set<Class<?>> ... types) {
        for (Set<Class<?>> typeSet : types) {
            for (Class<?> type : typeSet) {
                Method[] methods;
                boolean foundWeaved = false;
                for (Method method : methods = type.getDeclaredMethods()) {
                    if (!method.getName().startsWith("_persistence")) continue;
                    foundWeaved = true;
                    break;
                }
                if (foundWeaved) continue;
                Assert.fail((String)("(NOTE: it is expected this test may fail if executed from the IDE instead of command line since the IDE will not execute the static weaving automatically). Found a class which is not bytecode weaved (contains no methods starting with '_persistence'): " + type + " " + "In order to resolve this, please ensure that this type is included in " + "META-INF/persistence-weaving.xml"));
            }
        }
    }
}

