/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.util.Map;
import javax.xml.transform.Templates;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLGlobalConfig;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EDLController {
    private static final Logger LOG = Logger.getLogger(EDLController.class);
    private EDocLiteAssociation edocLiteAssociation;
    private Templates style;
    private Map configProcessors;
    private Map preProcessors;
    private Map postProcessors;
    private Map stateComponents;
    private EDLGlobalConfig edlGlobalConfig;
    private Document defaultDOM;
    private EDLContext edlContext;

    public Document notifyComponents() {
        try {
            this.updateDOMWithProcessors(this.defaultDOM, this.preProcessors);
            this.updateDOMWithProcessors(this.defaultDOM, this.stateComponents);
            this.updateDOMWithProcessors(this.defaultDOM, this.configProcessors);
            this.updateDOMWithProcessors(this.defaultDOM, this.stateComponents);
            this.updateDOMWithProcessors(this.defaultDOM, this.postProcessors);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        return this.defaultDOM;
    }

    private void updateDOMWithProcessors(Document dom, Map processors) throws Exception {
        for (Map.Entry processorEntry : processors.entrySet()) {
            Element configElement = (Element)processorEntry.getKey();
            EDLModelComponent eldModelComp = (EDLModelComponent)((Class)processorEntry.getValue()).newInstance();
            eldModelComp.updateDOM(dom, configElement, this.edlContext);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Just completed notification to component " + eldModelComp + " doc content looks like. " + XmlJotter.jotNode((Node)dom)));
        }
    }

    public Map getConfigProcessors() {
        return this.configProcessors;
    }

    public void setConfigProcessors(Map configProcessors) {
        this.configProcessors = configProcessors;
    }

    public EDLGlobalConfig getEdlGlobalConfig() {
        return this.edlGlobalConfig;
    }

    public void setEdlGlobalConfig(EDLGlobalConfig edlConfig) {
        this.edlGlobalConfig = edlConfig;
    }

    public Templates getStyle() {
        return this.style;
    }

    public void setStyle(Templates style) {
        this.style = style;
    }

    public EDocLiteAssociation getEdocLiteAssociation() {
        return this.edocLiteAssociation;
    }

    public void setEdocLiteAssociation(EDocLiteAssociation edocLiteAssociation) {
        this.edocLiteAssociation = edocLiteAssociation;
    }

    public Document getDefaultDOM() {
        return this.defaultDOM;
    }

    public void setDefaultDOM(Document defaultDOM) {
        this.defaultDOM = defaultDOM;
    }

    public EDLContext getEdlContext() {
        return this.edlContext;
    }

    public void setEdlContext(EDLContext edlContext) {
        this.edlContext = edlContext;
    }

    public Map getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(Map postProcessors) {
        this.postProcessors = postProcessors;
    }

    public Map getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(Map preProcessors) {
        this.preProcessors = preProcessors;
    }

    public Map getStateComponents() {
        return this.stateComponents;
    }

    public void setStateComponents(Map stateComponents) {
        this.stateComponents = stateComponents;
    }
}

