/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.components.EDLValidation;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidationComponent
extends SimpleWorkflowEDLConfigComponent
implements EDLModelComponent {
    private static final String XPATH_TYPE = "xpath";
    private EDLContext edlContext;

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        if (edlContext.getUserAction().isValidatableAction()) {
            try {
                Document edlDef = EdlServiceLocator.getEDocLiteService().getDefinitionXml(edlContext.getEdocLiteAssociation());
                List<EDLValidation> validations = this.parseValidations(edlDef);
                if (!validations.isEmpty()) {
                    XPath xpath = XPathHelper.newXPath((Node)dom);
                    for (EDLValidation validation : validations) {
                        this.executeValidation(xpath, dom, validation, edlContext);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WorkflowRuntimeException("Failed to execute EDL validations.", (Throwable)e);
            }
        }
    }

    protected List<EDLValidation> parseValidations(Document document) throws Exception {
        ArrayList<EDLValidation> validations = new ArrayList<EDLValidation>();
        XPath xpath = XPathHelper.newXPath((Node)document);
        NodeList validationNodes = (NodeList)xpath.evaluate("/edl/validations/validation", document, XPathConstants.NODESET);
        for (int index = 0; index < validationNodes.getLength(); ++index) {
            Element validationElem = (Element)validationNodes.item(index);
            EDLValidation validation = new EDLValidation();
            String type = validationElem.getAttribute("type");
            String key = validationElem.getAttribute("key");
            String expression = EDLXmlUtils.getChildElementTextValue(validationElem, "expression");
            String message = EDLXmlUtils.getChildElementTextValue(validationElem, "message");
            if (StringUtils.isBlank((String)type)) {
                throw new WorkflowRuntimeException("An improperly configured validation was found with an empty type.");
            }
            if (StringUtils.isBlank((String)expression)) {
                throw new WorkflowRuntimeException("An improperly configured validation was found with an empty expression.");
            }
            if (StringUtils.isBlank((String)message)) {
                throw new WorkflowRuntimeException("An improperly configured validation was found with an empty message.");
            }
            validation.setType(type);
            validation.setKey(key);
            validation.setExpression(expression);
            validation.setMessage(message);
            validations.add(validation);
        }
        return validations;
    }

    protected void executeValidation(XPath xpath, Document dom, EDLValidation validation, EDLContext edlContext) throws Exception {
        if (XPATH_TYPE.equals(validation.getType())) {
            Boolean result = (Boolean)xpath.evaluate(validation.getExpression(), dom, XPathConstants.BOOLEAN);
            if (!result.booleanValue()) {
                String key = validation.getKey();
                if (!StringUtils.isEmpty((String)key)) {
                    Map fieldErrors = (Map)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalFieldErrors");
                    fieldErrors.put(key, validation.getMessage());
                } else {
                    List globalErrors = (List)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalErrors");
                    globalErrors.add(validation.getMessage());
                }
                edlContext.setInError(true);
            }
        } else {
            throw new WorkflowRuntimeException("Illegal validation type specified.  Only 'xpath' is currently supported.");
        }
    }
}

