/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.components.VersioningPreprocessor;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.UrlFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PerformLookupComponent
implements EDLModelComponent {
    private static final Logger LOG = Logger.getLogger(PerformLookupComponent.class);

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        String userAction = edlContext.getUserAction().getAction();
        if (userAction != null && userAction.startsWith("performLookup")) {
            edlContext.setRedirectUrl(this.constructRedirectUrl(dom, configElement, edlContext));
        }
    }

    protected String constructRedirectUrl(Document dom, Element configElement, EDLContext edlContext) {
        StringBuilder buf = new StringBuilder(30);
        buf.append(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url"));
        buf.append("/kr/").append("lookup.do");
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", this.getBusinessObjectClassName(dom, configElement, edlContext));
        parameters.put("docFormKey", edlContext.getUserSession().addObjectWithGeneratedKey((Object)dom));
        parameters.put("returnLocation", this.constructReturnUrl(dom, configElement, edlContext));
        parameters.putAll(this.getLookupParameters(dom, configElement, edlContext));
        parameters.put("conversionFields", this.getFieldConversions(dom, configElement, edlContext));
        String url = UrlFactory.parameterizeUrl((String)buf.toString(), (Properties)parameters);
        return url;
    }

    protected String getBusinessObjectClassName(Document dom, Element configElement, EDLContext edlContext) {
        String userAction = edlContext.getUserAction().getAction();
        String lookupField = StringUtils.substringAfter((String)userAction, (String)".");
        if (StringUtils.isBlank((String)lookupField)) {
            LOG.error((Object)("Cannot find lookup field parameters definition for field " + lookupField));
            return null;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String businessObjectClassName = xPath.evaluate("//fieldDef[@name='" + lookupField + "']/lookup/businessObjectClassName", dom);
            return businessObjectClassName;
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected String getFieldConversions(Document dom, Element configElement, EDLContext edlContext) {
        String userAction = edlContext.getUserAction().getAction();
        String lookupField = StringUtils.substringAfter((String)userAction, (String)".");
        if (StringUtils.isBlank((String)lookupField)) {
            LOG.error((Object)("Cannot find lookup field parameters definition for field " + lookupField));
            return null;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String lookupParameters = xPath.evaluate("//fieldDef[@name='" + lookupField + "']/lookup/fieldConversions", dom);
            return lookupParameters;
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected Map<String, String> getLookupParameters(Document dom, Element configElement, EDLContext edlContext) {
        String lookupParameterDefinition = this.retrieveLookupParametersString(dom, configElement, edlContext);
        if (StringUtils.isBlank((String)lookupParameterDefinition)) {
            return Collections.emptyMap();
        }
        StringTokenizer tok = new StringTokenizer(lookupParameterDefinition, ",");
        HashMap<String, String> lookupParameters = new HashMap<String, String>();
        Element currentVersion = VersioningPreprocessor.findCurrentVersion(dom);
        while (tok.hasMoreTokens()) {
            String parameterDefinition = tok.nextToken();
            int colonInd = parameterDefinition.indexOf(58);
            if (colonInd == -1) {
                throw new WorkflowRuntimeException("Lookup definition string improperly formatted " + lookupParameterDefinition);
            }
            String parameterName = parameterDefinition.substring(colonInd + 1);
            String parameterValuePropertyName = parameterDefinition.substring(0, colonInd);
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                String parameterValue = xPath.evaluate("//field[@name='" + parameterValuePropertyName + "']/value", currentVersion);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)XmlJotter.jotNode((Node)currentVersion, (boolean)true));
                }
                if (!StringUtils.isNotBlank((String)parameterValue)) continue;
                lookupParameters.put(parameterName, parameterValue);
            }
            catch (XPathExpressionException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
        return lookupParameters;
    }

    protected String retrieveLookupParametersString(Document dom, Element configElement, EDLContext edlContext) {
        String userAction = edlContext.getUserAction().getAction();
        String lookupField = StringUtils.substringAfter((String)userAction, (String)".");
        if (StringUtils.isBlank((String)lookupField)) {
            LOG.error((Object)("Cannot find lookup field parameters definition for field " + lookupField));
            return null;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String lookupParameters = xPath.evaluate("//fieldDef[@name='" + lookupField + "']/lookup/lookupParameters", dom);
            return lookupParameters;
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected String constructReturnUrl(Document dom, Element configElement, EDLContext edlContext) {
        StringBuilder baseUrl = new StringBuilder(30);
        baseUrl.append(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url"));
        baseUrl.append("/kew/EDocLite");
        Properties parameters = new Properties();
        String url = UrlFactory.parameterizeUrl((String)baseUrl.toString(), (Properties)parameters);
        return url;
    }
}

