/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class StringUtils
implements GroovyObject {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final Pattern GETTER_PATTERN_1;
    private static final Pattern GETTER_PATTERN_2;
    private static final Pattern SETTER_PATTERN;
    private static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public StringUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String capitalize(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return StringGroovyMethods.plus((String)str.substring(0, 1).toUpperCase(Locale.ENGLISH), (CharSequence)str.substring(1));
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        int extIndex = path.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareEqual((Object)extIndex, (Object)-1)) {
            return ShortTypeHandling.castToString(null);
        }
        int folderIndex = path.lastIndexOf(File.separator);
        if (folderIndex > extIndex) {
            return ShortTypeHandling.castToString(null);
        }
        return path.substring(extIndex + 1);
    }

    public static String getSetterName(String propertyName) {
        return StringGroovyMethods.plus((String)PROPERTY_SET_PREFIX, (CharSequence)StringUtils.capitalize(propertyName));
    }

    public static String getGetterName(String propertyName) {
        return StringGroovyMethods.plus((String)PROPERTY_GET_PREFIX, (CharSequence)StringUtils.capitalize(propertyName));
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (StringUtils.isBlank(logicalName)) {
            throw (Throwable)new IllegalArgumentException("Argument [logicalName] must not be null or blank");
        }
        String className = StringUtils.capitalize(logicalName);
        if (trailingName != null) {
            String string;
            className = string = StringGroovyMethods.plus((String)className, (CharSequence)trailingName);
        }
        return className;
    }

    public static String getClassNameRepresentation(String name) {
        StringBuilder buf = new StringBuilder();
        if (name != null && name.length() > 0) {
            String[] tokens = name.split("[^\\w\\d]");
            String token12 = null;
            String[] stringArray = tokens;
            if (tokens != null) {
                for (String token12 : stringArray) {
                    String token = token12.trim();
                    buf.append(StringUtils.capitalize(token));
                }
            }
        }
        return buf.toString();
    }

    public static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)name.indexOf("-"), (Object)-1)) {
            StringBuilder buf = new StringBuilder();
            String[] tokens = name.split("-");
            String token2 = null;
            String[] stringArray = tokens;
            if (tokens != null) {
                for (String token2 : stringArray) {
                    if (token2 == null || token2.length() == 0) continue;
                    buf.append(StringUtils.capitalize(token2));
                }
            }
            return buf.toString();
        }
        return StringUtils.capitalize(name);
    }

    public static String getLogicalName(Class<?> clazz, String trailingName) {
        return StringUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        if (StringUtils.isNotBlank(name) && StringUtils.isNotBlank(trailingName)) {
            String shortName = StringUtils.getShortName(name);
            if (shortName.endsWith(trailingName)) {
                return shortName.substring(0, shortName.length() - trailingName.length());
            }
        }
        return name;
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        if (StringUtils.isNotBlank(className) && StringUtils.isNotBlank(trailingName) && className.length() == trailingName.length() + 1 && className.endsWith(trailingName)) {
            return className.substring(0, 1).toLowerCase();
        }
        return StringUtils.getLogicalName(StringUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return StringUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return StringUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyName(Method method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        String name = method.getName();
        if (GETTER_PATTERN_1.matcher(name).matches() || SETTER_PATTERN.matcher(name).matches()) {
            return StringUtils.uncapitalize(name.substring(3));
        }
        if (GETTER_PATTERN_2.matcher(name).matches()) {
            return StringUtils.uncapitalize(name.substring(2));
        }
        return name;
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        String shortName = StringUtils.getShortName(targetClass);
        return StringUtils.getPropertyNameRepresentation(shortName);
    }

    public static String getPropertyNameRepresentation(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        int pos = name.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)pos, (Object)-1)) {
            String string;
            name = string = name.substring(pos + 1);
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = StringGroovyMethods.plus((String)name.substring(0, 1).toLowerCase(Locale.ENGLISH), (CharSequence)name.substring(1));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)propertyName.indexOf(" "), (Object)-1)) {
            String string;
            propertyName = string = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return StringUtils.getPropertyName(StringUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class<?> targetClass) {
        String className = targetClass.getName();
        return StringUtils.getShortName(className);
    }

    public static String getShortName(String className) {
        if (StringUtils.isBlank(className)) {
            return className;
        }
        int i = className.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
            String string;
            className = string = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getNaturalName(String name) {
        String string;
        name = string = StringUtils.getShortName(name);
        if (StringUtils.isBlank(name)) {
            return name;
        }
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        char c = '\u0000';
        char[] cArray = chars;
        if (chars != null) {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = cArray[n2];
                ++n2;
                String w = null;
                if (i >= words.size()) {
                    String string2;
                    w = string2 = "";
                    words.add(i, w);
                } else {
                    Object e = words.get(i);
                    w = ShortTypeHandling.castToString(e);
                }
                if (Character.isLowerCase(c) || Character.isDigit(c)) {
                    if (Character.isLowerCase(c) && w.length() == 0) {
                        char c2;
                        c = c2 = Character.toUpperCase(c);
                    } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                        String string3;
                        w = string3 = "";
                        words.add(++i, w);
                    }
                    words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                    words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
                    continue;
                }
                words.add(++i, String.valueOf(c));
            }
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = ShortTypeHandling.castToString(j.next());
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        char c2 = '\u0000';
        char[] cArray = str.toCharArray();
        if (cArray != null) {
            for (char c2 : cArray) {
                if (!(!Character.isWhitespace(c2))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String requireNonBlank(String str) {
        if (StringUtils.isBlank(str)) {
            throw (Throwable)new IllegalArgumentException();
        }
        return str;
    }

    public static String requireNonBlank(String str, String message) {
        if (StringUtils.isBlank(str)) {
            throw (Throwable)new IllegalArgumentException(message);
        }
        return str;
    }

    public static String getHyphenatedName(Class<?> clazz) {
        if (clazz == null) {
            return ShortTypeHandling.castToString(null);
        }
        return StringUtils.getHyphenatedName(clazz.getName());
    }

    public static String getHyphenatedName(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.endsWith(".groovy")) {
            String string;
            name = string = name.substring(0, name.length() - 7);
        }
        String naturalName = StringUtils.getNaturalName(StringUtils.getShortName(name));
        return naturalName.replaceAll("\\s", "-").toLowerCase();
    }

    @Nonnull
    public static String join(@Nonnull Iterable<?> self, @Nullable String separator) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        if (separator == null) {
            String string;
            separator = string = "";
        }
        Object value2 = null;
        for (Object value2 : self) {
            if (first) {
                boolean bl;
                first = bl = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(String.valueOf(value2));
        }
        return buffer.toString();
    }

    public static String uncapitalize(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toLowerCase(str.charAt(0)));
        }
        return StringGroovyMethods.plus((String)String.valueOf(Character.toLowerCase(str.charAt(0))), (CharSequence)str.substring(1));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StringUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        GETTER_PATTERN_1 = pattern3 = Pattern.compile("^get[A-Z][\\w]*$");
        GETTER_PATTERN_2 = pattern2 = Pattern.compile("^is[A-Z][\\w]*$");
        SETTER_PATTERN = pattern = Pattern.compile("^set[A-Z][\\w]*$");
    }
}

