/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kordamp.gradle.util.ObjectUtils;
import org.kordamp.gradle.util.StringUtils;

public class MethodDescriptor
implements Comparable<MethodDescriptor> {
    private static final String[] EMPTY_CLASS_PARAMETERS = new String[0];
    private final String methodName;
    private final String[] paramTypes;
    private final int hashCode;
    private final int modifiers;
    private final Annotation[] annotations;

    public MethodDescriptor(@Nonnull String methodName) {
        this(methodName, EMPTY_CLASS_PARAMETERS, 1);
    }

    public MethodDescriptor(@Nonnull String methodName, int modifiers) {
        this(methodName, EMPTY_CLASS_PARAMETERS, modifiers, new Annotation[0]);
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull Class<?>[] paramTypes) {
        this(methodName, paramTypes, 1, new Annotation[0]);
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull String[] paramTypes) {
        this(methodName, paramTypes, 1, new Annotation[0]);
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull Class<?>[] paramTypes, int modifiers) {
        this(methodName, paramTypes, 1, new Annotation[0]);
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull Class<?>[] paramTypes, int modifiers, @Nonnull Annotation[] annotations) {
        this.methodName = StringUtils.requireNonBlank(methodName, "Argment 'methodName' must not be blank");
        Objects.requireNonNull(paramTypes, "Argument 'paramTypes' must not be null");
        Objects.requireNonNull(annotations, "Argument 'annotations' must not be null");
        this.paramTypes = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this.paramTypes[i] = paramTypes[i].getName();
        }
        this.modifiers = modifiers;
        this.annotations = Arrays.copyOf(annotations, annotations.length);
        Arrays.sort(this.annotations, Comparator.comparing(o -> o.getClass().getName()));
        this.hashCode = 31 * methodName.hashCode() + modifiers;
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull String[] paramTypes, int modifiers) {
        this(methodName, paramTypes, modifiers, new Annotation[0]);
    }

    public MethodDescriptor(@Nonnull String methodName, @Nonnull String[] paramTypes, int modifiers, @Nonnull Annotation[] annotations) {
        this.methodName = StringUtils.requireNonBlank(methodName, "Argment 'methodName' must not be blank");
        Objects.requireNonNull(paramTypes, "Argument 'paramTypes' must not be null");
        Objects.requireNonNull(annotations, "Argument 'annotations' must not be null");
        this.paramTypes = Arrays.copyOf(paramTypes, paramTypes.length);
        this.modifiers = modifiers;
        this.annotations = Arrays.copyOf(annotations, annotations.length);
        Arrays.sort(this.annotations, Comparator.comparing(o -> o.getClass().getName()));
        this.hashCode = 31 * methodName.hashCode() + modifiers;
    }

    @Nonnull
    public String getName() {
        return this.methodName;
    }

    @Nonnull
    public String[] getParameterTypes() {
        return this.paramTypes;
    }

    @Nonnull
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor md = (MethodDescriptor)obj;
        return this.methodName.equals(md.methodName) && this.modifiers == md.modifiers && MethodDescriptor.areParametersCompatible(this.paramTypes, md.paramTypes) && Arrays.equals(this.annotations, md.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String a = Arrays.toString(this.annotations);
        StringBuilder b = new StringBuilder(a.substring(1, a.length() - 1));
        b.append(Modifier.toString(this.modifiers)).append(" ");
        b.append(this.methodName).append("(");
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.paramTypes[i]);
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public int compareTo(MethodDescriptor md) {
        int c = this.methodName.compareTo(md.methodName);
        if (c != 0) {
            return c;
        }
        c = this.modifiers - md.modifiers;
        if (c != 0) {
            return c;
        }
        c = this.paramTypes.length - md.paramTypes.length;
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            c = this.paramTypes[i].compareTo(md.paramTypes[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean matches(@Nonnull MethodDescriptor md) {
        Objects.requireNonNull(md, "Argument 'methodDescriptor' must not be null");
        if (!this.methodName.equals(md.methodName) || this.modifiers != md.modifiers || this.paramTypes.length != md.paramTypes.length || this.annotations.length != md.annotations.length) {
            return false;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Class<?> param1 = this.loadClass(this.paramTypes[i]);
            Class<?> param2 = this.loadClass(md.paramTypes[i]);
            if (param1 == null || param2 == null || ObjectUtils.isAssignableOrConvertibleFrom(param1, param2)) continue;
            return false;
        }
        return Arrays.equals(this.annotations, md.annotations);
    }

    public boolean matches(@Nonnull Class[] otherParamTypes) {
        Objects.requireNonNull(otherParamTypes, "Argument 'otherParamTypes' must not be null");
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Class<?> param1 = this.loadClass(this.paramTypes[i]);
            Class param2 = otherParamTypes[i];
            if (param1 == null || param2 == null || ObjectUtils.isAssignableOrConvertibleFrom(param1, param2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Class<?> loadClass(@Nonnull String classname) {
        try {
            return Class.forName(classname, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (ObjectUtils.PRIMITIVE_TYPE_COMPATIBLE_TYPES.containsKey(classname)) {
                try {
                    classname = ObjectUtils.PRIMITIVE_TYPE_COMPATIBLE_TYPES.get(classname);
                    return Class.forName(classname, true, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    return null;
                }
            }
            return null;
        }
    }

    @Nonnull
    public static MethodDescriptor forMethod(@Nonnull Method method) {
        return MethodDescriptor.forMethod(method, false);
    }

    @Nonnull
    public static MethodDescriptor forMethod(@Nonnull Method method, boolean removeAbstractModifier) {
        Objects.requireNonNull(method, "Argument 'method' must not be null");
        int modifiers = method.getModifiers();
        if (removeAbstractModifier) {
            modifiers -= 1024;
        }
        return new MethodDescriptor(method.getName(), method.getParameterTypes(), modifiers, method.getDeclaredAnnotations());
    }

    private static boolean areParametersCompatible(String[] params1, String[] params2) {
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            String p1 = params1[i];
            String p2 = params2[i];
            if (p1.equals(p2) || ObjectUtils.isMatchBetweenPrimitiveAndWrapperTypes(p1, p2)) continue;
            return false;
        }
        return true;
    }
}

