/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.gradle.api.invocation.Gradle;
import org.kordamp.gradle.util.Algorithm;
import org.kordamp.gradle.util.ChecksumUtils;

public final class Cache
implements GroovyObject {
    private static final String KEY_CACHE_LOG_LEVEL = "org.kordamp.gradle.cache.log.level";
    private static final Cache INSTANCE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public Cache() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Cache getInstance() {
        return INSTANCE;
    }

    public static Key key(Object input) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)input)) {
            throw (Throwable)new IllegalArgumentException("Input must not be null");
        }
        return new Key(null, input);
    }

    public long lastModified(Gradle gradle, Key key) {
        File file = this.resolveCacheFile(gradle, key);
        return file.exists() ? file.lastModified() : Long.MIN_VALUE;
    }

    public long touch(Gradle gradle, Key key) {
        File file = this.resolveCacheFile(gradle, key);
        if (file.exists()) {
            file.setLastModified(new Date().getTime());
            return file.lastModified();
        }
        return Long.MIN_VALUE;
    }

    public boolean has(Gradle gradle, Key key) {
        return this.resolveCacheFile(gradle, key).exists();
    }

    public void delete(Gradle gradle, Key key) {
        this.resolveCacheFile(gradle, key).delete();
    }

    public boolean get(Gradle gradle, Key key, Consumer<? super InputStream> consumer) {
        Reference consumer2 = new Reference(consumer);
        File cacheFile = this.resolveCacheFile(gradle, key);
        if (cacheFile.exists()) {
            public final class _get_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference consumer;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _get_closure1(Object _outerInstance, Object _thisObject, Reference consumer) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.consumer = reference = consumer;
                }

                public Object doCall(Object it) {
                    ((Consumer)this.consumer.get()).accept(it);
                    return null;
                }

                @Generated
                public Consumer getConsumer() {
                    return (Consumer)ScriptBytecodeAdapter.castToType((Object)this.consumer.get(), Consumer.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _get_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ResourceGroovyMethods.withInputStream((File)cacheFile, (Closure)new _get_closure1(this, this, consumer2));
            boolean bl = true;
            try {
                return bl;
            }
            catch (IOException e) {
                this.log(gradle, key, e);
            }
        }
        return false;
    }

    public boolean read(Gradle gradle, Key key, Consumer<? super BufferedReader> consumer) {
        Reference consumer2 = new Reference(consumer);
        File cacheFile = this.resolveCacheFile(gradle, key);
        if (cacheFile.exists()) {
            public final class _read_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference consumer;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _read_closure2(Object _outerInstance, Object _thisObject, Reference consumer) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.consumer = reference = consumer;
                }

                public Object doCall(Object it) {
                    ((Consumer)this.consumer.get()).accept(it);
                    return null;
                }

                @Generated
                public Consumer getConsumer() {
                    return (Consumer)ScriptBytecodeAdapter.castToType((Object)this.consumer.get(), Consumer.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _read_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ResourceGroovyMethods.withReader((File)cacheFile, (Closure)new _read_closure2(this, this, consumer2));
            boolean bl = true;
            try {
                return bl;
            }
            catch (IOException e) {
                this.log(gradle, key, e);
            }
        }
        return false;
    }

    public boolean put(Gradle gradle, Key key, Consumer<? super OutputStream> consumer) {
        Reference consumer2 = new Reference(consumer);
        File cacheFile = this.resolveCacheFile(gradle, key);
        cacheFile.getParentFile().mkdirs();
        public final class _put_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference consumer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _put_closure3(Object _outerInstance, Object _thisObject, Reference consumer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.consumer = reference = consumer;
            }

            public Object doCall(Object it) {
                ((Consumer)this.consumer.get()).accept(it);
                return null;
            }

            @Generated
            public Consumer getConsumer() {
                return (Consumer)ScriptBytecodeAdapter.castToType((Object)this.consumer.get(), Consumer.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _put_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withOutputStream((File)cacheFile, (Closure)new _put_closure3(this, this, consumer2));
        boolean bl = true;
        try {
            return bl;
        }
        catch (IOException e) {
            this.log(gradle, key, e);
        }
        return false;
    }

    public boolean write(Gradle gradle, Key key, Consumer<? super BufferedWriter> consumer) {
        Reference consumer2 = new Reference(consumer);
        File cacheFile = this.resolveCacheFile(gradle, key);
        cacheFile.getParentFile().mkdirs();
        public final class _write_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference consumer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _write_closure4(Object _outerInstance, Object _thisObject, Reference consumer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.consumer = reference = consumer;
            }

            public Object doCall(Object it) {
                ((Consumer)this.consumer.get()).accept(it);
                return null;
            }

            @Generated
            public Consumer getConsumer() {
                return (Consumer)ScriptBytecodeAdapter.castToType((Object)this.consumer.get(), Consumer.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _write_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withWriter((File)cacheFile, (Closure)new _write_closure4(this, this, consumer2));
        boolean bl = true;
        try {
            return bl;
        }
        catch (IOException e) {
            this.log(gradle, key, e);
        }
        return false;
    }

    public void clear(Gradle gradle) {
        ResourceGroovyMethods.deleteDir((File)new File(DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{gradle.getGradleUserHomeDir().getAbsolutePath(), "caches", "kordamp", "file-cache"}), (String)File.separator)));
    }

    private File resolveCacheFile(Gradle gradle, Key key) {
        return new File(DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{gradle.getGradleUserHomeDir().getAbsolutePath(), "caches", "kordamp", "file-cache", key.getValue()}), (String)File.separator));
    }

    private void log(Gradle gradle, Key key, Throwable t) {
        LogLevel logLevel;
        String message;
        block10: {
            block9: {
                block8: {
                    message = new GStringImpl(new Object[]{key.getValue()}, new String[]{"Cache I/O error key=", ""}).toString();
                    logLevel = Cache.resolveLogLevel();
                    if (!ScriptBytecodeAdapter.isCase((Object)((Object)logLevel), (Object)((Object)LogLevel.DEBUG))) break block8;
                    gradle.getRootProject().getLogger().debug(message, t);
                }
                if (!ScriptBytecodeAdapter.isCase((Object)((Object)logLevel), (Object)((Object)LogLevel.INFO))) break block9;
                gradle.getRootProject().getLogger().info(message, t);
            }
            if (!ScriptBytecodeAdapter.isCase((Object)((Object)logLevel), (Object)((Object)LogLevel.WARN))) break block10;
            gradle.getRootProject().getLogger().warn(message, t);
        }
        try {
            if (ScriptBytecodeAdapter.isCase((Object)((Object)logLevel), (Object)((Object)LogLevel.ERROR))) {
                gradle.getRootProject().getLogger().error(message, t);
            }
        }
        catch (IllegalStateException e) {
            DefaultGroovyMethods.println((PrintStream)System.err, (Object)new GStringImpl(new Object[]{key.getValue(), t}, new String[]{"Cache I/O error key=", ". ", ""}));
        }
    }

    public static LogLevel resolveLogLevel() {
        String value = System.getProperty(KEY_CACHE_LOG_LEVEL);
        LogLevel logLevel = LogLevel.valueOf(value.toUpperCase());
        try {
            return logLevel;
        }
        catch (Exception ignored) {
            LogLevel logLevel2 = LogLevel.INFO;
            return logLevel2;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Cache.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Cache.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Cache.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Cache.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Cache cache;
        INSTANCE = cache = new Cache();
    }

    @ToString
    @EqualsAndHashCode
    public static class Key
    implements GroovyObject {
        private final String value;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        private Key(Object input) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.value = string = ChecksumUtils.checksum(Algorithm.SHA_256, String.valueOf(input).getBytes());
        }

        /* synthetic */ Key(1 $that, Object input) {
            this(input);
        }

        public String getAbsolutePath(Gradle gradle) {
            return Cache.getInstance().resolveCacheFile(gradle, this).getAbsolutePath();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Key.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("org.kordamp.gradle.util.Cache$Key(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getValue()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getValue(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getValue());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherTyped = (Key)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getValue(), (Object)otherTyped.getValue()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Key.class, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Key.class, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Key.class, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Key.class, Cache.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getValue() {
            return this.value;
        }

        static class 1
        implements GroovyObject {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;

            @Generated
            public 1() {
                MetaClass metaClass;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public static final class LogLevel
    extends Enum<LogLevel>
    implements GroovyObject {
        public static final /* enum */ LogLevel DEBUG;
        public static final /* enum */ LogLevel INFO;
        public static final /* enum */ LogLevel WARN;
        public static final /* enum */ LogLevel ERROR;
        public static final LogLevel MIN_VALUE;
        public static final LogLevel MAX_VALUE;
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public LogLevel(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum org.kordamp.gradle.util.Cache$LogLevel was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public LogLevel() {
            this(new LinkedHashMap());
        }

        @Generated
        public static final LogLevel[] values() {
            return (LogLevel[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), LogLevel[].class);
        }

        @Generated
        public LogLevel next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (LogLevel)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), LogLevel.class);
        }

        @Generated
        public LogLevel previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (LogLevel)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), LogLevel.class);
        }

        @Generated
        public static LogLevel valueOf(String name) {
            return (LogLevel)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(LogLevel.class, name)), LogLevel.class);
        }

        @Generated
        public static final /* synthetic */ LogLevel $INIT(Object ... para) {
            LogLevel logLevel;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, LogLevel.class)) {
                case -1348271900: {
                    LogLevel logLevel2;
                    logLevel = logLevel2;
                    Object[] objectArray2 = objectArray;
                    logLevel2 = new LogLevel();
                    break;
                }
                case -242181752: {
                    LogLevel logLevel2;
                    logLevel = logLevel2;
                    Object[] objectArray2 = objectArray;
                    logLevel2 = new LogLevel((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return logLevel;
        }

        static {
            LogLevel logLevel;
            LogLevel logLevel2;
            LogLevel logLevel3;
            LogLevel logLevel4;
            LogLevel logLevel5;
            LogLevel logLevel6;
            DEBUG = logLevel6 = LogLevel.$INIT("DEBUG", 0);
            INFO = logLevel5 = LogLevel.$INIT("INFO", 1);
            WARN = logLevel4 = LogLevel.$INIT("WARN", 2);
            ERROR = logLevel3 = LogLevel.$INIT("ERROR", 3);
            MIN_VALUE = logLevel2 = DEBUG;
            MAX_VALUE = logLevel = ERROR;
            LogLevel[] logLevelArray = new LogLevel[]{DEBUG, INFO, WARN, ERROR};
            $VALUES = logLevelArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != LogLevel.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

