/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kordamp.gradle.util.MethodDescriptor;
import org.kordamp.gradle.util.StringUtils;

public class ObjectUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new LinkedHashMap();
    public static final Map<String, String> PRIMITIVE_TYPE_COMPATIBLE_TYPES = new LinkedHashMap<String, String>();
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String PROPERTY_IS_PREFIX = "is";
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final Pattern GETTER_PATTERN_1 = Pattern.compile("^get[A-Z][\\w]*$");
    private static final Pattern GETTER_PATTERN_2 = Pattern.compile("^is[A-Z][\\w]*$");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z][\\w]*$");
    private static final String ERROR_METHOD_NAME_BLANK = "Argument 'methodName' must not be blank";
    private static final String ERROR_CLAZZ_NULL = "Argument 'clazz' must not be null";
    private static final String ERROR_PROPERTY_NAME_BLANK = "Argument 'propertyName' must not be blank";
    private static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    private static final String MESSAGE = "message";

    private ObjectUtils() {
    }

    private static void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
        PRIMITIVE_TYPE_COMPATIBLE_TYPES.put(left.getName(), right.getName());
        PRIMITIVE_TYPE_COMPATIBLE_TYPES.put(right.getName(), left.getName());
    }

    public static void requireState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    public static void requireState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static byte[] requireNonEmpty(@Nonnull byte[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static byte[] requireNonEmpty(@Nonnull byte[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static short[] requireNonEmpty(@Nonnull short[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static short[] requireNonEmpty(@Nonnull short[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static int[] requireNonEmpty(@Nonnull int[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static int[] requireNonEmpty(@Nonnull int[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static long[] requireNonEmpty(@Nonnull long[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static long[] requireNonEmpty(@Nonnull long[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static float[] requireNonEmpty(@Nonnull float[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static float[] requireNonEmpty(@Nonnull float[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static double[] requireNonEmpty(@Nonnull double[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static double[] requireNonEmpty(@Nonnull double[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static char[] requireNonEmpty(@Nonnull char[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static char[] requireNonEmpty(@Nonnull char[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static boolean[] requireNonEmpty(@Nonnull boolean[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static boolean[] requireNonEmpty(@Nonnull boolean[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static <E> E[] requireNonEmpty(@Nonnull E[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static <E> E[] requireNonEmpty(@Nonnull E[] array, @Nonnull String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static Collection<?> requireNonEmpty(@Nonnull Collection<?> collection) {
        Objects.requireNonNull(collection);
        ObjectUtils.requireState(!collection.isEmpty());
        return collection;
    }

    public static Collection<?> requireNonEmpty(@Nonnull Collection<?> collection, @Nonnull String message) {
        Objects.requireNonNull(collection);
        ObjectUtils.requireState(!collection.isEmpty(), StringUtils.requireNonBlank(message, MESSAGE));
        return collection;
    }

    public static Map<?, ?> requireNonEmpty(@Nonnull Map<?, ?> map) {
        Objects.requireNonNull(map);
        ObjectUtils.requireState(!map.isEmpty());
        return map;
    }

    public static Map<?, ?> requireNonEmpty(@Nonnull Map<?, ?> map, @Nonnull String message) {
        Objects.requireNonNull(map);
        ObjectUtils.requireState(!map.isEmpty(), StringUtils.requireNonBlank(message, MESSAGE));
        return map;
    }

    public static boolean isGetterMethod(@Nonnull Method method) {
        return ObjectUtils.isGetterMethod(method, false);
    }

    public static boolean isGetterMethod(@Nonnull Method method, boolean removeAbstractModifier) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return ObjectUtils.isGetterMethod(MethodDescriptor.forMethod(method, removeAbstractModifier));
    }

    public static boolean isGetterMethod(@Nonnull MethodDescriptor method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return ObjectUtils.isInstanceMethod(method) && (GETTER_PATTERN_1.matcher(method.getName()).matches() || GETTER_PATTERN_2.matcher(method.getName()).matches());
    }

    public static boolean isSetterMethod(@Nonnull Method method) {
        return ObjectUtils.isSetterMethod(method, false);
    }

    public static boolean isSetterMethod(@Nonnull Method method, boolean removeAbstractModifier) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return ObjectUtils.isSetterMethod(MethodDescriptor.forMethod(method, removeAbstractModifier));
    }

    public static boolean isSetterMethod(@Nonnull MethodDescriptor method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return ObjectUtils.isInstanceMethod(method) && SETTER_PATTERN.matcher(method.getName()).matches();
    }

    public static boolean isInstanceMethod(@Nonnull Method method) {
        return ObjectUtils.isInstanceMethod(method, false);
    }

    public static boolean isInstanceMethod(@Nonnull Method method, boolean removeAbstractModifier) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return ObjectUtils.isInstanceMethod(MethodDescriptor.forMethod(method, removeAbstractModifier));
    }

    public static boolean isInstanceMethod(@Nonnull MethodDescriptor method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers);
    }

    public static boolean isMatchBetweenPrimitiveAndWrapperTypes(@Nonnull Class<?> leftType, @Nonnull Class<?> rightType) {
        Objects.requireNonNull(leftType, "Left type is null!");
        Objects.requireNonNull(rightType, "Right type is null!");
        return ObjectUtils.isMatchBetweenPrimitiveAndWrapperTypes(leftType.getName(), rightType.getName());
    }

    public static boolean isMatchBetweenPrimitiveAndWrapperTypes(@Nonnull String leftType, @Nonnull String rightType) {
        StringUtils.requireNonBlank(leftType, "Left type is null!");
        StringUtils.requireNonBlank(rightType, "Right type is null!");
        String r = PRIMITIVE_TYPE_COMPATIBLE_TYPES.get(leftType);
        return r != null && r.equals(rightType);
    }

    @Nullable
    private static Method findDeclaredMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class[] parameterTypes) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        StringUtils.requireNonBlank(methodName, ERROR_METHOD_NAME_BLANK);
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (method != null) {
                    return method;
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nonnull
    public static String getGetterName(@Nonnull String propertyName) {
        StringUtils.requireNonBlank(propertyName, ERROR_PROPERTY_NAME_BLANK);
        return PROPERTY_GET_PREFIX + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    @Nonnull
    public static String getSetterName(@Nonnull String propertyName) {
        StringUtils.requireNonBlank(propertyName, ERROR_PROPERTY_NAME_BLANK);
        return PROPERTY_SET_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static boolean isGetter(@Nullable String name, @Nullable Class[] args) {
        if (StringUtils.isBlank(name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        if (name.startsWith(PROPERTY_GET_PREFIX)) {
            return (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0));
        }
        if (name.startsWith(PROPERTY_IS_PREFIX)) {
            return (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
        }
        return false;
    }

    @Nullable
    public static String getPropertyForGetter(@Nullable String getterName) {
        if (StringUtils.isBlank(getterName)) {
            return null;
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return ObjectUtils.convertPropertyName(prop);
        }
        if (getterName.startsWith(PROPERTY_IS_PREFIX)) {
            String prop = getterName.substring(2);
            return ObjectUtils.convertPropertyName(prop);
        }
        return null;
    }

    @Nonnull
    private static String convertPropertyName(@Nonnull String prop) {
        if (Character.isUpperCase(prop.charAt(0)) && Character.isUpperCase(prop.charAt(1))) {
            return prop;
        }
        if (Character.isDigit(prop.charAt(0))) {
            return prop;
        }
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }

    @Nullable
    public static String getPropertyForSetter(@Nullable String setterName) {
        if (StringUtils.isBlank(setterName)) {
            return null;
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return ObjectUtils.convertPropertyName(prop);
        }
        return null;
    }

    public static boolean isSetter(@Nullable String name, @Nullable Class[] args) {
        if (StringUtils.isBlank(name) || args == null) {
            return false;
        }
        if (name.startsWith(PROPERTY_SET_PREFIX)) {
            if (args.length != 1) {
                return false;
            }
            return (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0));
        }
        return false;
    }

    public static boolean isAssignableOrConvertibleFrom(@Nullable Class<?> clazz, @Nullable Class<?> type) {
        if (type == null || clazz == null) {
            return false;
        }
        if (type.isPrimitive()) {
            Class<?> primitiveClass = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(type);
            return primitiveClass != null && clazz.isAssignableFrom(primitiveClass);
        }
        return clazz.isAssignableFrom(type);
    }

    static {
        ObjectUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        ObjectUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

