/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2018-2022 Andres Almiray.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.gradle.plugin.base.tasks

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.initialization.IncludedBuild
import org.gradle.api.tasks.TaskAction

/**
 * @author Andres Almiray
 * @since 0.18.0
 */
@CompileStatic
class ListIncludedBuildsTask extends AbstractReportingTask {
    @TaskAction
    void report() {
        if (project != project.rootProject) return

        Project rootProject = project.rootProject

        println('Total included builds: ' + console.cyan((rootProject.gradle.includedBuilds.size()).toString()) + '\n')
        rootProject.gradle.includedBuilds.each { printIncludedBuild(it) }
    }

    private void printIncludedBuild(IncludedBuild build) {
        println(build.name + ':')

        Map<String, String> props = [:]
        props.putAll([
            projectDir: build.projectDir.toString()
        ])
        doPrintMap(props, 1)
        println(' ')
    }
}
