/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.plugin.base.model;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.kordamp.gradle.plugin.base.ProjectConfigurationExtension;
import org.kordamp.gradle.plugin.base.model.CiManagement;
import org.kordamp.gradle.plugin.base.model.CredentialsSet;
import org.kordamp.gradle.plugin.base.model.CredentialsSetImpl;
import org.kordamp.gradle.plugin.base.model.Implementation;
import org.kordamp.gradle.plugin.base.model.IssueManagement;
import org.kordamp.gradle.plugin.base.model.Links;
import org.kordamp.gradle.plugin.base.model.MailingListSet;
import org.kordamp.gradle.plugin.base.model.MailingListSetImpl;
import org.kordamp.gradle.plugin.base.model.Organization;
import org.kordamp.gradle.plugin.base.model.Person;
import org.kordamp.gradle.plugin.base.model.PersonSet;
import org.kordamp.gradle.plugin.base.model.PersonSetImpl;
import org.kordamp.gradle.plugin.base.model.RepositorySet;
import org.kordamp.gradle.plugin.base.model.RepositorySetImpl;
import org.kordamp.gradle.plugin.base.model.Scm;
import org.kordamp.gradle.plugin.base.model.Specification;
import org.kordamp.gradle.util.CollectionUtils;
import org.kordamp.gradle.util.ConfigureUtil;
import org.kordamp.gradle.util.StringUtils;

public class Information
implements GroovyObject {
    private String name;
    private String description;
    private String inceptionYear;
    private String vendor;
    private List<String> tags;
    private final Project project;
    private final Organization organization;
    private final Links links;
    private final Scm scm;
    private final IssueManagement issueManagement;
    private final CiManagement ciManagement;
    private final RepositorySetImpl repositories;
    private final PersonSetImpl people;
    private final MailingListSetImpl mailingLists;
    private final CredentialsSetImpl credentials;
    private final Specification specification;
    private final Implementation implementation;
    private Specification spec;
    private Implementation impl;
    protected final ProjectConfigurationExtension config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Information(ProjectConfigurationExtension config, Project project) {
        CredentialsSetImpl credentialsSetImpl;
        MailingListSetImpl mailingListSetImpl;
        PersonSetImpl personSetImpl;
        RepositorySetImpl repositorySetImpl;
        CiManagement ciManagement;
        Project project2;
        ProjectConfigurationExtension projectConfigurationExtension;
        MetaClass metaClass;
        Implementation implementation;
        Specification specification;
        Implementation implementation2;
        Specification specification2;
        IssueManagement issueManagement;
        Scm scm;
        Links links;
        Organization organization;
        List list;
        this.tags = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.organization = organization = new Organization();
        this.links = links = new Links();
        this.scm = scm = new Scm();
        this.issueManagement = issueManagement = new IssueManagement();
        this.specification = specification2 = new Specification();
        this.implementation = implementation2 = new Implementation();
        this.spec = specification = new Specification();
        this.impl = implementation = new Implementation();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.config = projectConfigurationExtension = config;
        this.project = project2 = project;
        this.ciManagement = ciManagement = new CiManagement(project.getObjects());
        this.repositories = repositorySetImpl = new RepositorySetImpl(project.getObjects());
        this.people = personSetImpl = new PersonSetImpl(project.getObjects());
        this.mailingLists = mailingListSetImpl = new MailingListSetImpl(project.getObjects());
        this.credentials = credentialsSetImpl = new CredentialsSetImpl(project.getObjects());
    }

    public PersonSet getPeople() {
        return this.people;
    }

    public RepositorySet getRepositories() {
        return this.repositories;
    }

    public MailingListSet getMailingLists() {
        return this.mailingLists;
    }

    public CredentialsSet getCredentials() {
        return this.credentials;
    }

    public Map<String, Map<String, Object>> toMap() {
        return new LinkedHashMap<String, Map<String, Object>>(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"info", new LinkedHashMap(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", this.getName(), "description", this.description, "url", this.getUrl(), "inceptionYear", this.getInceptionYear(), "copyrightYear", this.getCopyrightYear(), "vendor", this.getVendor(), "authors", this.getAuthors(), "organization", this.organization.toMap(), "people", this.people.toMap(), "repositories", this.repositories.toMap(), "links", this.links.toMap(), "scm", this.scm.toMap(), "issueManagement", this.issueManagement.toMap(), "ciManagement", this.ciManagement.toMap(), "mailingLists", this.mailingLists.toMap(), "specification", this.specification.toMap(), "implementation", this.implementation.toMap(), "credentials", this.credentials.toMap()}))}));
    }

    public static void merge(Information o1, Information o2) {
        o2.normalize();
        String string = o1.name;
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : o2.getName();
        o1.setName(string2);
        String string3 = o1.getDescription();
        String string4 = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : o2.getDescription();
        o1.setDescription(string4);
        String string5 = o1.inceptionYear;
        String string6 = DefaultTypeTransformation.booleanUnbox((Object)string5) ? string5 : o2.getInceptionYear();
        o1.setInceptionYear(string6);
        String string7 = o1.vendor;
        String string8 = DefaultTypeTransformation.booleanUnbox((Object)string7) ? string7 : o2.getVendor();
        o1.setVendor(string8);
        List<String> list = CollectionUtils.merge(o1.getTags(), o2.getTags(), false);
        o1.setTags(list);
        Specification.merge(o1.spec, o2.spec);
        Implementation.merge(o1.impl, o2.impl);
        Organization.merge(o1.getOrganization(), o2.getOrganization());
        PersonSetImpl.merge(o1.people, o2.people);
        RepositorySetImpl.merge(o1.repositories, o2.repositories);
        Links.merge(o1.getLinks(), o2.getLinks());
        Scm.merge(o1.getScm(), o2.getScm());
        IssueManagement.merge(o1.getIssueManagement(), o2.getIssueManagement());
        CiManagement.merge(o1.getCiManagement(), o2.getCiManagement());
        MailingListSetImpl.merge(o1.mailingLists, o2.mailingLists);
        CredentialsSetImpl.merge(o1.credentials, o2.credentials);
        o1.normalize();
    }

    public List<String> validate(ProjectConfigurationExtension extension) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (StringUtils.isBlank(this.description) && extension.getPublishing().isEnabled()) {
            DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Project description is blank"}).toString());
        }
        if (StringUtils.isBlank(this.getVendor()) && extension.getPublishing().isEnabled()) {
            DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Project vendor is blank"}).toString());
        }
        if (StringUtils.isBlank(this.getUrl()) && extension.getPublishing().isEnabled()) {
            DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Project organization.url is blank"}).toString());
        }
        if (this.scm.getEnabled() && StringUtils.isBlank(this.scm.getUrl()) && this.links.getEnabled() && StringUtils.isBlank(this.links.getScm()) && extension.getPublishing().isEnabled()) {
            DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Project scm.url is blank"}).toString());
        }
        return errors;
    }

    public void people(Action<? super PersonSet> action) {
        action.execute((Object)this.people);
    }

    public void repositories(Action<? super RepositorySet> action) {
        action.execute((Object)this.repositories);
    }

    public void organization(Action<? super Organization> action) {
        action.execute((Object)this.organization);
    }

    public void links(Action<? super Links> action) {
        action.execute((Object)this.links);
    }

    public void scm(Action<? super Scm> action) {
        action.execute((Object)this.scm);
    }

    public void issueManagement(Action<? super IssueManagement> action) {
        action.execute((Object)this.issueManagement);
    }

    public void ciManagement(Action<? super CiManagement> action) {
        action.execute((Object)this.ciManagement);
    }

    public void mailingLists(Action<? super MailingListSet> action) {
        action.execute((Object)this.mailingLists);
    }

    public void credentials(Action<? super CredentialsSet> action) {
        action.execute((Object)this.credentials);
    }

    public void specification(Action<? super Specification> action) {
        action.execute((Object)this.spec);
    }

    public void implementation(Action<? super Implementation> action) {
        action.execute((Object)this.impl);
    }

    public void people(@DelegatesTo(strategy=1, value=PersonSet.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.people);
    }

    public void repositories(@DelegatesTo(strategy=1, value=RepositorySet.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.repositories);
    }

    public void organization(@DelegatesTo(strategy=1, value=Organization.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.organization);
    }

    public void links(@DelegatesTo(strategy=1, value=Links.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.links);
    }

    public void scm(@DelegatesTo(strategy=1, value=Scm.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.scm);
    }

    public void issueManagement(@DelegatesTo(strategy=1, value=IssueManagement.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.issueManagement);
    }

    public void ciManagement(@DelegatesTo(strategy=1, value=CiManagement.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.ciManagement);
    }

    public void mailingLists(@DelegatesTo(strategy=1, value=MailingListSet.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.mailingLists);
    }

    public void credentials(@DelegatesTo(strategy=1, value=CredentialsSet.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.credentials);
    }

    public void specification(@DelegatesTo(strategy=1, value=Specification.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.spec);
    }

    public void implementation(@DelegatesTo(strategy=1, value=Specification.class) Closure<Void> action) {
        ConfigureUtil.configure(action, this.impl);
    }

    public String getName() {
        String string = this.name;
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.project.getName();
    }

    public String getVendor() {
        Organization organization;
        String string = this.vendor;
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ((organization = this.organization) != null ? organization.getName() : null);
    }

    public String getUrl() {
        String string = this.links.getWebsite();
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.organization.getUrl();
    }

    public String getInceptionYear() {
        String string = this.inceptionYear;
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : Information.currentYear();
    }

    public Information normalize() {
        String string;
        String string2;
        if (this.spec.isEnabledSet()) {
            this.specification.setEnabled(this.spec.isEnabled());
        }
        String string3 = DefaultTypeTransformation.booleanUnbox((Object)(string2 = this.spec.getTitle())) ? string2 : this.project.getName();
        this.specification.setTitle(string3);
        String string4 = this.spec.getVersion();
        String string5 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : this.project.getVersion();
        this.specification.setVersion(ShortTypeHandling.castToString((Object)string5));
        String string6 = this.spec.getVendor();
        String string7 = DefaultTypeTransformation.booleanUnbox((Object)string6) ? string6 : this.getVendor();
        this.specification.setVendor(string7);
        if (this.impl.isEnabledSet()) {
            this.implementation.setEnabled(this.impl.getEnabled());
        }
        String string8 = DefaultTypeTransformation.booleanUnbox((Object)(string = this.impl.getTitle())) ? string : this.project.getName();
        this.implementation.setTitle(string8);
        String string9 = this.impl.getVersion();
        String string10 = DefaultTypeTransformation.booleanUnbox((Object)string9) ? string9 : this.project.getVersion();
        this.implementation.setVersion(ShortTypeHandling.castToString((Object)string10));
        String string11 = this.impl.getVendor();
        String string12 = DefaultTypeTransformation.booleanUnbox((Object)string11) ? string11 : this.getVendor();
        this.implementation.setVendor(string12);
        return this;
    }

    public List<String> getAuthors() {
        Reference authors = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getAuthors_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference authors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAuthors_closure1(Object _outerInstance, Object _thisObject, Reference authors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.authors = reference = authors;
            }

            public Object doCall(Person person) {
                Boolean bl;
                ArrayList<String> arrayList = new ArrayList<String>();
                List<String> list = person.getRoles();
                if (list != null) {
                    Object for$it$1 = null;
                    Iterator iterator = DefaultGroovyMethods.iterator(list);
                    while (iterator.hasNext()) {
                        for$it$1 = iterator.next();
                        Object var6_6 = for$it$1;
                        arrayList.add(var6_6 != null ? ((String)var6_6).toLowerCase() : null);
                    }
                }
                if (arrayList == null) {
                    bl = "author" == null;
                } else {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    List<String> list2 = person.getRoles();
                    if (list2 != null) {
                        Object for$it$3 = null;
                        Iterator iterator = DefaultGroovyMethods.iterator(list2);
                        while (iterator.hasNext()) {
                            for$it$3 = iterator.next();
                            Object var11_11 = for$it$3;
                            arrayList2.add(var11_11 != null ? ((String)var11_11).toLowerCase() : null);
                        }
                    }
                    bl = DefaultGroovyMethods.isCase(arrayList2, (Object)"author");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)bl)) {
                    String string = person.getName();
                    String author = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : person.getId();
                    if (DefaultTypeTransformation.booleanUnbox((Object)author)) {
                        return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.authors.get(), List.class)), (Object)author);
                    }
                    return null;
                }
                return null;
            }

            public Object call(Person person) {
                return this.doCall(person);
            }

            @Generated
            public List getAuthors() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.authors.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAuthors_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.people.forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _getAuthors_closure1(this, this, authors)), Consumer.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((List)authors.get())) && !this.people.isEmpty()) {
            Person person = (Person)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.people.getPeople(), (int)0), Person.class);
            List list = DefaultGroovyMethods.leftShift((List)((List)authors.get()), (Object)person.getName());
            Object object = DefaultTypeTransformation.booleanUnbox((Object)list) ? list : person.getId();
        }
        return (List)authors.get();
    }

    public String getCopyrightYear() {
        String initialYear = this.getInceptionYear();
        String currentYear = Information.currentYear();
        String year = initialYear;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)initialYear, (Object)currentYear)) {
            String string;
            year = string = StringGroovyMethods.plus((String)year, (CharSequence)StringGroovyMethods.plus((String)"-", (CharSequence)currentYear));
        }
        return year;
    }

    public static String currentYear() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        return Integer.valueOf(c.get(Calendar.YEAR)).toString();
    }

    public String resolveScmLink() {
        if (StringUtils.isNotBlank(this.scm.getUrl())) {
            return this.scm.getUrl();
        }
        return this.links.getScm();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Information.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public void setInceptionYear(String string) {
        this.inceptionYear = string;
    }

    @Generated
    public void setVendor(String string) {
        this.vendor = string;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> list) {
        this.tags = list;
    }

    @Generated
    public final Project getProject() {
        return this.project;
    }

    @Generated
    public final Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public final Links getLinks() {
        return this.links;
    }

    @Generated
    public final Scm getScm() {
        return this.scm;
    }

    @Generated
    public final IssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    @Generated
    public final CiManagement getCiManagement() {
        return this.ciManagement;
    }

    @Generated
    public final Specification getSpecification() {
        return this.specification;
    }

    @Generated
    public final Implementation getImplementation() {
        return this.implementation;
    }
}

