/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.gradle.api.Project;
import org.kordamp.gradle.annotations.DependsOn;
import org.kordamp.gradle.annotations.Evicts;
import org.kordamp.gradle.util.MethodDescriptor;
import org.kordamp.gradle.util.ObjectUtils;
import org.kordamp.gradle.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Project.class);
    private static final String ERROR_CLASS_NULL = "Argument 'class' must not be null";
    private static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    private static final String ERROR_SUFFIX_NULL = "Argument 'suffix' must not be null";
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private static final String ERROR_ANNOTATION_NULL = "Argument 'annotation' must not be null";
    private static final String ERROR_ANNOTATION_TYPE_NULL = "Argument 'annotationType' must not be null";
    private static final String ERROR_FIELD_NULL = "Argument 'field' must not be null";
    private static final String ERROR_SETTER_METHOD_NULL = "Argument 'setterMethod' must not be null";
    private static final String VALUE = "value";

    private AnnotationUtils() {
    }

    @Nonnull
    public static List<Annotation> harvestQualifiers(@Nonnull Class<?> klass) {
        Annotation[] annotations;
        Objects.requireNonNull(klass, ERROR_CLASS_NULL);
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = klass.getAnnotations()) {
            Named named;
            if (!AnnotationUtils.isAnnotatedWith(annotation, Qualifier.class)) continue;
            if (Named.class.isAssignableFrom(annotation.getClass()) && StringUtils.isBlank((named = (Named)annotation).value())) {
                list.add((Annotation)AnnotationUtils.named(StringUtils.getPropertyName(klass)));
                continue;
            }
            list.add(annotation);
        }
        return list;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Class<?> klass, @Nonnull Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(klass, annotationType, false);
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Class<?> klass, @Nonnull Class<A> annotationType, boolean deep) {
        Objects.requireNonNull(klass, ERROR_CLASS_NULL);
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        while (klass != null) {
            A annotation = AnnotationUtils.findAnnotation(klass.getAnnotations(), annotationType, deep);
            if (annotation != null) {
                return annotation;
            }
            klass = klass.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Method method, @Nonnull Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(method, annotationType, false);
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Method method, @Nonnull Class<A> annotationType, boolean deep) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        for (Annotation annotation : method.getAnnotations()) {
            A a;
            if (annotationType.equals(annotation.annotationType())) {
                return (A)annotation;
            }
            if (!deep || (a = AnnotationUtils.findAnnotation(annotation.annotationType().getAnnotations(), annotationType, deep)) == null) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Annotation[] annotations, @Nonnull Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(annotations, annotationType, false);
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Annotation[] annotations, @Nonnull Class<A> annotationType, boolean deep) {
        Objects.requireNonNull(annotations, "Argument 'annotations' must not be null");
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        for (Annotation annotation : annotations) {
            if (!annotationType.isAssignableFrom(annotation.annotationType())) continue;
            return (A)annotation;
        }
        return null;
    }

    public static boolean isAnnotatedWith(@Nonnull Object instance, @Nonnull Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotatedWith(Objects.requireNonNull(instance, ERROR_INSTANCE_NULL).getClass(), annotationType);
    }

    public static boolean isAnnotatedWith(@Nonnull Method method, @Nonnull Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotatedWith(method, annotationType, false);
    }

    public static boolean isAnnotatedWith(@Nonnull Method method, @Nonnull Class<? extends Annotation> annotationType, boolean deep) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        for (Annotation annotation : method.getAnnotations()) {
            if (annotationType.equals(annotation.annotationType())) {
                return true;
            }
            if (!deep || !AnnotationUtils.isAnnotatedWith(annotation, annotationType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotatedWith(@Nonnull Annotation annotation, @Nonnull Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotatedWith(annotation, annotationType, false);
    }

    public static boolean isAnnotatedWith(@Nonnull Annotation annotation, @Nonnull Class<? extends Annotation> annotationType, boolean deep) {
        Objects.requireNonNull(annotation, ERROR_ANNOTATION_NULL);
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        for (Annotation a : annotation.annotationType().getAnnotations()) {
            if (annotationType.equals(a.annotationType())) {
                return true;
            }
            if (!deep || !AnnotationUtils.isAnnotatedWith(a, annotationType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotatedWith(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotationType) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        Objects.requireNonNull(annotationType, ERROR_ANNOTATION_TYPE_NULL);
        while (clazz != null) {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return true;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!AnnotationUtils.isAnnotatedWith(iface, annotationType)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    @Nonnull
    public static <T> T requireAnnotation(@Nonnull T instance, @Nonnull Class<? extends Annotation> annotationType) {
        if (!AnnotationUtils.isAnnotatedWith(instance, annotationType)) {
            throw new IllegalArgumentException("Instance of " + instance.getClass() + " is not annotated with " + annotationType.getName());
        }
        return instance;
    }

    @Nonnull
    public static <T> Class<T> requireAnnotation(@Nonnull Class<T> klass, @Nonnull Class<? extends Annotation> annotationType) {
        if (!AnnotationUtils.isAnnotatedWith(klass, annotationType)) {
            throw new IllegalArgumentException("Class " + klass.getName() + " is not annotated with " + annotationType.getName());
        }
        return klass;
    }

    @Nonnull
    public static String[] getDependsOn(@Nonnull Object instance) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        DependsOn dependsOn = instance.getClass().getAnnotation(DependsOn.class);
        return dependsOn != null ? dependsOn.value() : new String[]{};
    }

    @Nonnull
    public static String getEvicts(@Nonnull Object instance) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        Evicts evicts = instance.getClass().getAnnotation(Evicts.class);
        return evicts != null ? evicts.value() : "";
    }

    @Nonnull
    public static String nameFor(@Nonnull Class<?> klass) {
        return AnnotationUtils.nameFor(klass, false);
    }

    @Nonnull
    public static String nameFor(@Nonnull Class<?> klass, boolean simple) {
        Objects.requireNonNull(klass, ERROR_CLASS_NULL);
        Named annotation = klass.getAnnotation(Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            return annotation.value();
        }
        return simple ? klass.getSimpleName() : klass.getName();
    }

    @Nonnull
    public static String nameFor(@Nonnull Object instance) {
        return AnnotationUtils.nameFor(instance, false);
    }

    @Nonnull
    public static String nameFor(@Nonnull Object instance, boolean simple) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        Named annotation = instance.getClass().getAnnotation(Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            return annotation.value();
        }
        return simple ? instance.getClass().getSimpleName() : instance.getClass().getName();
    }

    @Nonnull
    public static String nameFor(@Nonnull Field field) {
        return AnnotationUtils.nameFor(field, false);
    }

    @Nonnull
    public static String nameFor(@Nonnull Field field, boolean simple) {
        Objects.requireNonNull(field, ERROR_FIELD_NULL);
        Named annotation = field.getAnnotation(Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            return annotation.value();
        }
        return simple ? field.getType().getSimpleName() : field.getType().getName();
    }

    @Nonnull
    public static String[] namesFor(@Nonnull Field field) {
        Objects.requireNonNull(field, ERROR_FIELD_NULL);
        ArrayList<String> names = new ArrayList<String>();
        Named annotation = field.getAnnotation(Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            names.add(annotation.value());
        } else {
            names.add(field.getName());
        }
        names.add(field.getType().getName());
        return names.toArray(new String[names.size()]);
    }

    @Nonnull
    public static String nameFor(@Nonnull Method setterMethod) {
        Objects.requireNonNull(setterMethod, ERROR_SETTER_METHOD_NULL);
        Class<?>[] parameterTypes = setterMethod.getParameterTypes();
        ObjectUtils.requireState(parameterTypes != null && parameterTypes.length > 0, "Argument 'setterMethod' must have at least one parameter. " + MethodDescriptor.forMethod(setterMethod));
        Named annotation = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter(setterMethod, 0), Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            return annotation.value();
        }
        return parameterTypes[0].getName();
    }

    @Nonnull
    public static String[] namesFor(@Nonnull Method setterMethod) {
        Objects.requireNonNull(setterMethod, ERROR_SETTER_METHOD_NULL);
        Class<?>[] parameterTypes = setterMethod.getParameterTypes();
        ObjectUtils.requireState(parameterTypes != null && parameterTypes.length > 0, "Argument 'setterMethod' must have at least one parameter. " + MethodDescriptor.forMethod(setterMethod));
        ArrayList<String> names = new ArrayList<String>();
        Named annotation = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter(setterMethod, 0), Named.class);
        if (annotation != null && StringUtils.isNotBlank(annotation.value())) {
            names.add(annotation.value());
        } else if (ObjectUtils.isSetterMethod(setterMethod)) {
            names.add(StringUtils.uncapitalize(setterMethod.getName().substring(3)));
        } else {
            names.add(StringUtils.uncapitalize(setterMethod.getName()));
        }
        names.add(parameterTypes[0].getName());
        return names.toArray(new String[names.size()]);
    }

    @Nonnull
    public static Class<?> parameterTypeAt(@Nonnull Method method, int index) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        Class<?>[] parameterTypes = method.getParameterTypes();
        ObjectUtils.requireState(parameterTypes != null && parameterTypes.length >= index, "Index " + index + " is out of bounds");
        return parameterTypes[index];
    }

    @Nonnull
    public static Annotation[] annotationsOfMethodParameter(@Nonnull Method method, int index) {
        AnnotationUtils.parameterTypeAt(method, index);
        return method.getParameterAnnotations()[index];
    }

    @Nonnull
    public static <T> Map<String, T> mapInstancesByName(@Nonnull Collection<T> instances, @Nonnull String suffix) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (T instance : instances) {
            map.put(StringUtils.getLogicalPropertyName(AnnotationUtils.nameFor(instance), suffix), instance);
        }
        return map;
    }

    @Nonnull
    public static <T> Map<String, T> mapInstancesByName(@Nonnull String context, @Nonnull Collection<T> instances, @Nonnull String suffix, @Nonnull String type) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (T instance : instances) {
            Object evictedInstance;
            String currentEvicts = AnnotationUtils.getEvicts(instance);
            String name = StringUtils.getLogicalPropertyName(AnnotationUtils.nameFor(instance), suffix);
            Object v0 = evictedInstance = StringUtils.isBlank(currentEvicts) ? null : map.get(currentEvicts);
            if (evictedInstance != null) {
                String evictedEvicts = AnnotationUtils.getEvicts(evictedInstance);
                if (StringUtils.isNotBlank(evictedEvicts)) {
                    throw new IllegalArgumentException(type + " " + name + " has an eviction conflict between " + instance + " and " + evictedInstance);
                }
                name = currentEvicts;
                LOG.info("[" + context + "] {} {} with instance {} evicted by {}", new Object[]{type, name, evictedInstance, instance});
                map.put(name, instance);
                continue;
            }
            name = StringUtils.isBlank(currentEvicts) ? name : currentEvicts;
            Object previousInstance = map.get(name);
            if (previousInstance != null) {
                if (StringUtils.isBlank(AnnotationUtils.getEvicts(previousInstance))) {
                    throw new IllegalArgumentException(type + " " + name + " neither " + instance + " nor " + previousInstance + " is marked with @Evict");
                }
                LOG.info("[" + context + "] {} {} with instance {} evicted by {}", new Object[]{type, name, instance, previousInstance});
                continue;
            }
            map.put(name, instance);
        }
        return map;
    }

    @Nonnull
    public static <T> Map<String, T> sortByDependencies(@Nonnull String context, @Nonnull Collection<T> instances, @Nonnull String suffix, @Nonnull String type) {
        return AnnotationUtils.sortByDependencies(context, instances, suffix, type, Collections.emptyList());
    }

    @Nonnull
    public static <T> Map<String, T> sortByDependencies(@Nonnull String context, @Nonnull Collection<T> instances, @Nonnull String suffix, @Nonnull String type, @Nonnull List<String> order) {
        Objects.requireNonNull(instances, "Argument 'instances' must not be null");
        Objects.requireNonNull(suffix, ERROR_SUFFIX_NULL);
        Objects.requireNonNull(type, "Argument 'type' must not be null");
        Objects.requireNonNull(order, "Argument 'order' must not be null");
        Map<String, Object> instancesByName = AnnotationUtils.mapInstancesByName(context, instances, suffix, type);
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(instancesByName);
        if (!order.isEmpty()) {
            LinkedHashMap<String, T> tmp1 = new LinkedHashMap<String, T>(instancesByName);
            LinkedHashMap<String, Object> tmp2 = new LinkedHashMap<String, Object>();
            for (String name : order) {
                if (!tmp1.containsKey(name)) continue;
                tmp2.put(name, tmp1.remove(name));
            }
            tmp2.putAll(tmp1);
            map.clear();
            map.putAll(tmp2);
        }
        ArrayList sorted = new ArrayList();
        LinkedHashSet<String> instanceDeps = new LinkedHashSet<String>();
        while (!map.isEmpty()) {
            Object[] dependsOn;
            String instanceName;
            int processed = 0;
            LOG.info("[" + context + "] Current {} order is {}", (Object)type, instancesByName.keySet());
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                instanceName = (String)entry.getKey();
                dependsOn = AnnotationUtils.getDependsOn(entry.getValue());
                LOG.debug("[" + context + "] Processing {} '{}'", (Object)type, (Object)instanceName);
                LOG.debug("[" + context + "]   depends on '{}'", (Object)Arrays.toString(dependsOn));
                if (dependsOn.length != 0) {
                    LOG.debug("[" + context + "]   checking {} '{}' dependencies ({})", new Object[]{type, instanceName, dependsOn.length});
                    boolean failedDep = false;
                    Object[] objectArray = dependsOn;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object dep = objectArray[i];
                        LOG.debug("[" + context + "]   checking {} '{}' dependency {}", new Object[]{type, instanceName, dep});
                        if (!instanceDeps.contains(dep)) {
                            LOG.debug("[" + context + "]   skipped {} '{}', since dependency '{}' not yet added", new Object[]{type, instanceName, dep});
                            failedDep = true;
                            break;
                        }
                        LOG.debug("[" + context + "]   {} '{}' dependency '{}' already added", new Object[]{type, instanceName, dep});
                    }
                    if (failedDep) continue;
                }
                LOG.debug("[" + context + "]   adding {} '{}', since all dependencies have been added", (Object)type, (Object)instanceName);
                sorted.add(entry.getValue());
                instanceDeps.add(instanceName);
                iter.remove();
                ++processed;
            }
            if (processed == 0) {
                LOG.debug("[" + context + "]   unresolved {} dependencies detected", (Object)type);
                for (Map.Entry entry : map.entrySet()) {
                    instanceName = (String)entry.getKey();
                    dependsOn = AnnotationUtils.getDependsOn(entry.getValue());
                    LOG.debug("[" + context + "]   {} {} ", (Object)type, (Object)instanceName);
                    if (dependsOn.length != 0) {
                        for (Object dep : dependsOn) {
                            LOG.debug("    depends on {}", dep);
                        }
                    } else {
                        LOG.debug("[" + context + "]   problem while resolving dependencies.");
                        LOG.debug("[" + context + "]   unable to resolve dependency hierarchy.");
                    }
                    if (instanceDeps.contains(instanceName)) continue;
                    LOG.debug("[" + context + "]   adding {} '{}' at end", (Object)type, (Object)instanceName);
                    sorted.add(entry.getValue());
                    instanceDeps.add(instanceName);
                }
                break;
            }
            if (sorted.size() != instancesByName.size()) continue;
            LOG.info("[" + context + "] {} dependency ordering complete", (Object)type);
            break;
        }
        instancesByName = AnnotationUtils.mapInstancesByName(sorted, suffix);
        LOG.info("[" + context + "] Computed {} order is {}", (Object)type, instancesByName.keySet());
        return instancesByName;
    }

    @Nonnull
    public static Named named(@Nonnull String name) {
        return new NamedImpl(Objects.requireNonNull(name, "Argument 'name' must not be null"));
    }

    private static class NamedImpl
    implements Named,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final String value;

        public NamedImpl(String value) {
            this.value = Objects.requireNonNull(value, AnnotationUtils.VALUE);
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * AnnotationUtils.VALUE.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Named)) {
                return false;
            }
            Named other = (Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            return "@" + Named.class.getName() + "(value=" + this.value + ")";
        }

        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }
    }
}

