/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.plugin.base.plugins;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Project;
import org.kordamp.gradle.plugin.base.ProjectConfigurationExtension;
import org.kordamp.gradle.plugin.base.plugins.AbstractFeature;
import org.kordamp.gradle.util.CollectionUtils;
import org.kordamp.gradle.util.StringUtils;

public class Sonar
extends AbstractFeature {
    private static final String PLUGIN_ID = "org.kordamp.gradle.sonar";
    private Boolean ignoreFailures;
    private String hostUrl;
    private String projectKey;
    private String organization;
    private String login;
    private String password;
    private Map<String, Object> configProperties;
    private Set<String> excludes;
    private final Set<Project> excludedProjects;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Sonar(ProjectConfigurationExtension config, Project project) {
        super(config, project, Sonar.getPLUGIN_ID());
        MetaClass metaClass;
        Map map;
        String string;
        this.hostUrl = string = "https://sonarcloud.io";
        this.configProperties = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.excludes = linkedHashSet;
        LinkedHashSet<Project> linkedHashSet2 = new LinkedHashSet<Project>();
        this.excludedProjects = linkedHashSet2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected AbstractFeature getParentFeature() {
        return ((ProjectConfigurationExtension)this.project.getRootProject().getExtensions().getByType(ProjectConfigurationExtension.class)).getQuality().getSonar();
    }

    @Override
    protected void normalizeEnabled() {
        if (!this.isEnabledSet()) {
            this.setEnabled(this.isApplied());
        }
    }

    @Override
    public Map<String, Map<String, Object>> toMap() {
        LinkedHashMap map = new LinkedHashMap(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", this.getEnabled()}));
        if (this.isRoot()) {
            String string = this.hostUrl;
            ScriptBytecodeAdapter.setProperty((Object)string, null, map, (String)"hostUrl");
            String string2 = this.projectKey;
            ScriptBytecodeAdapter.setProperty((Object)string2, null, map, (String)"projectKey");
            String string3 = this.organization;
            ScriptBytecodeAdapter.setProperty((Object)string3, null, map, (String)"organization");
            String string4 = this.login;
            ScriptBytecodeAdapter.setProperty((Object)string4, null, map, (String)"login");
            String string5 = this.password;
            ScriptBytecodeAdapter.setProperty((Object)string5, null, map, (String)"password");
            boolean bl = this.getIgnoreFailures();
            ScriptBytecodeAdapter.setProperty((Object)bl, null, map, (String)"ignoreFailures");
            Map<String, Object> map2 = this.configProperties;
            ScriptBytecodeAdapter.setProperty(map2, null, map, (String)"configProperties");
            Set<String> set = this.excludes;
            ScriptBytecodeAdapter.setProperty(set, null, map, (String)"excludes");
            Set<Project> set2 = this.excludedProjects;
            ScriptBytecodeAdapter.setProperty(set2, null, map, (String)"excludedProjects");
        }
        return new LinkedHashMap<String, Map<String, Object>>(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sonar", map}));
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures == null || DefaultTypeTransformation.booleanUnbox((Object)this.ignoreFailures);
    }

    protected boolean isIgnoreFailuresSet() {
        return this.ignoreFailures != null;
    }

    @Override
    public void normalize() {
        if (this.projectKey == null) {
            String string;
            this.projectKey = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)String.valueOf(this.project.getGroup()), (CharSequence)":"), (CharSequence)this.project.getName());
        }
        super.normalize();
    }

    @Override
    protected boolean hasBasePlugin(Project project) {
        return project.getPluginManager().hasPlugin("java-base");
    }

    public List<String> validate(ProjectConfigurationExtension extension) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (this.getEnabled()) {
            String extHostUrl = System.getProperty("sonar.host.url");
            if (!StringUtils.isBlank(extHostUrl)) {
                String string;
                this.hostUrl = string = extHostUrl;
            }
            String extLogin = System.getProperty("sonar.login");
            if (!StringUtils.isBlank(extLogin)) {
                String string;
                this.login = string = extLogin;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)this.hostUrl, (Object)"https://sonarcloud.io") && StringUtils.isBlank(this.organization)) {
                DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Sonar organization is blank"}).toString());
            }
            if (StringUtils.isBlank(this.login)) {
                DefaultGroovyMethods.leftShift((List)errors, (Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"[", "] Sonar login is blank"}).toString());
            }
        }
        return errors;
    }

    public void exclude(String str) {
        DefaultGroovyMethods.leftShift(this.excludes, (Object)str);
    }

    public void excludeProject(Project p) {
        if (p != null) {
            DefaultGroovyMethods.leftShift(this.excludedProjects, (Object)p);
        }
    }

    public static void merge(Sonar o1, Sonar o2) {
        AbstractFeature.merge(o1, o2);
        String string = o1.getHostUrl();
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : o2.getHostUrl();
        o1.setHostUrl(string2);
        String string3 = o1.getProjectKey();
        String string4 = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : o2.getProjectKey();
        o1.setProjectKey(string4);
        String string5 = o1.getOrganization();
        String string6 = DefaultTypeTransformation.booleanUnbox((Object)string5) ? string5 : o2.getOrganization();
        o1.setOrganization(string6);
        String string7 = o1.getLogin();
        String string8 = DefaultTypeTransformation.booleanUnbox((Object)string7) ? string7 : o2.getLogin();
        o1.setLogin(string8);
        String string9 = o1.getPassword();
        String string10 = DefaultTypeTransformation.booleanUnbox((Object)string9) ? string9 : o2.getPassword();
        o1.setPassword(string10);
        Sonar sonar = o2;
        Map<String, Object> map = CollectionUtils.merge(o1.getConfigProperties(), sonar != null ? sonar.getConfigProperties() : null, false);
        o1.setConfigProperties(map);
        Set<String> set = CollectionUtils.merge(o1.getExcludes(), o2.getExcludes(), false);
        o1.setExcludes(set);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Sonar.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static String getPLUGIN_ID() {
        return PLUGIN_ID;
    }

    @Generated
    public void setIgnoreFailures(Boolean bl) {
        this.ignoreFailures = bl;
    }

    @Generated
    public String getHostUrl() {
        return this.hostUrl;
    }

    @Generated
    public void setHostUrl(String string) {
        this.hostUrl = string;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public void setProjectKey(String string) {
        this.projectKey = string;
    }

    @Generated
    public String getOrganization() {
        return this.organization;
    }

    @Generated
    public void setOrganization(String string) {
        this.organization = string;
    }

    @Generated
    public String getLogin() {
        return this.login;
    }

    @Generated
    public void setLogin(String string) {
        this.login = string;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    @Generated
    public void setConfigProperties(Map<String, Object> map) {
        this.configProperties = map;
    }

    @Generated
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Generated
    public void setExcludes(Set<String> set) {
        this.excludes = set;
    }

    @Generated
    public final Set<Project> getExcludedProjects() {
        return this.excludedProjects;
    }
}

