/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.kopitubruk.util.json.JSONArrayData;
import org.kopitubruk.util.json.JSONReflectedClass;
import org.kopitubruk.util.json.ReflectUtil;

class JSONConfigUtil {
    static final int DEFAULT_INITIAL_CAPACITY = 16;

    static List<DateFormat> addDateParseFormats(List<DateFormat> dest, Collection<? extends DateFormat> src) {
        List<DateFormat> result = dest;
        if (src != null) {
            ArrayList<DateFormat> cloneSrc = new ArrayList<DateFormat>(src.size());
            for (DateFormat dateFormat : src) {
                if (dateFormat == null) continue;
                cloneSrc.add((DateFormat)dateFormat.clone());
            }
            if (cloneSrc.size() > 0) {
                if (result == null) {
                    cloneSrc.trimToSize();
                    result = cloneSrc;
                } else {
                    ArrayList<DateFormat> tmp = new ArrayList<DateFormat>(result.size() + cloneSrc.size());
                    tmp.addAll(result);
                    tmp.addAll(cloneSrc);
                    result = tmp;
                }
            }
        }
        return result;
    }

    static Map<Class<? extends Number>, NumberFormat> mergeFormatMaps(Map<Class<? extends Number>, NumberFormat> dest, Map<Class<? extends Number>, NumberFormat> src) {
        Map<Class<? extends Number>, NumberFormat> result;
        block5: {
            block6: {
                int tableSize;
                block7: {
                    result = dest;
                    if (src == null) break block5;
                    if (result != null) break block6;
                    result = new HashMap<Class<? extends Number>, NumberFormat>(src);
                    tableSize = JSONConfigUtil.tableSizeFor(result.size());
                    ArrayList<Class<? extends Number>> badKeys = null;
                    for (Map.Entry<Class<? extends Number>, NumberFormat> entry : result.entrySet()) {
                        if (entry.getKey() != null && entry.getValue() != null) {
                            entry.setValue((NumberFormat)entry.getValue().clone());
                            continue;
                        }
                        if (badKeys == null) {
                            badKeys = new ArrayList<Class<? extends Number>>();
                        }
                        badKeys.add(entry.getKey());
                    }
                    if (badKeys == null) break block5;
                    for (Class clazz : badKeys) {
                        result.remove(clazz);
                    }
                    if (result.size() >= 1) break block7;
                    result = null;
                    break block5;
                }
                if (tableSize <= JSONConfigUtil.tableSizeFor(result.size())) break block5;
                result = new HashMap<Class<? extends Number>, NumberFormat>(result);
                break block5;
            }
            for (Map.Entry<Class<? extends Number>, NumberFormat> entry : src.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                result.put(entry.getKey(), (NumberFormat)entry.getValue().clone());
            }
        }
        return result;
    }

    static Map<Class<?>, JSONReflectedClass> addReflectClass(Map<Class<?>, JSONReflectedClass> refClasses, Object obj) {
        return JSONConfigUtil.addReflectClassesSafe(refClasses, JSONConfigUtil.getReflectClassCollection(obj));
    }

    static Map<Class<?>, JSONReflectedClass> addReflectClasses(Map<Class<?>, JSONReflectedClass> refClasses, Collection<?> classes) {
        return JSONConfigUtil.addReflectClassesSafe(refClasses, JSONConfigUtil.getReflectClassCollection(classes));
    }

    private static Map<Class<?>, JSONReflectedClass> addReflectClassesSafe(Map<Class<?>, JSONReflectedClass> refClasses, Collection<?> classes) {
        int tableSize;
        if (classes.size() < 1) {
            return refClasses;
        }
        if (refClasses == null) {
            refClasses = new HashMap();
            tableSize = 16;
        } else {
            tableSize = JSONConfigUtil.tableSizeFor(refClasses.size());
        }
        for (Object obj : classes) {
            JSONReflectedClass refClass = ReflectUtil.ensureReflectedClass(obj);
            refClasses.put(refClass.getObjClass(), refClass);
        }
        if (tableSize > JSONConfigUtil.tableSizeFor(refClasses.size())) {
            refClasses = JSONConfigUtil.trimClasses(refClasses);
        }
        return refClasses;
    }

    static Map<Class<?>, JSONReflectedClass> removeReflectClass(Map<Class<?>, JSONReflectedClass> refClasses, Object obj) {
        return JSONConfigUtil.removeReflectClassesSafe(refClasses, JSONConfigUtil.getReflectClassCollection(obj));
    }

    static Map<Class<?>, JSONReflectedClass> removeReflectClasses(Map<Class<?>, JSONReflectedClass> refClasses, Collection<?> classes) {
        return JSONConfigUtil.removeReflectClassesSafe(refClasses, JSONConfigUtil.getReflectClassCollection(classes));
    }

    private static Map<Class<?>, JSONReflectedClass> removeReflectClassesSafe(Map<Class<?>, JSONReflectedClass> refClasses, Collection<?> classes) {
        if (refClasses == null || classes.size() < 1 || refClasses.size() < 1) {
            return refClasses;
        }
        int tableSize = JSONConfigUtil.tableSizeFor(refClasses.size());
        for (Object obj : classes) {
            refClasses.remove(ReflectUtil.getClass(obj));
        }
        if (tableSize > JSONConfigUtil.tableSizeFor(refClasses.size())) {
            refClasses = JSONConfigUtil.trimClasses(refClasses);
        }
        return refClasses;
    }

    private static Map<Class<?>, JSONReflectedClass> trimClasses(Map<Class<?>, JSONReflectedClass> refClasses) {
        return refClasses.size() > 0 ? new HashMap(refClasses) : null;
    }

    private static Collection<?> getReflectClassCollection(Object obj) {
        if (obj == null) {
            return new ArrayList(0);
        }
        if (obj instanceof Class || obj instanceof JSONReflectedClass) {
            return Arrays.asList(obj);
        }
        if (JSONConfigUtil.isArrayType(obj)) {
            LinkedHashSet<Object> objs = new LinkedHashSet<Object>();
            for (Object element : new JSONArrayData(obj)) {
                if (element == null) continue;
                if (element instanceof Class || element instanceof JSONReflectedClass) {
                    objs.add(element);
                    continue;
                }
                if (JSONConfigUtil.isArrayType(element)) {
                    objs.addAll(JSONConfigUtil.getReflectClassCollection(element));
                    continue;
                }
                objs.add(ReflectUtil.getClass(element));
            }
            return objs;
        }
        List<Class> list = Arrays.asList(ReflectUtil.getClass(obj));
        return list;
    }

    private static boolean isArrayType(Object obj) {
        return obj instanceof Iterable || obj instanceof Enumeration || obj.getClass().isArray();
    }

    static int tableSizeFor(int size) {
        if (size > 0) {
            int tableSize;
            for (tableSize = 1; tableSize < size; tableSize <<= 1) {
            }
            return tableSize;
        }
        return 0;
    }

    private JSONConfigUtil() {
    }
}

