/*
 * Decompiled with CFR 0.152.
 */
package org.koin.test.core.instance;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.instance.Instance;
import org.koin.core.instance.InstanceHolder;
import org.koin.core.parameter.ParameterList;
import org.koin.dsl.definition.BeanDefinition;
import org.koin.error.BeanInstanceCreationException;
import org.koin.error.DependencyResolutionException;
import org.koin.error.NoBeanDefFoundException;
import org.koin.test.error.BrokenDefinitionException;
import org.mockito.Mockito;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J%\u0010\b\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000f\"\u0004\b\u0001\u0010\u00012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/koin/test/core/instance/SandboxInstanceHolder;", "T", "Lorg/koin/core/instance/InstanceHolder;", "bean", "Lorg/koin/dsl/definition/BeanDefinition;", "(Lorg/koin/dsl/definition/BeanDefinition;)V", "getBean", "()Lorg/koin/dsl/definition/BeanDefinition;", "create", "parameters", "Lkotlin/Function0;", "Lorg/koin/core/parameter/ParameterList;", "Lorg/koin/core/parameter/ParameterDefinition;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "get", "Lorg/koin/core/instance/Instance;", "release", "", "koin-test"})
public final class SandboxInstanceHolder<T>
implements InstanceHolder<T> {
    @NotNull
    private final BeanDefinition<T> bean;

    @NotNull
    public <T> Instance<T> get(@NotNull Function0<ParameterList> parameters) {
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        return new Instance(this.create(parameters), true);
    }

    public <T> T create(@NotNull Function0<ParameterList> parameters) {
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        try {
            ParameterList parameterList = (ParameterList)parameters.invoke();
            this.getBean().getDefinition().invoke((Object)parameterList);
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof NoBeanDefFoundException || exception instanceof DependencyResolutionException || exception instanceof BeanInstanceCreationException) {
                throw (Throwable)new BrokenDefinitionException("Definition " + this.getBean() + " is broken due to error : " + e);
            }
            Koin.Companion.getLogger().err("sandbox ~ intercepted error : " + e);
        }
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)this.getBean().getClazz());
        return (T)Mockito.mock((Class)clazz);
    }

    public void release() {
    }

    @NotNull
    public BeanDefinition<T> getBean() {
        return this.bean;
    }

    public SandboxInstanceHolder(@NotNull BeanDefinition<? extends T> bean) {
        Intrinsics.checkParameterIsNotNull(bean, (String)"bean");
        this.bean = bean;
    }
}

