/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.error.NoScopeDefFoundException;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeDefinition;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0002J\r\u0010!\u001a\u00020 H\u0000\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020 H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020 H\u0000\u00a2\u0006\u0002\b&J&\u0010'\u001a\u00020\u00062\n\u0010(\u001a\u00060\u000fj\u0002`\u00132\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0001J&\u0010'\u001a\u00020\u00062\n\u0010(\u001a\u00060\u000fj\u0002`\u00132\u0006\u0010,\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0002J\u0014\u0010-\u001a\u00020\f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0012\u00100\u001a\u00020 2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/J(\u00101\u001a\u00020 2\u001e\u00102\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030/03j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/`4H\u0002J\u000e\u00105\u001a\u00020 2\u0006\u00106\u001a\u00020\u0006J\u0012\u00105\u001a\u00020 2\n\u0010(\u001a\u00060\u000fj\u0002`\u0013J\u0014\u00107\u001a\u0004\u0018\u00010\u00062\n\u0010(\u001a\u00060\u000fj\u0002`\u0013J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0002J\u001b\u0010;\u001a\u00020 2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=H\u0000\u00a2\u0006\u0002\b>J\u0006\u0010?\u001a\u00020@J\u0014\u0010A\u001a\u00020 2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=J\u000e\u0010A\u001a\u00020 2\u0006\u00109\u001a\u00020:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\f0\u000ej\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\f`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\b\u0012\u00060\u000fj\u0002`\u0013\u0012\u0004\u0012\u00020\u00060\u000ej\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0013\u0012\u0004\u0012\u00020\u0006`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\f0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0013\u0012\u0004\u0012\u00020\u00060\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006B"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_rootScope", "Lorg/koin/core/scope/Scope;", "get_rootScope$koin_core", "()Lorg/koin/core/scope/Scope;", "set_rootScope$koin_core", "(Lorg/koin/core/scope/Scope;)V", "_rootScopeDefinition", "Lorg/koin/core/scope/ScopeDefinition;", "_scopeDefinitions", "Ljava/util/HashMap;", "", "Lorg/koin/core/qualifier/QualifierValue;", "Lkotlin/collections/HashMap;", "_scopes", "Lorg/koin/core/scope/ScopeID;", "rootScope", "getRootScope", "rootScopeDefinition", "getRootScopeDefinition", "()Lorg/koin/core/scope/ScopeDefinition;", "scopeDefinitions", "", "getScopeDefinitions", "()Ljava/util/Map;", "scopes", "getScopes", "clearScopes", "", "close", "close$koin_core", "createRootScope", "createRootScope$koin_core", "createRootScopeDefinition", "createRootScopeDefinition$koin_core", "createScope", "scopeId", "qualifier", "Lorg/koin/core/qualifier/Qualifier;", "source", "scopeDefinition", "createScopeDefinition", "bean", "Lorg/koin/core/definition/BeanDefinition;", "declareDefinition", "declareDefinitions", "definitions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "deleteScope", "scope", "getScopeOrNull", "loadModule", "module", "Lorg/koin/core/module/Module;", "loadModules", "modules", "", "loadModules$koin_core", "size", "", "unloadModules", "koin-core"})
public final class ScopeRegistry {
    private final HashMap<String, ScopeDefinition> _scopeDefinitions;
    private final HashMap<String, Scope> _scopes;
    private ScopeDefinition _rootScopeDefinition;
    @Nullable
    private Scope _rootScope;
    private final Koin _koin;

    @NotNull
    public final Map<String, ScopeDefinition> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Map<String, Scope> getScopes() {
        return this._scopes;
    }

    @NotNull
    public final ScopeDefinition getRootScopeDefinition() {
        ScopeDefinition scopeDefinition = this._rootScopeDefinition;
        if (scopeDefinition == null) {
            String string = "No root scope definition";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return scopeDefinition;
    }

    @Nullable
    public final Scope get_rootScope$koin_core() {
        return this._rootScope;
    }

    public final void set_rootScope$koin_core(@Nullable Scope scope) {
        this._rootScope = scope;
    }

    @NotNull
    public final Scope getRootScope() {
        Scope scope = this._rootScope;
        if (scope == null) {
            String string = "No root scope";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return scope;
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void $this$mapTo$iv$iv;
        Collection<ScopeDefinition> collection = this._scopeDefinitions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopeDefinitions.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScopeDefinition scopeDefinition = (ScopeDefinition)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Integer n = it.size$koin_core();
            collection2.add(n);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    public final void loadModules$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module module = element$iv = iterator.next();
            boolean bl = false;
            if (!module.isLoaded()) {
                this.loadModule(module);
                continue;
            }
            this._koin.get_logger().error("module '" + module + "' already loaded!");
        }
    }

    private final void loadModule(Module module) {
        this.declareDefinitions(module.getDefinitions());
        module.setLoaded(true);
    }

    private final void declareDefinitions(HashSet<BeanDefinition<?>> definitions) {
        Iterable $this$forEach$iv = definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition bean = (BeanDefinition)element$iv;
            boolean bl = false;
            this.declareDefinition(bean);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void declareDefinition(@NotNull BeanDefinition<?> bean) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        ScopeDefinition scopeDefinition = this._scopeDefinitions.get(bean.getScopeQualifier().getValue());
        if (scopeDefinition == null) {
            scopeDefinition = this.createScopeDefinition(bean);
        }
        Intrinsics.checkNotNullExpressionValue((Object)scopeDefinition, (String)"_scopeDefinitions[bean.s\u2026eateScopeDefinition(bean)");
        ScopeDefinition scopeDef = scopeDefinition;
        ScopeDefinition.save$default(scopeDef, bean, false, 2, null);
        Collection<Scope> collection = this._scopes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Scope it = (Scope)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.get_scopeDefinition(), (Object)scopeDef)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope it = (Scope)element$iv;
            boolean bl = false;
            it.loadDefinition(bean);
        }
    }

    private final ScopeDefinition createScopeDefinition(BeanDefinition<?> bean) {
        ScopeDefinition def = new ScopeDefinition(bean.getScopeQualifier(), false, 2, null);
        ((Map)this._scopeDefinitions).put(bean.getScopeQualifier().getValue(), def);
        return def;
    }

    public final void createRootScopeDefinition$koin_core() {
        if (this._rootScopeDefinition != null) {
            String string = "Try to recreate Root scope definition";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ScopeDefinition scopeDefinition = ScopeDefinition.Companion.rootDefinition$koin_core();
        ((Map)this._scopeDefinitions).put(ScopeDefinition.Companion.getROOT_SCOPE_QUALIFIER().getValue(), scopeDefinition);
        this._rootScopeDefinition = scopeDefinition;
    }

    public final void createRootScope$koin_core() {
        if (this._rootScope != null) {
            String string = "Try to recreate Root scope";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this._rootScope = this.createScope("-Root-", ScopeDefinition.Companion.getROOT_SCOPE_QUALIFIER(), null);
    }

    @Nullable
    public final Scope getScopeOrNull(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        return this.getScopes().get(scopeId);
    }

    @NotNull
    public final Scope createScope(@NotNull String scopeId, @NotNull Qualifier qualifier, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        Map<String, Scope> map = this.getScopes();
        boolean bl = false;
        Map<String, Scope> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(scopeId)) {
            throw (Throwable)new ScopeAlreadyCreatedException("Scope with id '" + scopeId + "' is already created");
        }
        ScopeDefinition scopeDefinition = this._scopeDefinitions.get(qualifier.getValue());
        if (scopeDefinition == null) {
            throw (Throwable)new NoScopeDefFoundException("No Scope Definition found for qualifer '" + qualifier.getValue() + '\'');
        }
        Scope createdScope = this.createScope(scopeId, scopeDefinition, source);
        ((Map)this._scopes).put(scopeId, createdScope);
        return createdScope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    private final Scope createScope(String scopeId, ScopeDefinition scopeDefinition, Object source) {
        Object object;
        Scope scope;
        block3: {
            block2: {
                Scope scope2 = new Scope(scopeId, scopeDefinition, this._koin);
                boolean bl = false;
                boolean bl2 = false;
                Scope $this$apply = scope2;
                boolean bl3 = false;
                $this$apply.set_source(source);
                scope = scope2;
                object = this._rootScope;
                if (object == null) break block2;
                Scope scope3 = object;
                bl2 = false;
                boolean bl4 = false;
                Scope it = scope3;
                boolean bl5 = false;
                object = CollectionsKt.listOf((Object)it);
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object links = object;
        scope.create$koin_core((List<Scope>)links);
        return scope;
    }

    public final void deleteScope(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        this._scopes.remove(scopeId);
    }

    public final void deleteScope(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.clearScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
        this._rootScopeDefinition = null;
        this._rootScope = null;
    }

    private final void clearScopes() {
        Collection<Scope> collection = this._scopes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            scope.clear$koin_core();
        }
    }

    public final void unloadModules(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module it = element$iv = iterator.next();
            boolean bl = false;
            this.unloadModules(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unloadModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$forEach$iv = module.getDefinitions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            ScopeDefinition scopeDefinition;
            BeanDefinition bean = (BeanDefinition)element$iv;
            boolean bl = false;
            if (this._scopeDefinitions.get(bean.getScopeQualifier().getValue()) == null) {
                String string = "Can't find scope for definition " + bean;
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)scopeDefinition, (String)"_scopeDefinitions[bean.s\u2026pe for definition $bean\")");
            scopeDefinition.unloadDefinition(bean);
            Collection<Scope> collection = this._scopes.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Scope it = (Scope)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.get_scopeDefinition().getQualifier(), (Object)scopeDefinition.getQualifier())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv2 = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Scope it = (Scope)element$iv2;
                boolean bl4 = false;
                it.dropInstance(bean);
            }
        }
        module.setLoaded(false);
    }

    public ScopeRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._scopeDefinitions = new HashMap();
        this._scopes = new HashMap();
    }
}

