/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.error.NoScopeDefFoundException;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeDefinition;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010 \u001a\u00020!H\u0002J\r\u0010\"\u001a\u00020!H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020!H\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020!H\u0000\u00a2\u0006\u0002\b'J&\u0010(\u001a\u00020\u00062\n\u0010)\u001a\u00060\u0013j\u0002`\u00172\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0001J&\u0010(\u001a\u00020\u00062\n\u0010)\u001a\u00060\u0013j\u0002`\u00172\u0006\u0010-\u001a\u00020\f2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\fH\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010-\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010-\u001a\u00020\fH\u0002J\u0016\u00102\u001a\u00020!2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f04H\u0002J\u000e\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u0006J\u0012\u00105\u001a\u00020!2\n\u0010)\u001a\u00060\u0013j\u0002`\u0017J\u0014\u00107\u001a\u0004\u0018\u00010\u00062\n\u0010)\u001a\u00060\u0013j\u0002`\u0017J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0002J\u001b\u0010;\u001a\u00020!2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=H\u0000\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020!2\u0006\u0010/\u001a\u00020\fH\u0002J\u0006\u0010@\u001a\u00020AJ\u0010\u0010B\u001a\u00020!2\u0006\u0010-\u001a\u00020\fH\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u0010-\u001a\u00020\fH\u0002J\u0014\u0010D\u001a\u00020!2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=J\u000e\u0010D\u001a\u00020!2\u0006\u00109\u001a\u00020:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R2\u0010\u0011\u001a&\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\f0\u0012j\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\f`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\b\u0012\u00060\u0013j\u0002`\u0017\u0012\u0004\u0012\u00020\u00060\u0012j\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0017\u0012\u0004\u0012\u00020\u0006`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR!\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\f0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0017\u0012\u0004\u0012\u00020\u00060\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006E"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_rootScope", "Lorg/koin/core/scope/Scope;", "get_rootScope", "()Lorg/koin/core/scope/Scope;", "set_rootScope", "(Lorg/koin/core/scope/Scope;)V", "_rootScopeDefinition", "Lorg/koin/core/scope/ScopeDefinition;", "get_rootScopeDefinition", "()Lorg/koin/core/scope/ScopeDefinition;", "set_rootScopeDefinition", "(Lorg/koin/core/scope/ScopeDefinition;)V", "_scopeDefinitions", "Ljava/util/HashMap;", "", "Lorg/koin/core/qualifier/QualifierValue;", "Lkotlin/collections/HashMap;", "_scopes", "Lorg/koin/core/scope/ScopeID;", "rootScope", "getRootScope", "scopeDefinitions", "", "getScopeDefinitions", "()Ljava/util/Map;", "scopes", "getScopes", "clearScopes", "", "close", "close$koin_core", "createRootScope", "createRootScope$koin_core", "createRootScopeDefinition", "createRootScopeDefinition$koin_core", "createScope", "scopeId", "qualifier", "Lorg/koin/core/qualifier/Qualifier;", "source", "scopeDefinition", "declareDefinitions", "definition", "declareInstances", "declareScope", "declareScopes", "list", "", "deleteScope", "scope", "getScopeOrNull", "loadModule", "module", "Lorg/koin/core/module/Module;", "loadModules", "modules", "", "loadModules$koin_core", "mergeDefinitions", "size", "", "unloadDefinitions", "unloadInstances", "unloadModules", "koin-core"})
public final class ScopeRegistry {
    private final HashMap<String, ScopeDefinition> _scopeDefinitions;
    private final HashMap<String, Scope> _scopes;
    @Nullable
    private ScopeDefinition _rootScopeDefinition;
    @Nullable
    private Scope _rootScope;
    private final Koin _koin;

    @NotNull
    public final Map<String, ScopeDefinition> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Map<String, Scope> getScopes() {
        return this._scopes;
    }

    @Nullable
    public final ScopeDefinition get_rootScopeDefinition() {
        return this._rootScopeDefinition;
    }

    public final void set_rootScopeDefinition(@Nullable ScopeDefinition scopeDefinition) {
        this._rootScopeDefinition = scopeDefinition;
    }

    @Nullable
    public final Scope get_rootScope() {
        return this._rootScope;
    }

    public final void set_rootScope(@Nullable Scope scope) {
        this._rootScope = scope;
    }

    @NotNull
    public final Scope getRootScope() {
        Scope scope = this._rootScope;
        if (scope == null) {
            String string = "No root scoped initialized";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return scope;
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getScopeDefinitions().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScopeDefinition scopeDefinition = (ScopeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.size$koin_core();
            collection.add(n);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    public final void loadModules$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module module = element$iv = iterator.next();
            boolean bl = false;
            if (!module.isLoaded()) {
                this.loadModule(module);
                module.setLoaded$koin_core(true);
                continue;
            }
            this._koin.get_logger().error("module '" + module + "' already loaded!");
        }
    }

    private final void loadModule(Module module) {
        this.declareScope(module.getRootScope());
        this.declareScopes((List<ScopeDefinition>)module.getOtherScopes());
    }

    private final void declareScopes(List<ScopeDefinition> list) {
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeDefinition scopeDefinition = (ScopeDefinition)element$iv;
            boolean bl = false;
            this.declareScope(scopeDefinition);
        }
    }

    private final void declareScope(ScopeDefinition scopeDefinition) {
        this.declareDefinitions(scopeDefinition);
        this.declareInstances(scopeDefinition);
    }

    /*
     * WARNING - void declaration
     */
    private final void declareInstances(ScopeDefinition scopeDefinition) {
        void $this$filterTo$iv$iv;
        Collection<Scope> collection = this._scopes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Scope it = (Scope)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.get_scopeDefinition(), (Object)scopeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope it = (Scope)element$iv;
            boolean bl = false;
            it.loadDefinitions(scopeDefinition);
        }
    }

    private final void declareDefinitions(ScopeDefinition definition) {
        Map<String, ScopeDefinition> map = this.getScopeDefinitions();
        String string = definition.getQualifier().getValue();
        boolean bl = false;
        Map<String, ScopeDefinition> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(string)) {
            this.mergeDefinitions(definition);
        } else {
            ((Map)this._scopeDefinitions).put(definition.getQualifier().getValue(), definition.copy());
        }
    }

    private final void mergeDefinitions(ScopeDefinition definition) {
        ScopeDefinition scopeDefinition = this.getScopeDefinitions().get(definition.getQualifier().getValue());
        if (scopeDefinition == null) {
            String string = "Scope definition '" + definition + "' not found in " + this._scopeDefinitions;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ScopeDefinition existing = scopeDefinition;
        Iterable $this$forEach$iv = definition.getDefinitions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition it = (BeanDefinition)element$iv;
            boolean bl = false;
            ScopeDefinition.save$default(existing, it, false, 2, null);
        }
    }

    public final void createRootScopeDefinition$koin_core() {
        ScopeDefinition scopeDefinition = ScopeDefinition.Companion.rootDefinition();
        ((Map)this._scopeDefinitions).put(ScopeDefinition.Companion.getROOT_SCOPE_QUALIFIER().getValue(), scopeDefinition);
        this._rootScopeDefinition = scopeDefinition;
    }

    public final void createRootScope$koin_core() {
        if (this._rootScope == null) {
            this._rootScope = this.createScope("-Root-", ScopeDefinition.Companion.getROOT_SCOPE_QUALIFIER(), null);
        }
    }

    @Nullable
    public final Scope getScopeOrNull(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        return this.getScopes().get(scopeId);
    }

    @NotNull
    public final Scope createScope(@NotNull String scopeId, @NotNull Qualifier qualifier, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        Map<String, Scope> map = this.getScopes();
        boolean bl = false;
        Map<String, Scope> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(scopeId)) {
            throw (Throwable)new ScopeAlreadyCreatedException("Scope with id '" + scopeId + "' is already created");
        }
        ScopeDefinition scopeDefinition = this.getScopeDefinitions().get(qualifier.getValue());
        if (scopeDefinition == null) {
            throw (Throwable)new NoScopeDefFoundException("No Scope Definition found for qualifer '" + qualifier.getValue() + '\'');
        }
        Scope createdScope = this.createScope(scopeId, scopeDefinition, source);
        ((Map)this._scopes).put(scopeId, createdScope);
        return createdScope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    private final Scope createScope(String scopeId, ScopeDefinition scopeDefinition, Object source) {
        Object object;
        Scope scope;
        block3: {
            block2: {
                Scope scope2 = new Scope(scopeId, scopeDefinition, this._koin);
                boolean bl = false;
                boolean bl2 = false;
                Scope $this$apply = scope2;
                boolean bl3 = false;
                $this$apply.set_source(source);
                scope = scope2;
                object = this._rootScope;
                if (object == null) break block2;
                Scope scope3 = object;
                bl2 = false;
                boolean bl4 = false;
                Scope it = scope3;
                boolean bl5 = false;
                object = CollectionsKt.listOf((Object)it);
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object links = object;
        scope.create$koin_core((List<Scope>)links);
        return scope;
    }

    public final void deleteScope(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        this._scopes.remove(scopeId);
    }

    public final void deleteScope(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.clearScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
        this._rootScopeDefinition = null;
        this._rootScope = null;
    }

    private final void clearScopes() {
        Collection<Scope> collection = this._scopes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            scope.clear$koin_core();
        }
    }

    public final void unloadModules(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module it = element$iv = iterator.next();
            boolean bl = false;
            this.unloadModules(it);
        }
    }

    public final void unloadModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List scopeDefinitions = CollectionsKt.plus((Collection)module.getOtherScopes(), (Object)module.getRootScope());
        Iterable $this$forEach$iv = scopeDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeDefinition it = (ScopeDefinition)element$iv;
            boolean bl = false;
            this.unloadDefinitions(it);
        }
        module.setLoaded$koin_core(false);
    }

    private final void unloadDefinitions(ScopeDefinition scopeDefinition) {
        block2: {
            Object v1;
            block1: {
                this.unloadInstances(scopeDefinition);
                Collection<ScopeDefinition> collection = this._scopeDefinitions.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopeDefinitions.values");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ScopeDefinition it = (ScopeDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)scopeDefinition)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            ScopeDefinition scopeDefinition2 = v1;
            if (scopeDefinition2 == null) break block2;
            scopeDefinition2.unloadDefinitions(scopeDefinition);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void unloadInstances(ScopeDefinition scopeDefinition) {
        void $this$filterTo$iv$iv;
        Collection<Scope> collection = this._scopes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_scopes.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Scope it = (Scope)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.get_scopeDefinition(), (Object)scopeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope it = (Scope)element$iv;
            boolean bl = false;
            it.dropInstances(scopeDefinition);
        }
    }

    public ScopeRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._scopeDefinitions = new HashMap();
        this._scopes = new HashMap();
    }
}

