/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.context;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.context.KoinContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/koin/core/context/KoinContextHandler;", "", "()V", "_context", "Lorg/koin/core/context/KoinContext;", "get", "Lorg/koin/core/Koin;", "getContext", "getOrNull", "register", "", "koinContext", "start", "koinApplication", "Lorg/koin/core/KoinApplication;", "stop", "koin-core"})
public final class KoinContextHandler {
    private static KoinContext _context;
    public static final KoinContextHandler INSTANCE;

    private final KoinContext getContext() {
        KoinContext koinContext = _context;
        if (koinContext == null) {
            String string = "No Koin Context configured. Please use startKoin or koinApplication DSL. ";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return koinContext;
    }

    @NotNull
    public final Koin get() {
        return this.getContext().get();
    }

    @Nullable
    public final Koin getOrNull() {
        KoinContext koinContext = _context;
        return koinContext != null ? koinContext.getOrNull() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull KoinContext koinContext) {
        Intrinsics.checkNotNullParameter((Object)koinContext, (String)"koinContext");
        KoinContextHandler koinContextHandler = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (koinContextHandler) {
            boolean bl3 = false;
            if (_context != null) {
                String string = "A KoinContext is already started";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            _context = koinContext;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void start(@NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"koinApplication");
        this.getContext().setup(koinApplication);
    }

    public final void stop() {
        KoinContext koinContext = _context;
        if (koinContext != null) {
            koinContext.stop();
        }
        _context = null;
    }

    private KoinContextHandler() {
    }

    static {
        KoinContextHandler koinContextHandler;
        INSTANCE = koinContextHandler = new KoinContextHandler();
    }
}

