/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.ext.StringExtKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tJ\u001b\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0015J\u001a\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0019J)\u0010\u001a\u001a\u00020\u000b\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001b\u001a\u0002H\u000fH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/koin/core/registry/PropertyRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "get_koin", "()Lorg/koin/core/Koin;", "_values", "", "", "close", "", "deleteProperty", "key", "getProperty", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "loadEnvironmentProperties", "loadPropertiesFromFile", "fileName", "readDataFromFile", "Ljava/util/Properties;", "content", "saveProperties", "properties", "", "saveProperty", "value", "saveProperty$koin_core", "(Ljava/lang/String;Ljava/lang/Object;)V", "koin-core"})
public final class PropertyRegistry {
    private final Map<String, Object> _values;
    @NotNull
    private final Koin _koin;

    public final void saveProperties(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load " + properties.size() + " properties");
        }
        this._values.putAll(properties);
    }

    public final void saveProperties(@NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load " + properties.size() + " properties");
        }
        Map map = MapsKt.toMap((Map)properties);
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        }
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            PropertyRegistry propertyRegistry;
            String string;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Object object = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)object.getKey();
            object = $dstr$k$v;
            bl3 = false;
            String v = (String)object.getValue();
            if (StringExtKt.isInt(v)) {
                object = v;
                string = k;
                propertyRegistry = this;
                bl3 = false;
                int n = Integer.parseInt((String)object);
                propertyRegistry.saveProperty$koin_core(string, n);
                continue;
            }
            if (StringExtKt.isFloat(v)) {
                object = v;
                string = k;
                propertyRegistry = this;
                bl3 = false;
                float f = Float.parseFloat((String)object);
                propertyRegistry.saveProperty$koin_core(string, Float.valueOf(f));
                continue;
            }
            this.saveProperty$koin_core(k, StringExtKt.quoted(v));
        }
    }

    public final <T> void saveProperty$koin_core(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this._values.put(key, value);
    }

    public final void deleteProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this._values.remove(key);
    }

    @Nullable
    public final <T> T getProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this._values.get(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    public final void loadPropertiesFromFile(@NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load properties from " + fileName);
        }
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = new String(byArray, charset);
        } else {
            string = content = null;
        }
        if (content != null) {
            if (this._koin.get_logger().isAt(Level.INFO)) {
                this._koin.get_logger().info("loaded properties from file:'" + fileName + '\'');
            }
        } else {
            throw (Throwable)new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = this.readDataFromFile(content);
        this.saveProperties(properties);
    }

    private final Properties readDataFromFile(String content) {
        byte[] byArray;
        Properties properties = new Properties();
        String string = content;
        Properties properties2 = properties;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        properties2.load(byteArrayInputStream);
        return properties;
    }

    public final void loadEnvironmentProperties() {
        Properties sysProperties;
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load properties from environment");
        }
        Properties properties = sysProperties = System.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)properties, (String)"sysProperties");
        this.saveProperties(properties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"System.getenv()");
        Map<String, String> map2 = map;
        boolean bl = false;
        Properties properties2 = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties3 = properties2;
        boolean bl4 = false;
        properties3.putAll(map2);
        Properties sysEnvProperties = properties2;
        this.saveProperties(sysEnvProperties);
    }

    public final void close() {
        this._values.clear();
    }

    @NotNull
    public final Koin get_koin() {
        return this._koin;
    }

    public PropertyRegistry(@NotNull Koin _koin) {
        Intrinsics.checkParameterIsNotNull((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._values = new ConcurrentHashMap();
    }
}

