/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.ext.StringExtKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0010J\u001a\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0014J)\u0010\u0015\u001a\u00020\u0007\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u0002H\tH\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/koin/core/registry/PropertyRegistry;", "", "()V", "values", "", "", "close", "", "getProperty", "T", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "loadEnvironmentProperties", "loadPropertiesFromFile", "fileName", "readDataFromFile", "Ljava/util/Properties;", "content", "saveProperties", "properties", "", "saveProperty", "value", "saveProperty$koin_core", "(Ljava/lang/String;Ljava/lang/Object;)V", "koin-core"})
public final class PropertyRegistry {
    private final Map<String, Object> values = new ConcurrentHashMap();

    public final void saveProperties(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
            KoinApplication.Companion.getLogger().debug("load " + properties.size() + " properties");
        }
        this.values.putAll(properties);
    }

    public final void saveProperties(@NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
            KoinApplication.Companion.getLogger().debug("load " + properties.size() + " properties");
        }
        Map map = MapsKt.toMap((Map)properties);
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        }
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            PropertyRegistry propertyRegistry;
            String string;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Object object = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)object.getKey();
            object = $dstr$k$v;
            bl3 = false;
            String v = (String)object.getValue();
            if (StringExtKt.isInt(v)) {
                object = v;
                string = k;
                propertyRegistry = this;
                bl3 = false;
                int n = Integer.parseInt((String)object);
                propertyRegistry.saveProperty$koin_core(string, n);
                continue;
            }
            if (StringExtKt.isFloat(v)) {
                object = v;
                string = k;
                propertyRegistry = this;
                bl3 = false;
                float f = Float.parseFloat((String)object);
                propertyRegistry.saveProperty$koin_core(string, Float.valueOf(f));
                continue;
            }
            this.saveProperty$koin_core(k, StringExtKt.quoted(v));
        }
    }

    public final <T> void saveProperty$koin_core(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.values.put(key, value);
    }

    @Nullable
    public final <T> T getProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.values.get(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    public final void loadPropertiesFromFile(@NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
            KoinApplication.Companion.getLogger().debug("load properties from " + fileName);
        }
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = new String(byArray, charset);
        } else {
            string = content = null;
        }
        if (content != null) {
            if (KoinApplication.Companion.getLogger().isAt(Level.INFO)) {
                KoinApplication.Companion.getLogger().info("loaded properties from file:'" + fileName + '\'');
            }
        } else {
            throw (Throwable)new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = this.readDataFromFile(content);
        this.saveProperties(properties);
    }

    private final Properties readDataFromFile(String content) {
        byte[] byArray;
        Properties properties = new Properties();
        String string = content;
        Properties properties2 = properties;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        properties2.load(byteArrayInputStream);
        return properties;
    }

    public final void loadEnvironmentProperties() {
        Properties sysProperties;
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
            KoinApplication.Companion.getLogger().debug("load properties from environment");
        }
        Properties properties = sysProperties = System.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)properties, (String)"sysProperties");
        this.saveProperties(properties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"System.getenv()");
        Map<String, String> map2 = map;
        boolean bl = false;
        Properties properties2 = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties3 = properties2;
        boolean bl4 = false;
        properties3.putAll(map2);
        Properties sysEnvProperties = properties2;
        this.saveProperties(sysEnvProperties);
    }

    public final void close() {
        this.values.clear();
    }
}

