/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.error.NoScopeDefinitionFoundException;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.error.ScopeNotCreatedException;
import org.koin.core.logger.Level;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeDefinition;
import org.koin.dsl.ScopeSet;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\f2\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0013J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0005J\u0012\u0010\u001b\u001a\u00020\n2\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0013J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\n2\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0013J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eJ\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001b\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J\u001b\u0010+\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "()V", "definitions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/koin/core/scope/ScopeDefinition;", "getDefinitions$koin_core", "()Ljava/util/concurrent/ConcurrentHashMap;", "instances", "Lorg/koin/core/scope/Scope;", "close", "", "closeRelatedScopes", "originalSet", "createScopeInstance", "koin", "Lorg/koin/core/Koin;", "id", "Lorg/koin/core/scope/ScopeID;", "scopeName", "Lorg/koin/core/qualifier/Qualifier;", "declareScopes", "module", "Lorg/koin/core/module/Module;", "deleteScopeInstance", "getScopeDefinition", "getScopeInstance", "getScopeInstanceOrNull", "getScopeSets", "", "loadDefaultScopes", "loadScopes", "modules", "", "loadScopes$koin_core", "registerScopeInstance", "instance", "saveDefinition", "scopeSet", "Lorg/koin/dsl/ScopeSet;", "saveInstance", "unloadDefinition", "unloadScopedDefinitions", "unloadScopedDefinitions$koin_core", "unloadScopes", "koin-core"})
public final class ScopeRegistry {
    @NotNull
    private final ConcurrentHashMap<String, ScopeDefinition> definitions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Scope> instances = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, ScopeDefinition> getDefinitions$koin_core() {
        return this.definitions;
    }

    @NotNull
    public final Collection<ScopeDefinition> getScopeSets() {
        Collection<ScopeDefinition> collection = this.definitions.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"definitions.values");
        return collection;
    }

    public final void loadScopes$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module it = element$iv = iterator.next();
            boolean bl = false;
            this.declareScopes(it);
        }
    }

    public final void unloadScopedDefinitions$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module it = element$iv = iterator.next();
            boolean bl = false;
            this.unloadScopes(it);
        }
    }

    private final void unloadScopes(Module module) {
        Iterable $this$forEach$iv = module.getScopes$koin_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeSet it = (ScopeSet)element$iv;
            boolean bl = false;
            this.unloadDefinition(it);
        }
    }

    public final void loadDefaultScopes(@NotNull Koin koin) {
        Intrinsics.checkParameterIsNotNull((Object)koin, (String)"koin");
        this.saveInstance(koin.getRootScope());
    }

    private final void declareScopes(Module module) {
        Iterable $this$forEach$iv = module.getScopes$koin_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeSet it = (ScopeSet)element$iv;
            boolean bl = false;
            this.saveDefinition(it);
        }
    }

    private final void unloadDefinition(ScopeSet scopeSet) {
        block1: {
            String key = scopeSet.getQualifier().toString();
            ScopeDefinition scopeDefinition = this.definitions.get(key);
            if (scopeDefinition == null) break block1;
            ScopeDefinition scopeDefinition2 = scopeDefinition;
            boolean bl = false;
            boolean bl2 = false;
            ScopeDefinition scopeDefinition3 = scopeDefinition2;
            boolean bl3 = false;
            if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
                KoinApplication.Companion.getLogger().info("unbind scoped definitions: " + scopeSet.getDefinitions() + " from '" + scopeSet.getQualifier() + '\'');
            }
            ScopeDefinition scopeDefinition4 = scopeDefinition3;
            Intrinsics.checkExpressionValueIsNotNull((Object)scopeDefinition4, (String)"scopeDefinition");
            this.closeRelatedScopes(scopeDefinition4);
            scopeDefinition3.getDefinitions().removeAll((Collection)scopeSet.getDefinitions());
        }
    }

    private final void closeRelatedScopes(ScopeDefinition originalSet) {
        Collection<Scope> collection = this.instances.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"instances.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)scope.getScopeDefinition(), (Object)originalSet)) continue;
            scope.close();
        }
    }

    private final void saveDefinition(ScopeSet scopeSet) {
        ScopeDefinition foundScopeSet = this.definitions.get(scopeSet.getQualifier().toString());
        if (foundScopeSet == null) {
            ((Map)this.definitions).put(scopeSet.getQualifier().toString(), scopeSet.createDefinition());
        } else {
            foundScopeSet.getDefinitions().addAll((Collection)scopeSet.getDefinitions());
        }
    }

    @Nullable
    public final ScopeDefinition getScopeDefinition(@NotNull String scopeName) {
        Intrinsics.checkParameterIsNotNull((Object)scopeName, (String)"scopeName");
        return this.definitions.get(scopeName);
    }

    @NotNull
    public final Scope createScopeInstance(@NotNull Koin koin, @NotNull String id, @NotNull Qualifier scopeName) {
        Intrinsics.checkParameterIsNotNull((Object)koin, (String)"koin");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)scopeName, (String)"scopeName");
        ScopeDefinition scopeDefinition = this.definitions.get(scopeName.toString());
        if (scopeDefinition == null) {
            throw (Throwable)new NoScopeDefinitionFoundException("No scope definition found for scopeName '" + scopeName + '\'');
        }
        ScopeDefinition definition2 = scopeDefinition;
        Scope instance = new Scope(id, false, koin, 2, null);
        instance.setScopeDefinition(definition2);
        instance.declareDefinitionsFromScopeSet$koin_core();
        this.registerScopeInstance(instance);
        return instance;
    }

    private final void registerScopeInstance(Scope instance) {
        if (this.instances.get(instance.getId()) != null) {
            throw (Throwable)new ScopeAlreadyCreatedException("A scope with id '" + instance.getId() + "' already exists. Reuse or close it.");
        }
        this.saveInstance(instance);
    }

    @NotNull
    public final Scope getScopeInstance(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope scope = this.instances.get(id);
        if (scope == null) {
            throw (Throwable)new ScopeNotCreatedException("ScopeInstance with id '" + id + "' not found. Create a scope instance with id '" + id + '\'');
        }
        return scope;
    }

    private final void saveInstance(Scope instance) {
        ((Map)this.instances).put(instance.getId(), instance);
    }

    @Nullable
    public final Scope getScopeInstanceOrNull(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.instances.get(id);
    }

    public final void deleteScopeInstance(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.instances.remove(id);
    }

    public final void close() {
        Collection<Scope> collection = this.instances.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"instances.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope it = (Scope)element$iv;
            boolean bl = false;
            it.close();
        }
        this.definitions.clear();
        this.instances.clear();
    }
}

