/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.error.NoScopeDefinitionFoundException;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.error.ScopeNotCreatedException;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeSet;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\u0005j\u0002`\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\n2\n\u0010\f\u001a\u00060\u0005j\u0002`\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0005J\u0012\u0010\u0015\u001a\u00020\b2\n\u0010\f\u001a\u00060\u0005j\u0002`\rJ\u0014\u0010\u0016\u001a\u0004\u0018\u00010\b2\n\u0010\f\u001a\u00060\u0005j\u0002`\rJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u001b\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "()V", "definitions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/koin/core/scope/ScopeSet;", "instances", "Lorg/koin/core/scope/Scope;", "close", "", "createScopeInstance", "id", "Lorg/koin/core/scope/ScopeID;", "scopeName", "Lorg/koin/core/qualifier/Qualifier;", "declareScopes", "module", "Lorg/koin/core/module/Module;", "deleteScopeInstance", "getScopeDefinition", "getScopeInstance", "getScopeInstanceOrNull", "loadDefaultScopes", "koin", "Lorg/koin/core/Koin;", "loadScopes", "modules", "", "loadScopes$koin_core", "registerScopeInstance", "instance", "saveDefinition", "scopeSet", "saveInstance", "koin-core"})
public final class ScopeRegistry {
    private final ConcurrentHashMap<String, ScopeSet> definitions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Scope> instances = new ConcurrentHashMap();

    public final void loadScopes$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Iterable<Module> $receiver$iv = modules2;
        Iterator<Module> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module it = element$iv = iterator.next();
            boolean bl = false;
            this.declareScopes(it);
        }
    }

    public final void loadDefaultScopes(@NotNull Koin koin) {
        Intrinsics.checkParameterIsNotNull((Object)koin, (String)"koin");
        Scope.Companion.getGLOBAL().register(koin);
        this.saveInstance(Scope.Companion.getGLOBAL());
    }

    private final void declareScopes(Module module) {
        Iterable $receiver$iv = module.getScopes$koin_core();
        for (Object element$iv : $receiver$iv) {
            ScopeSet it = (ScopeSet)element$iv;
            boolean bl = false;
            this.saveDefinition(it);
        }
    }

    private final void saveDefinition(ScopeSet scopeSet) {
        ScopeSet foundScopeSet = this.definitions.get(scopeSet.getQualifier().toString());
        if (foundScopeSet == null) {
            Map map = this.definitions;
            String string = scopeSet.getQualifier().toString();
            ScopeSet scopeSet2 = scopeSet;
            map.put(string, scopeSet2);
        } else {
            foundScopeSet.getDefinitions().addAll((Collection)scopeSet.getDefinitions());
        }
    }

    @Nullable
    public final ScopeSet getScopeDefinition(@NotNull String scopeName) {
        Intrinsics.checkParameterIsNotNull((Object)scopeName, (String)"scopeName");
        return this.definitions.get(scopeName);
    }

    @NotNull
    public final Scope createScopeInstance(@NotNull String id, @Nullable Qualifier scopeName) {
        ScopeSet scopeSet;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Qualifier qualifier = scopeName;
        if (qualifier != null) {
            Qualifier qualifier2;
            Qualifier it = qualifier2 = qualifier;
            boolean bl = false;
            scopeSet = this.definitions.get(scopeName.toString());
            if (scopeSet == null) {
                throw (Throwable)new NoScopeDefinitionFoundException("No scope definition found for scopeName '" + scopeName + '\'');
            }
        } else {
            scopeSet = null;
        }
        ScopeSet definition = scopeSet;
        Scope instance = new Scope(id);
        ScopeSet scopeSet2 = definition;
        if (scopeSet2 != null) {
            ScopeSet scopeSet3;
            ScopeSet it = scopeSet3 = scopeSet2;
            boolean bl = false;
            instance.setSet(it);
        }
        this.registerScopeInstance(instance);
        return instance;
    }

    @NotNull
    public static /* synthetic */ Scope createScopeInstance$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, int n, Object object) {
        if ((n & 2) != 0) {
            qualifier = null;
        }
        return scopeRegistry.createScopeInstance(string, qualifier);
    }

    private final void registerScopeInstance(Scope instance) {
        if (this.instances.get(instance.getId()) != null) {
            throw (Throwable)new ScopeAlreadyCreatedException("A scope with id '" + instance.getId() + "' already exists. Reuse or close it.");
        }
        this.saveInstance(instance);
    }

    @NotNull
    public final Scope getScopeInstance(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope scope = this.instances.get(id);
        if (scope == null) {
            throw (Throwable)new ScopeNotCreatedException("ScopeInstance with id '" + id + "' not found. Create a scope instance with id '" + id + '\'');
        }
        return scope;
    }

    private final void saveInstance(Scope instance) {
        Map map = this.instances;
        String string = instance.getId();
        Scope scope = instance;
        map.put(string, scope);
    }

    @Nullable
    public final Scope getScopeInstanceOrNull(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.instances.get(id);
    }

    public final void deleteScopeInstance(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.instances.remove(id);
    }

    public final void close() {
        this.definitions.clear();
        Collection<Scope> collection = this.instances.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"instances.values");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            Scope it = (Scope)element$iv;
            boolean bl = false;
            it.close();
        }
        this.instances.clear();
    }
}

