/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.instance;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.KoinApplication;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.error.BadScopeInstanceException;
import org.koin.core.error.ScopeNotCreatedException;
import org.koin.core.instance.DefinitionInstance;
import org.koin.core.instance.InstanceContext;
import org.koin.core.logger.Level;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeExtKt;
import org.koin.core.scope.ScopeSet;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0016J\u001b\u0010\u000f\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/koin/core/instance/ScopeDefinitionInstance;", "T", "Lorg/koin/core/instance/DefinitionInstance;", "beanDefinition", "Lorg/koin/core/definition/BeanDefinition;", "(Lorg/koin/core/definition/BeanDefinition;)V", "values", "", "", "checkScopeResolution", "", "definition", "scope", "Lorg/koin/core/scope/Scope;", "close", "get", "context", "Lorg/koin/core/instance/InstanceContext;", "(Lorg/koin/core/instance/InstanceContext;)Ljava/lang/Object;", "isCreated", "", "release", "koin-core"})
public final class ScopeDefinitionInstance<T>
extends DefinitionInstance<T> {
    private final Map<String, T> values;

    @Override
    public boolean isCreated(@NotNull InstanceContext context) {
        Scope scope;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scope it = scope = context.getScope();
        boolean bl = false;
        return this.values.get(context.getScope().getId()) != null;
    }

    @Override
    public void release(@NotNull InstanceContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
            KoinApplication.Companion.getLogger().debug("releasing '" + scope + "' ~ " + this.getBeanDefinition() + ' ');
        }
        Function1 function1 = this.getBeanDefinition().getOnRelease();
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(this.values.get(scope.getId()));
        }
        this.values.remove(scope.getId());
    }

    @Override
    public <T> T get(@NotNull InstanceContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)context.getScope(), (Object)Scope.Companion.getGLOBAL())) {
            throw (Throwable)new ScopeNotCreatedException("No scope instance created to resolve " + this.getBeanDefinition());
        }
        Scope scope = context.getScope();
        this.checkScopeResolution(this.getBeanDefinition(), scope);
        String internalId = scope.getId();
        T current = this.values.get(internalId);
        if (current == null) {
            current = this.create(context);
            Map<String, T> map = this.values;
            T t = current;
            if (t == null) {
                String string = "Instance creation from " + this.getBeanDefinition() + " should not be null";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            T t2 = t;
            map.put(internalId, t2);
        }
        return current;
    }

    @Override
    public void close() {
        Function1 function1 = this.getBeanDefinition().getOnClose();
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(null);
        }
        this.values.clear();
    }

    private final void checkScopeResolution(BeanDefinition<?> definition, Scope scope) {
        ScopeSet scopeSet = scope.getSet();
        Qualifier scopeInstanceName = scopeSet != null ? scopeSet.getQualifier() : null;
        Qualifier beanScopeName = ScopeExtKt.getScopeName(definition);
        if (Intrinsics.areEqual((Object)beanScopeName, (Object)scopeInstanceName) ^ true) {
            if (scopeInstanceName == null) {
                throw (Throwable)new BadScopeInstanceException("Can't use definition " + definition + " defined for scope '" + beanScopeName + "', with an open scope instance " + scope + ". Use a scope instance with scope '" + beanScopeName + '\'');
            }
            if (beanScopeName != null) {
                throw (Throwable)new BadScopeInstanceException("Can't use definition " + definition + " defined for scope '" + beanScopeName + "' with scope instance " + scope + ". Use a scope instance with scope '" + beanScopeName + "'.");
            }
        }
    }

    public ScopeDefinitionInstance(@NotNull BeanDefinition<T> beanDefinition) {
        Intrinsics.checkParameterIsNotNull(beanDefinition, (String)"beanDefinition");
        super(beanDefinition);
        this.values = new ConcurrentHashMap();
    }
}

