/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.bean.BeanDefinition;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.error.ScopeNotCreatedException;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeExtKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "()V", "allScopes", "Ljava/util/HashSet;", "Lorg/koin/core/scope/Scope;", "Lkotlin/collections/HashSet;", "registeredScopes", "", "", "close", "", "createNewScope", "scopeId", "createScope", "deleteScope", "scope", "deleteScope$koin_core", "detachScope", "getOrCreateScope", "getScopeById", "getScopeByInternalId", "internalId", "isNotAlreadyRegistered", "", "prepareScope", "definition", "Lorg/koin/core/bean/BeanDefinition;", "registerScope", "koin-core"})
public final class ScopeRegistry {
    private final HashSet<Scope> allScopes;
    private final Map<String, Scope> registeredScopes;

    @NotNull
    public final Scope getOrCreateScope(@NotNull String scopeId) {
        Intrinsics.checkParameterIsNotNull((Object)scopeId, (String)"scopeId");
        Scope scope = this.getScopeById(scopeId);
        if (scope == null) {
            scope = this.createScope(scopeId);
        }
        return scope;
    }

    @NotNull
    public final Scope createScope(@NotNull String scopeId) {
        Intrinsics.checkParameterIsNotNull((Object)scopeId, (String)"scopeId");
        if (!this.isNotAlreadyRegistered(scopeId)) {
            throw (Throwable)new ScopeAlreadyCreatedException("Try to create scope '" + scopeId + "' but is alreadyCreated");
        }
        Scope scope = this.createNewScope(scopeId);
        return this.registerScope(scopeId, scope);
    }

    private final Scope registerScope(String scopeId, Scope scope) {
        Map<String, Scope> map = this.registeredScopes;
        Scope scope2 = scope;
        map.put(scopeId, scope2);
        return scope;
    }

    @NotNull
    public final Scope detachScope(@NotNull String scopeId) {
        Intrinsics.checkParameterIsNotNull((Object)scopeId, (String)"scopeId");
        return this.createNewScope(scopeId);
    }

    @Nullable
    public final Scope getScopeByInternalId(@NotNull String internalId) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)internalId, (String)"internalId");
            Iterable $receiver$iv = this.allScopes;
            for (Object element$iv : $receiver$iv) {
                Scope it = (Scope)element$iv;
                if (!Intrinsics.areEqual((Object)it.getInternalId$koin_core(), (Object)internalId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Scope createNewScope(String scopeId) {
        Scope newScope = new Scope(scopeId, null, 2, null);
        this.allScopes.add(newScope);
        return newScope;
    }

    private final boolean isNotAlreadyRegistered(String scopeId) {
        return this.registeredScopes.get(scopeId) == null;
    }

    @Nullable
    public final Scope getScopeById(@NotNull String scopeId) {
        Intrinsics.checkParameterIsNotNull((Object)scopeId, (String)"scopeId");
        return this.registeredScopes.get(scopeId);
    }

    public final void deleteScope$koin_core(@NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.allScopes.remove(scope);
        if (Intrinsics.areEqual((Object)this.registeredScopes.get(scope.getId()), (Object)scope)) {
            this.registeredScopes.remove(scope.getId());
        }
    }

    @Nullable
    public final Scope prepareScope(@NotNull BeanDefinition<?> definition, @Nullable Scope scope) {
        Scope scope2;
        Intrinsics.checkParameterIsNotNull(definition, (String)"definition");
        if (definition.isScoped()) {
            if (scope == null) {
                String string = ScopeExtKt.getScopeId(definition);
                if (string == null) {
                    String string2 = "No scope id for " + definition;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                String scopeId = string;
                scope2 = this.getScopeById(scopeId);
                if (scope2 == null) {
                    throw (Throwable)new ScopeNotCreatedException("Scope '" + scopeId + "' is not created while trying to use scoped definition: " + definition);
                }
            } else {
                scope2 = scope;
            }
        } else {
            scope2 = null;
        }
        return scope2;
    }

    @Nullable
    public static /* synthetic */ Scope prepareScope$default(ScopeRegistry scopeRegistry, BeanDefinition beanDefinition, Scope scope, int n, Object object) {
        if ((n & 2) != 0) {
            scope = null;
        }
        return scopeRegistry.prepareScope(beanDefinition, scope);
    }

    public final void close() {
        this.allScopes.clear();
        this.registeredScopes.clear();
    }

    public ScopeRegistry() {
        ScopeRegistry scopeRegistry = this;
        HashSet hashSet = new HashSet();
        scopeRegistry.allScopes = hashSet;
        this.registeredScopes = new ConcurrentHashMap();
    }
}

