/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.instance;

import java.util.Collection;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.KoinApplication;
import org.koin.core.bean.BeanDefinition;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.scope.Scope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J\u0016\u0010\t\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J\u0006\u0010\n\u001a\u00020\u0007J?\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J\u0016\u0010\u0015\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J=\u0010\u0016\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012\u00a2\u0006\u0002\u0010\u0013R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/koin/core/instance/InstanceResolver;", "", "()V", "callStack", "Ljava/util/Stack;", "Lorg/koin/core/bean/BeanDefinition;", "checkForCycle", "", "definition", "cleanCallStack", "close", "getInstance", "T", "scope", "Lorg/koin/core/scope/Scope;", "parameters", "Lkotlin/Function0;", "Lorg/koin/core/parameter/ParametersHolder;", "Lorg/koin/core/parameter/ParametersDefinition;", "(Lorg/koin/core/bean/BeanDefinition;Lorg/koin/core/scope/Scope;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lastInStack", "prepareCallStack", "resolveInstance", "koin-core"})
public final class InstanceResolver {
    private final Stack<BeanDefinition<?>> callStack = new Stack();

    public final <T> T resolveInstance(@NotNull BeanDefinition<?> definition, @Nullable Scope scope, @Nullable Function0<ParametersHolder> parameters) {
        Intrinsics.checkParameterIsNotNull(definition, (String)"definition");
        this.checkForCycle(definition);
        this.prepareCallStack(definition);
        T instance = this.getInstance(definition, scope, parameters);
        this.cleanCallStack(definition);
        return instance;
    }

    private final void prepareCallStack(BeanDefinition<?> definition) {
        this.callStack.add(definition);
    }

    private final <T> T getInstance(BeanDefinition<?> definition, Scope scope, Function0<ParametersHolder> parameters) {
        return (T)definition.getInstance().get(scope, parameters);
    }

    private final BeanDefinition<?> lastInStack() {
        Collection collection = this.callStack;
        return !collection.isEmpty() ? this.callStack.pop() : null;
    }

    private final void cleanCallStack(BeanDefinition<?> definition) {
        BeanDefinition<?> pop = this.lastInStack();
        if (Intrinsics.areEqual(pop, definition) ^ true) {
            KoinApplication.Companion.getLogger().error("call stack is inconsistent: return with " + pop + " & should be " + definition);
            String string = "CallStack integrity error while resolving " + definition;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void checkForCycle(BeanDefinition<?> definition) {
        boolean bl;
        block4: {
            Iterable $receiver$iv = this.callStack;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    BeanDefinition it = (BeanDefinition)element$iv;
                    if (!Intrinsics.areEqual((Object)it, definition)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            BeanDefinition<?> pop = this.lastInStack();
            KoinApplication.Companion.getLogger().error("cycle dependency detected for " + definition + " & " + pop);
            String string = "CallStack cycle detected for " + definition + " & " + pop;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public final void close() {
        this.callStack.clear();
    }
}

