/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.KoinAppAlreadyStartedException;
import org.koin.core.logger.EmptyLogger;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.logger.PrintLogger;
import org.koin.core.module.Module;
import org.koin.core.standalone.StandAloneKoinApplication;
import org.koin.core.time.MeasureKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\u0000J\u0010\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0016J\u001c\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/koin/core/KoinApplication;", "", "()V", "koin", "Lorg/koin/core/Koin;", "getKoin", "()Lorg/koin/core/Koin;", "createEagerInstances", "loadEnvironmentProperties", "loadFileProperties", "fileName", "", "loadModules", "modules", "", "Lorg/koin/core/module/Module;", "([Lorg/koin/core/module/Module;)Lorg/koin/core/KoinApplication;", "", "loadProperties", "values", "", "saveStandAloneAppInstance", "", "start", "stop", "useLogger", "level", "Lorg/koin/core/logger/Level;", "logger", "Lorg/koin/core/logger/Logger;", "Companion", "koin-core"})
public final class KoinApplication {
    @NotNull
    private final Koin koin = new Koin();
    @NotNull
    private static Logger logger;
    public static final Companion Companion;

    @NotNull
    public final Koin getKoin() {
        return this.koin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KoinApplication start() {
        KoinApplication koinApplication = this;
        synchronized (koinApplication) {
            this.saveStandAloneAppInstance();
            this.createEagerInstances();
            logger.info("started");
            KoinApplication koinApplication2 = this;
            return koinApplication2;
        }
    }

    @NotNull
    public final KoinApplication loadModules(Module ... modules) {
        Intrinsics.checkParameterIsNotNull((Object)modules, (String)"modules");
        double duration2 = MeasureKt.measureDurationOnly((Function0<Unit>)((Function0)new Function0<Unit>(this, modules){
            final /* synthetic */ KoinApplication this$0;
            final /* synthetic */ Module[] $modules;

            public final void invoke() {
                this.this$0.getKoin().getBeanRegistry().loadModules(this.this$0.getKoin(), Arrays.copyOf(this.$modules, this.$modules.length));
            }
            {
                this.this$0 = koinApplication;
                this.$modules = moduleArray;
                super(0);
            }
        }));
        logger.info("modules loaded in " + duration2 + " ms");
        return this;
    }

    @NotNull
    public final KoinApplication loadModules(@NotNull List<Module> modules) {
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        double duration2 = MeasureKt.measureDurationOnly((Function0<Unit>)((Function0)new Function0<Unit>(this, modules){
            final /* synthetic */ KoinApplication this$0;
            final /* synthetic */ List $modules;

            public final void invoke() {
                this.this$0.getKoin().getBeanRegistry().loadModules(this.this$0.getKoin(), this.$modules);
            }
            {
                this.this$0 = koinApplication;
                this.$modules = list;
                super(0);
            }
        }));
        logger.info("modules loaded in " + duration2 + " ms");
        return this;
    }

    @NotNull
    public final KoinApplication loadProperties(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        this.koin.getPropertyRegistry().saveProperties(values);
        return this;
    }

    @NotNull
    public final KoinApplication loadFileProperties(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.koin.getPropertyRegistry().loadPropertiesFromFile(fileName);
        return this;
    }

    @NotNull
    public static /* synthetic */ KoinApplication loadFileProperties$default(KoinApplication koinApplication, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/koin.properties";
        }
        return koinApplication.loadFileProperties(string);
    }

    @NotNull
    public final KoinApplication loadEnvironmentProperties() {
        this.koin.getPropertyRegistry().loadEnvironmentProperties();
        return this;
    }

    @JvmOverloads
    @NotNull
    public final KoinApplication useLogger(@NotNull Level level, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        KoinApplication.logger = logger;
        KoinApplication.logger.setLevel(level);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ KoinApplication useLogger$default(KoinApplication koinApplication, Level level, Logger logger, int n, Object object) {
        if ((n & 1) != 0) {
            level = Level.INFO;
        }
        if ((n & 2) != 0) {
            logger = new PrintLogger(null, 1, null);
        }
        return koinApplication.useLogger(level, logger);
    }

    @JvmOverloads
    @NotNull
    public final KoinApplication useLogger(@NotNull Level level) {
        return KoinApplication.useLogger$default(this, level, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final KoinApplication useLogger() {
        return KoinApplication.useLogger$default(this, null, null, 3, null);
    }

    @NotNull
    public final KoinApplication createEagerInstances() {
        double duration2 = MeasureKt.measureDurationOnly((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ KoinApplication this$0;

            public final void invoke() {
                this.this$0.getKoin().createEagerInstances$koin_core();
            }
            {
                this.this$0 = koinApplication;
                super(0);
            }
        }));
        logger.debug("instances started in " + duration2 + " ms");
        return this;
    }

    private final void saveStandAloneAppInstance() {
        if (StandAloneKoinApplication.INSTANCE.getApp$koin_core() != null) {
            throw (Throwable)new KoinAppAlreadyStartedException("KoinApplication is already started");
        }
        StandAloneKoinApplication.INSTANCE.setApp$koin_core(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        KoinApplication koinApplication = this;
        synchronized (koinApplication) {
            this.koin.close();
            StandAloneKoinApplication.INSTANCE.setApp$koin_core(null);
            logger.info("stopped");
            Unit unit = Unit.INSTANCE;
        }
    }

    private KoinApplication() {
    }

    static {
        Companion = new Companion(null);
        logger = new EmptyLogger();
    }

    public /* synthetic */ KoinApplication(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final KoinApplication create() {
        return Companion.create();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/koin/core/KoinApplication$Companion;", "", "()V", "logger", "Lorg/koin/core/logger/Logger;", "getLogger", "()Lorg/koin/core/logger/Logger;", "setLogger", "(Lorg/koin/core/logger/Logger;)V", "create", "Lorg/koin/core/KoinApplication;", "koin-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final void setLogger(@NotNull Logger logger) {
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"<set-?>");
            KoinApplication.logger = logger;
        }

        @JvmStatic
        @NotNull
        public final KoinApplication create() {
            return new KoinApplication(null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

