/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.KoinApplication;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.definition.Kind;
import org.koin.core.error.DefinitionOverrideException;
import org.koin.core.error.NoBeanDefFoundException;
import org.koin.core.instance.DefinitionInstance;
import org.koin.core.logger.Level;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.ext.KClassExtKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\rj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0017\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0015H\u0000\u00a2\u0006\u0002\b\u0016J$\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0016\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0015J\u0018\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u001c\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050#2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0014\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0014\u0010(\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010*\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u0010+\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0014\u0010,\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010-\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020'H\u0002J\u0012\u00100\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0014\u00101\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u00102\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0014\u00103\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u00104\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u00105\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u00106\u001a\u00020\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u00107\u001a\u00020\u00112\u0006\u0010/\u001a\u00020'H\u0002J\u0006\u00108\u001a\u000209J\u001b\u0010:\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0000\u00a2\u0006\u0002\b;J0\u0010<\u001a\u00020\u0011*\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u00062\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R&\u0010\u0003\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\rj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/koin/core/registry/BeanRegistry;", "", "()V", "definitions", "Ljava/util/HashSet;", "Lorg/koin/core/definition/BeanDefinition;", "Lkotlin/collections/HashSet;", "definitionsNames", "", "", "definitionsPrimaryTypes", "Lkotlin/reflect/KClass;", "definitionsSecondaryTypes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "definitionsToCreate", "close", "", "createSecondaryType", "type", "findAllCreatedAtStartDefinition", "", "findAllCreatedAtStartDefinition$koin_core", "findDefinition", "qualifier", "Lorg/koin/core/qualifier/Qualifier;", "clazz", "findDefinitionByName", "name", "findDefinitionBySecondaryType", "kClass", "findDefinitionByType", "getAllDefinitions", "getDefinition", "getDefinitionsForClass", "", "loadModules", "modules", "", "Lorg/koin/core/module/Module;", "removeDefinition", "definition", "removeDefinitionForName", "removeDefinitionForSecondaryType", "removeDefinitionForSecondaryTypes", "removeDefinitionForTypes", "removeDefinitions", "module", "saveDefinition", "saveDefinitionForName", "saveDefinitionForSecondaryType", "saveDefinitionForSecondaryTypes", "saveDefinitionForStart", "saveDefinitionForType", "saveDefinitionForTypes", "saveDefinitions", "size", "", "unloadModules", "unloadModules$koin_core", "addDefinition", "koin-core"})
public final class BeanRegistry {
    private final HashSet<BeanDefinition<?>> definitions;
    private final Map<String, BeanDefinition<?>> definitionsNames;
    private final Map<KClass<?>, BeanDefinition<?>> definitionsPrimaryTypes;
    private final Map<KClass<?>, ArrayList<BeanDefinition<?>>> definitionsSecondaryTypes;
    private final HashSet<BeanDefinition<?>> definitionsToCreate;

    public final void loadModules(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module module = element$iv = iterator.next();
            boolean bl = false;
            this.saveDefinitions(module);
        }
    }

    public final void unloadModules$koin_core(@NotNull Iterable<Module> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Iterable<Module> $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        Iterator<Module> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Module element$iv;
            Module module = element$iv = iterator.next();
            boolean bl = false;
            this.removeDefinitions(module);
        }
    }

    private final void removeDefinitions(Module module) {
        Iterable $this$forEach$iv = module.getDefinitions$koin_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition definition = (BeanDefinition)element$iv;
            boolean bl = false;
            this.removeDefinition(definition);
        }
    }

    private final void saveDefinitions(Module module) {
        Iterable $this$forEach$iv = module.getDefinitions$koin_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition definition = (BeanDefinition)element$iv;
            boolean bl = false;
            this.saveDefinition(definition);
        }
    }

    @NotNull
    public final Set<BeanDefinition<?>> getAllDefinitions() {
        return this.definitions;
    }

    private final void removeDefinition(BeanDefinition<?> definition) {
        DefinitionInstance<?> definitionInstance = definition.getInstance();
        if (definitionInstance != null) {
            definitionInstance.close();
        }
        this.definitions.remove(definition);
        if (definition.getQualifier() != null) {
            this.removeDefinitionForName(definition);
        } else {
            this.removeDefinitionForTypes(definition);
        }
        this.removeDefinitionForSecondaryTypes(definition);
    }

    public final void saveDefinition(@NotNull BeanDefinition<?> definition) {
        Intrinsics.checkParameterIsNotNull(definition, (String)"definition");
        this.addDefinition(this.definitions, definition);
        definition.createInstanceHolder();
        if (definition.getQualifier() != null) {
            this.saveDefinitionForName(definition);
        } else {
            this.saveDefinitionForTypes(definition);
        }
        Collection collection = definition.getSecondaryTypes();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.saveDefinitionForSecondaryTypes(definition);
        }
        if (definition.getOptions().isCreatedAtStart()) {
            this.saveDefinitionForStart(definition);
        }
    }

    private final void saveDefinitionForSecondaryTypes(BeanDefinition<?> definition) {
        Iterable $this$forEach$iv = definition.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl = false;
            this.saveDefinitionForSecondaryType(definition, it);
        }
    }

    private final void saveDefinitionForSecondaryType(BeanDefinition<?> definition, KClass<?> type) {
        ArrayList<BeanDefinition<?>> arrayList = this.definitionsSecondaryTypes.get(type);
        if (arrayList == null) {
            arrayList = this.createSecondaryType(type);
        }
        ArrayList<BeanDefinition<?>> secondaryTypeDefinitions = arrayList;
        secondaryTypeDefinitions.add(definition);
        if (KoinApplication.Companion.getLogger().isAt(Level.INFO)) {
            KoinApplication.Companion.getLogger().info("bind secondary type:'" + KClassExtKt.getFullName(type) + "' ~ " + definition);
        }
    }

    private final ArrayList<BeanDefinition<?>> createSecondaryType(KClass<?> type) {
        KClass<?> kClass = type;
        Map<KClass<?>, ArrayList<BeanDefinition<?>>> map = this.definitionsSecondaryTypes;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        map.put(kClass, arrayList);
        ArrayList<BeanDefinition<?>> arrayList2 = this.definitionsSecondaryTypes.get(type);
        if (arrayList2 == null) {
            Intrinsics.throwNpe();
        }
        return arrayList2;
    }

    private final void saveDefinitionForStart(BeanDefinition<?> definition) {
        this.definitionsToCreate.add(definition);
    }

    private final void addDefinition(@NotNull HashSet<BeanDefinition<?>> $this$addDefinition, BeanDefinition<?> definition) {
        boolean added = $this$addDefinition.add(definition);
        if (!added && !definition.getOptions().getOverride()) {
            throw (Throwable)new DefinitionOverrideException("Already existing definition or try to override an existing one: " + definition);
        }
    }

    private final void saveDefinitionForTypes(BeanDefinition<?> definition) {
        this.saveDefinitionForType(definition.getPrimaryType(), definition);
    }

    private final void removeDefinitionForSecondaryTypes(BeanDefinition<?> definition) {
        Iterable $this$forEach$iv = definition.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl = false;
            this.removeDefinitionForSecondaryType(definition, it);
        }
    }

    private final void removeDefinitionForSecondaryType(BeanDefinition<?> definition, KClass<?> type) {
        boolean removed;
        ArrayList<BeanDefinition<?>> arrayList = this.definitionsSecondaryTypes.get(type);
        boolean bl = removed = arrayList != null ? arrayList.remove(definition) : false;
        if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG) && removed) {
            KoinApplication.Companion.getLogger().info("unbind secondary type:'" + KClassExtKt.getFullName(type) + "' ~ " + definition);
        }
    }

    private final void removeDefinitionForTypes(BeanDefinition<?> definition) {
        KClass<?> key = definition.getPrimaryType();
        if (Intrinsics.areEqual(this.definitionsPrimaryTypes.get(key), definition)) {
            this.definitionsPrimaryTypes.remove(key);
            if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
                KoinApplication.Companion.getLogger().info("unbind type:'" + KClassExtKt.getFullName(key) + "' ~ " + definition);
            }
        }
    }

    private final void saveDefinitionForType(KClass<?> type, BeanDefinition<?> definition) {
        if (this.definitionsPrimaryTypes.get(type) != null && !definition.getOptions().getOverride()) {
            throw (Throwable)new DefinitionOverrideException("Already existing definition or try to override an existing one with type '" + type + "' and " + definition + " but has already registered " + this.definitionsPrimaryTypes.get(type));
        }
        this.definitionsPrimaryTypes.put(type, definition);
        if (KoinApplication.Companion.getLogger().isAt(Level.INFO)) {
            KoinApplication.Companion.getLogger().info("bind type:'" + KClassExtKt.getFullName(type) + "' ~ " + definition);
        }
    }

    private final void removeDefinitionForName(BeanDefinition<?> definition) {
        block2: {
            Qualifier qualifier = definition.getQualifier();
            if (qualifier == null) break block2;
            Qualifier qualifier2 = qualifier;
            boolean bl = false;
            boolean bl2 = false;
            Qualifier it = qualifier2;
            boolean bl3 = false;
            String key = it.toString();
            if (Intrinsics.areEqual(this.definitionsNames.get(key), definition)) {
                this.definitionsNames.remove(key);
                if (KoinApplication.Companion.getLogger().isAt(Level.DEBUG)) {
                    KoinApplication.Companion.getLogger().info("unbind qualifier:'" + key + "' ~ " + definition);
                }
            }
        }
    }

    private final void saveDefinitionForName(BeanDefinition<?> definition) {
        block2: {
            Qualifier qualifier = definition.getQualifier();
            if (qualifier == null) break block2;
            Qualifier qualifier2 = qualifier;
            boolean bl = false;
            boolean bl2 = false;
            Qualifier it = qualifier2;
            boolean bl3 = false;
            if (this.definitionsNames.get(it.toString()) != null && !definition.getOptions().getOverride()) {
                throw (Throwable)new DefinitionOverrideException("Already existing definition or try to override an existing one with qualifier '" + it + "' with " + definition + " but has already registered " + this.definitionsNames.get(it.toString()));
            }
            this.definitionsNames.put(it.toString(), definition);
            if (KoinApplication.Companion.getLogger().isAt(Level.INFO)) {
                KoinApplication.Companion.getLogger().info("bind qualifier:'" + definition.getQualifier() + "' ~ " + definition);
            }
        }
    }

    @Nullable
    public final BeanDefinition<?> findDefinition(@Nullable Qualifier qualifier, @NotNull KClass<?> clazz) {
        BeanDefinition<?> beanDefinition;
        BeanDefinition<?> beanDefinition2;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                beanDefinition2 = qualifier;
                if (beanDefinition2 == null) break block4;
                Qualifier qualifier2 = beanDefinition2;
                boolean bl = false;
                boolean bl2 = false;
                Qualifier it = qualifier2;
                boolean bl3 = false;
                beanDefinition2 = this.findDefinitionByName(it.toString());
                if (beanDefinition2 != null) break block5;
            }
            beanDefinition2 = beanDefinition = this.findDefinitionByType(clazz);
        }
        if (beanDefinition2 == null) {
            beanDefinition = this.findDefinitionBySecondaryType(clazz);
        }
        return beanDefinition;
    }

    @Nullable
    public static /* synthetic */ BeanDefinition findDefinition$default(BeanRegistry beanRegistry, Qualifier qualifier, KClass kClass, int n, Object object) {
        if ((n & 1) != 0) {
            qualifier = null;
        }
        return beanRegistry.findDefinition(qualifier, kClass);
    }

    private final BeanDefinition<?> findDefinitionByType(KClass<?> kClass) {
        return this.definitionsPrimaryTypes.get(kClass);
    }

    private final BeanDefinition<?> findDefinitionBySecondaryType(KClass<?> kClass) {
        BeanDefinition<?> beanDefinition;
        ArrayList<BeanDefinition<?>> foundTypes = this.definitionsSecondaryTypes.get(kClass);
        if (foundTypes != null && foundTypes.size() == 1) {
            beanDefinition = foundTypes.get(0);
        } else {
            if (foundTypes != null && foundTypes.size() > 1) {
                throw (Throwable)new NoBeanDefFoundException("Found multiple definitions for type '" + KClassExtKt.getFullName(kClass) + "': " + foundTypes + ". Please use the 'bind<P,S>()' function to bind your instance from primary and secondary types.");
            }
            beanDefinition = null;
        }
        return beanDefinition;
    }

    private final BeanDefinition<?> findDefinitionByName(String name) {
        return this.definitionsNames.get(name);
    }

    @NotNull
    public final Set<BeanDefinition<?>> findAllCreatedAtStartDefinition$koin_core() {
        return this.definitionsToCreate;
    }

    public final int size() {
        return this.definitions.size();
    }

    @Nullable
    public final BeanDefinition<?> getDefinition(@NotNull KClass<?> clazz) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Iterable $this$firstOrNull$iv = this.definitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BeanDefinition it = (BeanDefinition)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getPrimaryType(), clazz) || it.getSecondaryTypes().contains(clazz))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void close() {
        Iterable $this$forEach$iv = this.definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition it = (BeanDefinition)element$iv;
            boolean bl = false;
            it.close();
        }
        this.definitions.clear();
        this.definitionsNames.clear();
        this.definitionsPrimaryTypes.clear();
        this.definitionsToCreate.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BeanDefinition<?>> getDefinitionsForClass(@NotNull KClass<?> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Iterable $this$filter$iv = this.getAllDefinitions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BeanDefinition it = (BeanDefinition)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(it.getPrimaryType(), clazz) || it.getSecondaryTypes().contains(clazz) && !it.isKind(Kind.Scope))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public BeanRegistry() {
        BeanRegistry beanRegistry = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        beanRegistry.definitions = hashSet;
        this.definitionsNames = new ConcurrentHashMap();
        this.definitionsPrimaryTypes = new ConcurrentHashMap();
        this.definitionsSecondaryTypes = new ConcurrentHashMap();
        beanRegistry = this;
        bl = false;
        hashSet = new HashSet();
        beanRegistry.definitionsToCreate = hashSet;
    }
}

