/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeCallback;
import org.koin.error.ScopeAlreadyExistsException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/koin/core/scope/ScopeRegistry;", "", "()V", "allScopes", "Ljava/util/HashMap;", "", "Lorg/koin/core/scope/Scope;", "Lkotlin/collections/HashMap;", "registeredScopes", "scopeCallbacks", "Ljava/util/ArrayList;", "Lorg/koin/core/scope/ScopeCallback;", "Lkotlin/collections/ArrayList;", "close", "", "createAndDetachScope", "id", "createAndRegisterScope", "createScope", "deleteScope", "uuid", "getDetachScope", "getOrCreateScope", "getScope", "register", "callback", "registerScope", "scope", "saveScope", "koin-core"})
public final class ScopeRegistry {
    private final HashMap<String, Scope> registeredScopes = new HashMap();
    private final HashMap<String, Scope> allScopes = new HashMap();
    private final ArrayList<ScopeCallback> scopeCallbacks;

    @NotNull
    public final Scope getOrCreateScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope found = this.getScope(id);
        if (found == null) {
            found = this.createAndRegisterScope(id);
        }
        return found;
    }

    private final Scope createAndRegisterScope(String id) {
        Scope scope = new Scope(id, null, false, 6, null);
        this.registerScope(scope);
        this.saveScope(scope);
        Koin.Companion.getLogger().debug("[Scope] declare " + scope);
        return scope;
    }

    private final void registerScope(Scope scope) {
        Map map = this.registeredScopes;
        String string = scope.getId();
        Scope scope2 = scope;
        map.put(string, scope2);
    }

    private final void saveScope(Scope scope) {
        Map map = this.allScopes;
        String string = scope.getUuid();
        Scope scope2 = scope;
        map.put(string, scope2);
    }

    @NotNull
    public final Scope createScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope found = this.getScope(id);
        if (found != null) {
            throw (Throwable)new ScopeAlreadyExistsException("Scope id '" + id + "' is already created");
        }
        found = this.createAndRegisterScope(id);
        return found;
    }

    @Nullable
    public final Scope getScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.registeredScopes.get(id);
    }

    @Nullable
    public final Scope getDetachScope(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        return this.allScopes.get(uuid);
    }

    @NotNull
    public final Scope createAndDetachScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope scope = new Scope(id, null, true, 2, null);
        this.saveScope(scope);
        Koin.Companion.getLogger().debug("[Scope] detached " + scope);
        return scope;
    }

    public final void close() {
        Collection<Scope> collection = this.registeredScopes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"registeredScopes.values");
        Collection<Scope> collection2 = this.allScopes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"allScopes.values");
        List all = CollectionsKt.plus(collection, (Iterable)collection2);
        Iterable $receiver$iv = all;
        for (Object element$iv : $receiver$iv) {
            Scope it = (Scope)element$iv;
            it.close();
        }
        this.registeredScopes.clear();
        this.allScopes.clear();
    }

    public final void register(@NotNull ScopeCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Collection collection = this.scopeCallbacks;
        collection.add(callback);
    }

    public final void deleteScope(@NotNull String id, @NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        this.registeredScopes.remove(id);
        this.allScopes.remove(uuid);
        Iterable $receiver$iv = this.scopeCallbacks;
        for (Object element$iv : $receiver$iv) {
            ScopeCallback it = (ScopeCallback)element$iv;
            it.onClose(id, uuid);
        }
    }

    public ScopeRegistry() {
        ScopeRegistry scopeRegistry = this;
        ArrayList arrayList = new ArrayList();
        scopeRegistry.scopeCallbacks = arrayList;
    }
}

