/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.instance.holder.InstanceHolder;
import org.koin.core.instance.holder.ScopeInstanceHolder;
import org.koin.core.parameter.ParameterList;
import org.koin.core.scope.BeanDefinitionExtKt;
import org.koin.dsl.definition.BeanDefinition;
import org.koin.dsl.definition.Kind;
import org.koin.standalone.StandAloneContext;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0011\u001a\u00020\u0012\"\u0006\b\u0000\u0010\u0013\u0018\u00012\u0006\u0010\u0014\u001a\u0002H\u0013H\u0086\b\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0012J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010$\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006%"}, d2={"Lorg/koin/core/scope/Scope;", "", "id", "", "uuid", "isDetached", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getId", "()Ljava/lang/String;", "()Z", "parameters", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getParameters", "()Ljava/util/HashMap;", "getUuid", "addInstance", "", "T", "instance", "(Ljava/lang/Object;)V", "close", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "removeAddedDefinitions", "koin", "Lorg/koin/core/Koin;", "removeInstanceHolders", "removeScope", "toString", "koin-core"})
public final class Scope {
    @NotNull
    private final HashMap<String, Object> parameters;
    @NotNull
    private final String id;
    @NotNull
    private final String uuid;
    private final boolean isDetached;

    @NotNull
    public final HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    public final void close() {
        Koin koin = StandAloneContext.INSTANCE.getKoin();
        this.removeInstanceHolders(koin);
        this.removeAddedDefinitions(koin);
        this.removeScope(koin);
    }

    private final void removeScope(Koin koin) {
        koin.getKoinContext().getScopeRegistry().deleteScope(this.id, this.uuid);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAddedDefinitions(Koin koin) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = koin.getBeanRegistry().getDefinitions();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BeanDefinition it = (BeanDefinition)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)BeanDefinitionExtKt.getScope(it), (Object)this.id) && BeanDefinitionExtKt.isAddedToScope(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List addedDefinitions = (List)destination$iv$iv;
        $receiver$iv = addedDefinitions;
        for (Object element$iv : $receiver$iv) {
            BeanDefinition it = (BeanDefinition)element$iv;
            koin.getBeanRegistry().getDefinitions().remove(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeInstanceHolders(Koin koin) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = koin.getInstanceFactory().getInstances();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            InstanceHolder it = (InstanceHolder)element$iv$iv;
            if (!(it instanceof ScopeInstanceHolder && Intrinsics.areEqual((Object)((ScopeInstanceHolder)it).getScope(), (Object)this))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scopedInstances = (List)destination$iv$iv;
        $receiver$iv = scopedInstances;
        for (Object element$iv : $receiver$iv) {
            InstanceHolder it = (InstanceHolder)element$iv;
            it.release();
        }
        koin.getInstanceFactory().getInstances().removeAll(scopedInstances);
    }

    private final <T> void addInstance(T instance) {
        if (this.isDetached()) {
            String string = "Can't add extra instances on detached scope";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        boolean bl = true;
        HashMap hashMap = null;
        Kind kind = Kind.Scope;
        boolean bl2 = false;
        Function1 function1 = new Function1<ParameterList, T>(instance){
            final /* synthetic */ Object $instance;

            public final T invoke(@NotNull ParameterList it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (T)this.$instance;
            }
            {
                this.$instance = object;
                super(1);
            }
        };
        BeanDefinition definition2 = new BeanDefinition(null, Reflection.getOrCreateKotlinClass(Object.class), null, null, kind, bl2, bl, hashMap, function1, 173, null);
        BeanDefinitionExtKt.setScope(definition2, this.getId());
        BeanDefinitionExtKt.setAddedToScope(definition2);
        StandAloneContext.INSTANCE.getKoin().declare(definition2);
    }

    @NotNull
    public String toString() {
        return "Scope['" + this.id + "'-" + this.uuid + ']';
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    public final boolean isDetached() {
        return this.isDetached;
    }

    public Scope(@NotNull String id, @NotNull String uuid, boolean isDetached) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        this.id = id;
        this.uuid = uuid;
        this.isDetached = isDetached;
        Scope scope = this;
        HashMap hashMap = new HashMap();
        scope.parameters = hashMap;
    }

    public /* synthetic */ Scope(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UUID.randomUUID().toString()");
            string2 = string3;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, string2, bl);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.uuid;
    }

    public final boolean component3() {
        return this.isDetached;
    }

    @NotNull
    public final Scope copy(@NotNull String id, @NotNull String uuid, boolean isDetached) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        return new Scope(id, uuid, isDetached);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Scope copy$default(Scope scope, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = scope.id;
        }
        if ((n & 2) != 0) {
            string2 = scope.uuid;
        }
        if ((n & 4) != 0) {
            bl = scope.isDetached;
        }
        return scope.copy(string, string2, bl);
    }

    public int hashCode() {
        String string = this.id;
        String string2 = this.uuid;
        int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
        int n2 = this.isDetached ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Scope)) break block3;
                Scope scope = (Scope)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)scope.id) || !Intrinsics.areEqual((Object)this.uuid, (Object)scope.uuid) || !(this.isDetached == scope.isDetached)) break block3;
            }
            return true;
        }
        return false;
    }
}

