/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.error.MissingPropertyException;
import org.koin.ext.StringExtKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0001J\u001a\u0010\f\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001b\u0010\u0013\u001a\u00020\t2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0015\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0019J!\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u0002H\u0018\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u001fJ\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u001fH\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/koin/core/property/PropertyRegistry;", "", "()V", "properties", "Ljava/util/HashMap;", "", "getProperties", "()Ljava/util/HashMap;", "add", "", "key", "value", "addAll", "props", "", "clear", "containsKey", "", "delete", "deleteAll", "keys", "", "([Ljava/lang/String;)V", "getProperty", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getValue", "import", "", "Ljava/util/Properties;", "prepareImport", "koin-core"})
public final class PropertyRegistry {
    @NotNull
    private final HashMap<String, Object> properties = new HashMap();

    @NotNull
    public final HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public final <T> T getProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        T t = this.getValue(key);
        if (t == null) {
            throw (Throwable)new MissingPropertyException("Can't find property '" + key + '\'');
        }
        return t;
    }

    @Nullable
    public final <T> T getValue(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.properties.get(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    public final <T> T getProperty(@NotNull String key, T defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        T t = this.getValue(key);
        if (t == null) {
            t = defaultValue;
        }
        return t;
    }

    public final void addAll(@NotNull Map<String, ? extends Object> props) {
        Intrinsics.checkParameterIsNotNull(props, (String)"props");
        Map map = this.properties;
        map.putAll(props);
    }

    public final int import(@NotNull Properties properties) {
        Map<String, Object> convertedProperties;
        Map<String, Object> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        Map<String, Object> map = $receiver$iv = (convertedProperties = this.prepareImport(properties));
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> $key_value;
            Map.Entry<String, Object> entry = $key_value = (element$iv = iterator.next());
            String key = entry.getKey();
            entry = $key_value;
            Object value = entry.getValue();
            this.add(key, value);
        }
        Map<String, Object> map2 = convertedProperties;
        return map2.size();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> prepareImport(Properties properties) {
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)properties;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            void $key_value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            void var9_9 = $key_value;
            Object key = var9_9.getKey();
            var9_9 = $key_value;
            Object value = var9_9.getValue();
            Object k = key;
            if (k == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)k;
            Object v = value;
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"value");
            Pair pair = new Pair((Object)string, StringExtKt.checkedStringValue(v));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.properties.containsKey(key);
    }

    public final void add(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map = this.properties;
        Pair pair = new Pair((Object)key, value);
        map.put(pair.getFirst(), pair.getSecond());
    }

    public final void delete(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.properties.remove(key);
    }

    public final void deleteAll(@NotNull String[] keys) {
        Intrinsics.checkParameterIsNotNull((Object)keys, (String)"keys");
        String[] $receiver$iv = keys;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $receiver$iv[i];
            this.delete(it);
        }
    }

    public final void clear() {
        this.properties.clear();
    }
}

