/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.stack;

import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.stack.ResolutionStack;
import org.koin.dsl.definition.BeanDefinition;
import org.koin.error.DependencyResolutionException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010\n\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006J \u0010\u0011\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/koin/core/stack/ResolutionStack;", "", "()V", "stack", "Ljava/util/Stack;", "Lorg/koin/dsl/definition/BeanDefinition;", "Lorg/koin/core/stack/StackItem;", "checkStackEnter", "", "beanDefinition", "checkStackExit", "clear", "indent", "", "isEmpty", "", "last", "resolve", "execution", "Lkotlin/Function0;", "koin-core"})
public final class ResolutionStack {
    private final Stack<BeanDefinition<?>> stack = new Stack();

    public final void resolve(@NotNull BeanDefinition<?> beanDefinition, @NotNull Function0<Unit> execution) {
        Intrinsics.checkParameterIsNotNull(beanDefinition, (String)"beanDefinition");
        Intrinsics.checkParameterIsNotNull(execution, (String)"execution");
        this.checkStackEnter(beanDefinition);
        this.stack.add(beanDefinition);
        execution.invoke();
        this.checkStackExit(beanDefinition);
    }

    private final void checkStackEnter(BeanDefinition<?> beanDefinition) throws DependencyResolutionException {
        boolean bl;
        block4: {
            Iterable $receiver$iv = this.stack;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    BeanDefinition it = (BeanDefinition)element$iv;
                    if (!Intrinsics.areEqual((Object)it, beanDefinition)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new DependencyResolutionException("Cyclic call while resolving " + beanDefinition + ". Definition is already in resolution in current call:\n\t" + CollectionsKt.joinToString$default((Iterable)this.stack, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final void checkStackExit(BeanDefinition<?> beanDefinition) throws IllegalStateException {
        try {
            BeanDefinition<?> beanDefinition2 = this.stack.pop();
            Intrinsics.checkExpressionValueIsNotNull(beanDefinition2, (String)"stack.pop()");
            BeanDefinition<?> head = beanDefinition2;
            if (Intrinsics.areEqual(head, beanDefinition) ^ true) {
                this.stack.clear();
                throw (Throwable)new DependencyResolutionException("Stack resolution error : was " + head + " but should be " + beanDefinition);
            }
        }
        catch (EmptyStackException e) {
            throw (Throwable)new DependencyResolutionException("Stack resolution error while resolving " + beanDefinition);
        }
    }

    @NotNull
    public final String indent() {
        return CollectionsKt.joinToString$default((Iterable)this.stack, (CharSequence)"", null, null, (int)0, null, (Function1)indent.1.INSTANCE, (int)30, null);
    }

    @Nullable
    public final BeanDefinition<?> last() {
        return this.stack.size() > 0 ? this.stack.peek() : null;
    }

    public final void clear() {
        this.stack.clear();
    }

    public final boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

