/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.scope.Scope;
import org.koin.core.scope.ScopeCallback;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/koin/core/scope/ScopeRegistry;", "", "()V", "scopeCallbacks", "Ljava/util/ArrayList;", "Lorg/koin/core/scope/ScopeCallback;", "Lkotlin/collections/ArrayList;", "scopes", "Ljava/util/HashMap;", "", "Lorg/koin/core/scope/Scope;", "Lkotlin/collections/HashMap;", "close", "", "closeScope", "scope", "createScope", "id", "getOrCreateScope", "getScope", "register", "callback", "koin-core"})
public final class ScopeRegistry {
    private final HashMap<String, Scope> scopes = new HashMap();
    private final ArrayList<ScopeCallback> scopeCallbacks;

    @NotNull
    public final Scope getOrCreateScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope found = this.getScope(id);
        if (found == null) {
            found = new Scope(id, this);
            Map map = this.scopes;
            Scope scope = found;
            map.put(id, scope);
            Koin.Companion.getLogger().info("[Scope] create " + id);
        }
        return found;
    }

    @NotNull
    public final Scope createScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Scope found = this.getScope(id);
        if (found != null) {
            String string = "Already created scope with id '" + id + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        found = new Scope(id, this);
        Map map = this.scopes;
        Scope scope = found;
        map.put(id, scope);
        Koin.Companion.getLogger().info("[Scope] create " + id);
        return found;
    }

    @Nullable
    public final Scope getScope(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.scopes.get(id);
    }

    public final void closeScope(@NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        String id = scope.getId();
        this.scopes.remove(id);
        Iterable $receiver$iv = this.scopeCallbacks;
        for (Object element$iv : $receiver$iv) {
            ScopeCallback it = (ScopeCallback)element$iv;
            it.onClose(id);
        }
    }

    public final void close() {
        Collection<Scope> collection = this.scopes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"scopes.values");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            Scope it = (Scope)element$iv;
            it.getHolders$koin_core().clear();
        }
        this.scopes.clear();
        Koin.Companion.getLogger().debug("[Close] Closing all scopes");
    }

    public final void register(@NotNull ScopeCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Koin.Companion.getLogger().info("[Scope] callback registering with " + callback);
        Collection collection = this.scopeCallbacks;
        collection.add(callback);
    }

    public ScopeRegistry() {
        ScopeRegistry scopeRegistry = this;
        ArrayList arrayList = new ArrayList();
        scopeRegistry.scopeCallbacks = arrayList;
    }
}

