/*
 * Decompiled with CFR 0.152.
 */
package org.koin.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.log.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/koin/log/PrintLogger;", "Lorg/koin/log/Logger;", "showDebug", "", "(Z)V", "df", "Ljava/text/SimpleDateFormat;", "date", "", "debug", "", "msg", "err", "info", "koin-core"})
public final class PrintLogger
implements Logger {
    private final SimpleDateFormat df;
    private final boolean showDebug;

    private final String date() {
        return this.df.format(new Date()).toString();
    }

    @Override
    public void debug(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (this.showDebug) {
            String string = this.date() + " (KOIN)::[d] " + msg;
            System.out.println((Object)string);
        }
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        String string = this.date() + " (KOIN)::[i] " + msg;
        System.out.println((Object)string);
    }

    @Override
    public void err(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        System.err.println(this.date() + " (KOIN)::[e] " + msg);
    }

    public PrintLogger(boolean showDebug) {
        this.showDebug = showDebug;
        this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.info("[PrintLogger] display debug = " + this.showDebug);
    }

    public /* synthetic */ PrintLogger(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public PrintLogger() {
        this(false, 1, null);
    }
}

