/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.path;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.dsl.path.Path;
import org.koin.error.BadPathException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/koin/core/path/PathRegistry;", "", "()V", "paths", "Ljava/util/HashSet;", "Lorg/koin/dsl/path/Path;", "Lkotlin/collections/HashSet;", "getPaths", "()Ljava/util/HashSet;", "root", "clear", "", "getAllPathsFrom", "", "path", "", "getPath", "makePath", "parentPath", "savePath", "koin-core"})
public final class PathRegistry {
    @NotNull
    private final HashSet<Path> paths;
    private final Path root;

    @NotNull
    public final HashSet<Path> getPaths() {
        return this.paths;
    }

    @NotNull
    public final Path getPath(@NotNull String path) {
        Path path2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (Intrinsics.areEqual((Object)path, (Object)"")) {
            path2 = this.root;
        } else {
            List paths = StringsKt.split$default((CharSequence)path, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            Path modulePath = null;
            Iterable $receiver$iv = paths;
            for (Object element$iv : $receiver$iv) {
                Object v1;
                block5: {
                    String current = (String)element$iv;
                    Iterable $receiver$iv2 = this.paths;
                    for (Object element$iv2 : $receiver$iv2) {
                        Path it = (Path)element$iv2;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)current)) continue;
                        v1 = element$iv2;
                        break block5;
                    }
                    v1 = null;
                }
                Object var12_12 = v1;
                modulePath = var12_12;
            }
            path2 = modulePath;
            if (path2 == null) {
                throw (Throwable)new BadPathException("no module path found for '" + path + '\'');
            }
        }
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path makePath(@NotNull String path, @Nullable String parentPath) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!Intrinsics.areEqual((Object)path, (Object)"")) {
            void $receiver$iv;
            Path initial$iv;
            CharSequence charSequence = parentPath;
            String completePath = !(charSequence == null || charSequence.length() == 0) ? parentPath + '.' + path : path;
            List paths = StringsKt.split$default((CharSequence)completePath, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            Iterable iterable = paths;
            Path accumulator$iv = initial$iv = this.root;
            for (Object element$iv : $receiver$iv) {
                void s;
                String string = (String)element$iv;
                Path acc = accumulator$iv;
                accumulator$iv = new Path((String)s, acc);
            }
            Path modulePath = accumulator$iv;
            return modulePath;
        }
        return this.root;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path makePath$default(PathRegistry pathRegistry, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pathRegistry.makePath(string, string2);
    }

    public final void savePath(@NotNull Path path) {
        block0: {
            Path path2;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.paths.add(path);
            Path path3 = path.getParent();
            if (path3 == null) break block0;
            Path it = path2 = path3;
            this.savePath(it);
        }
    }

    @NotNull
    public final Set<Path> getAllPathsFrom(@NotNull String path) {
        Path it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path mainPath = this.getPath(path);
        Iterable iterable = $receiver$iv = (Iterable)this.paths;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Path)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getParent(), (Object)mainPath)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List firstChild = (List)destination$iv$iv;
        $receiver$iv = firstChild;
        Set set = SetsKt.plus((Set)SetsKt.setOf((Object)mainPath), (Iterable)firstChild);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Path)element$iv$iv;
            Iterable list$iv$iv = this.getAllPathsFrom(it.getName());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return SetsKt.plus((Set)set, (Iterable)list);
    }

    public final void clear() {
        this.paths.clear();
        Collection collection = this.paths;
        Path path = this.root;
        collection.add(path);
    }

    public PathRegistry() {
        PathRegistry pathRegistry = this;
        HashSet hashSet = new HashSet();
        pathRegistry.paths = hashSet;
        this.root = Path.Companion.root();
        Collection collection = this.paths;
        Path path = this.root;
        collection.add(path);
    }
}

